/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.ops4j.pax.web.service.undertow.internal.Context;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleRevision;

public class ResourceServlet
extends HttpServlet
implements ResourceManager {
    private final Context context;
    private final HttpHandler handler;
    private final String alias;
    private final String name;
    private List<String> welcomePages;

    public ResourceServlet(Context context, String alias, String name) {
        this.context = context;
        this.alias = alias;
        this.name = "/".equals(name) ? "" : name;
        this.handler = new ResourceHandler((ResourceManager)this, new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                ServletRequestContext src = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                src.getOriginalResponse().sendError(404);
            }
        });
    }

    protected void service(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        HttpServletRequest realRequest = request;
        while (realRequest instanceof HttpServletRequestWrapper) {
            if (((HttpServletRequestWrapper)realRequest).getRequest() != null) {
                realRequest = ((HttpServletRequestWrapper)realRequest).getRequest();
                continue;
            }
            throw new IllegalStateException("Wrapped request " + realRequest.getClass().getName() + " doesn't wrap any actual servlet");
        }
        if (!(realRequest instanceof HttpServletRequestImpl)) {
            Bundle bundle;
            String msg;
            String string = msg = realRequest == null ? ", it is null" : ", it is an instance of " + realRequest.getClass().getName() + ", loaded from " + FrameworkUtil.getBundle(realRequest.getClass());
            if (realRequest != null && (bundle = FrameworkUtil.getBundle(realRequest.getClass())) != null) {
                msg = msg + ", revision: " + bundle.adapt(BundleRevision.class);
            }
            throw new IllegalStateException("Request is not an instance of " + HttpServletRequestImpl.class.getName() + msg);
        }
        HttpServerExchange exchange = ((HttpServletRequestImpl)realRequest).getExchange();
        try {
            this.handler.handleRequest(exchange);
        }
        catch (IOException | ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public Resource getResource(String path) throws IOException {
        String contextName = this.context.getContextModel().getContextName();
        if (contextName.isEmpty()) {
            contextName = "/";
        }
        String mapping = path;
        if (!"/".equals(this.alias)) {
            mapping = mapping.substring(this.alias.length());
        }
        if (!this.name.isEmpty() && !"default".equals(this.name)) {
            mapping = this.name + mapping;
        }
        return this.context.getResource(mapping);
    }

    public boolean isResourceChangeListenerSupported() {
        return false;
    }

    public void registerResourceChangeListener(ResourceChangeListener listener) {
    }

    public void removeResourceChangeListener(ResourceChangeListener listener) {
    }

    public void close() throws IOException {
    }

    public void configureWelcomeFiles(List<String> welcomePages) {
        this.welcomePages = welcomePages;
        ((ResourceHandler)this.handler).setWelcomeFiles(new String[0]);
        ((ResourceHandler)this.handler).addWelcomeFiles(welcomePages.toArray(new String[welcomePages.size()]));
    }
}

