/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal.configuration.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="serverType", namespace="urn:jboss:domain:undertow:4.0", propOrder={"httpListener", "httpsListener", "host"})
public class Server {
    @XmlAttribute
    private String name;
    @XmlElement(name="http-listener")
    private HttpListener httpListener;
    @XmlElement(name="https-listener")
    private HttpsListener httpsListener;
    @XmlElement
    private Host host;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HttpListener getHttpListener() {
        return this.httpListener;
    }

    public void setHttpListener(HttpListener httpListener) {
        this.httpListener = httpListener;
    }

    public HttpsListener getHttpsListener() {
        return this.httpsListener;
    }

    public void setHttpsListener(HttpsListener httpsListener) {
        this.httpsListener = httpsListener;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\n");
        sb.append("\t\t\tname: ").append(this.name);
        sb.append("\n\t\t\thttp listener: ").append(this.httpListener);
        sb.append("\n\t\t\thttps listener: ").append(this.httpsListener);
        sb.append("\n\t\t\thost: ").append(this.host);
        sb.append("\n\t\t}");
        return sb.toString();
    }

    @XmlType(name="hostType", namespace="urn:jboss:domain:undertow:4.0", propOrder={"location", "accessLog", "filterRef"})
    public static class Host {
        @XmlAttribute
        private String name;
        @XmlAttribute
        private String alias;
        @XmlElement
        private List<Location> location = new ArrayList<Location>();
        @XmlElement(name="access-log")
        private AccessLog accessLog;
        @XmlElement(name="filter-ref")
        private List<FilterRef> filterRef = new ArrayList<FilterRef>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public List<Location> getLocation() {
            return this.location;
        }

        public AccessLog getAccessLog() {
            return this.accessLog;
        }

        public void setAccessLog(AccessLog accessLog) {
            this.accessLog = accessLog;
        }

        public List<FilterRef> getFilterRef() {
            return this.filterRef;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append("name: ").append(this.name);
            sb.append(", alias: ").append(this.alias);
            sb.append(", locations: ").append(this.location);
            sb.append(", access log: ").append(this.accessLog);
            sb.append(", filter refs: ").append(this.filterRef);
            sb.append(" }");
            return sb.toString();
        }

        @XmlType(name="filter-refType", namespace="urn:jboss:domain:undertow:4.0")
        public static class FilterRef {
            @XmlAttribute
            private String name;
            @XmlAttribute
            private String predicate;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getPredicate() {
                return this.predicate;
            }

            public void setPredicate(String predicate) {
                this.predicate = predicate;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("{ ");
                sb.append("name: ").append(this.name);
                sb.append("predicate: ").append(this.predicate);
                sb.append(" }");
                return sb.toString();
            }
        }

        @XmlType(name="accessLogType", namespace="urn:jboss:domain:undertow:4.0")
        public static class AccessLog {
            @XmlAttribute
            private String pattern = "common";
            @XmlAttribute
            private String directory;
            @XmlAttribute
            private String prefix = "access_log.";
            @XmlAttribute
            private String suffix = "log";
            @XmlAttribute
            private String rotate = "true";

            public String getPattern() {
                return this.pattern;
            }

            public void setPattern(String pattern) {
                this.pattern = pattern;
            }

            public String getDirectory() {
                return this.directory;
            }

            public void setDirectory(String directory) {
                this.directory = directory;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public void setPrefix(String prefix) {
                this.prefix = prefix;
            }

            public String getSuffix() {
                return this.suffix;
            }

            public void setSuffix(String suffix) {
                this.suffix = suffix;
            }

            public String getRotate() {
                return this.rotate;
            }

            public void setRotate(String rotate) {
                this.rotate = rotate;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("{ ");
                sb.append("pattern: ").append(this.pattern).append('\'');
                sb.append(", directory: ").append(this.directory);
                sb.append(", prefix: ").append(this.prefix);
                sb.append(", suffix: ").append(this.suffix);
                sb.append(", rotate: ").append(this.rotate);
                sb.append(" }");
                return sb.toString();
            }
        }

        @XmlType(name="locationType", namespace="urn:jboss:domain:undertow:4.0")
        public static class Location {
            @XmlAttribute
            private String name;
            @XmlAttribute
            private String handler;
            @XmlElement(name="filter-ref")
            private List<FilterRef> filterRef = new ArrayList<FilterRef>();

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getHandler() {
                return this.handler;
            }

            public void setHandler(String handler) {
                this.handler = handler;
            }

            public List<FilterRef> getFilterRef() {
                return this.filterRef;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("{ ");
                sb.append("name: ").append(this.name);
                sb.append(", handler: ").append(this.handler);
                sb.append(", filterRef: ").append(this.filterRef);
                sb.append(" }");
                return sb.toString();
            }
        }
    }

    @XmlType(name="https-listener-type", namespace="urn:jboss:domain:undertow:4.0")
    public static class HttpsListener
    extends HttpListener {
        @XmlAttribute(name="ssl-context")
        private String sslContext;
        @XmlAttribute(name="security-realm")
        private String securityRealm;
        @XmlAttribute(name="verify-client")
        private String verifyClient;
        @XmlAttribute(name="enabled-cipher-suites")
        private List<String> enabledCipherSuites = new ArrayList<String>();
        @XmlAttribute(name="enabled-protocols")
        private List<String> enabledProtocols = new ArrayList<String>();

        public String getSslContext() {
            return this.sslContext;
        }

        public void setSslContext(String sslContext) {
            this.sslContext = sslContext;
        }

        public String getSecurityRealm() {
            return this.securityRealm;
        }

        public void setSecurityRealm(String securityRealm) {
            this.securityRealm = securityRealm;
        }

        public String getVerifyClient() {
            return this.verifyClient;
        }

        public void setVerifyClient(String verifyClient) {
            this.verifyClient = verifyClient;
        }

        public List<String> getEnabledCipherSuites() {
            return this.enabledCipherSuites;
        }

        public List<String> getEnabledProtocols() {
            return this.enabledProtocols;
        }

        @Override
        public String getProxyAddressForwarding() {
            return this.proxyAddressForwarding;
        }

        @Override
        public void setProxyAddressForwarding(String proxyAddressForwarding) {
            this.proxyAddressForwarding = proxyAddressForwarding;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append("name: ").append(this.name);
            sb.append(", receive buffer: ").append(this.receiveBuffer);
            sb.append(", send buffer: ").append(this.sendBuffer);
            sb.append(", tcp backlog: ").append(this.tcpBacklog);
            sb.append(", tcp KeepAlive: ").append(this.tcpKeepAlive);
            sb.append(", read timeoout: ").append(this.readTimeoout);
            sb.append(", write timeoout: ").append(this.writeTimeoout);
            sb.append(", max connections: ").append(this.maxConnections);
            sb.append(", socket binding name: ").append(this.socketBindingName);
            sb.append(", buffer pool name: ").append(this.bufferPoolName);
            sb.append(", enabled: ").append(this.enabled);
            sb.append(", url charset: ").append(this.urlCharset);
            sb.append(", secure: ").append(this.secure);
            sb.append(", security realm: ").append(this.securityRealm);
            sb.append(", verify client: ").append(this.verifyClient);
            sb.append(", enabled cipher suites: ").append(this.enabledCipherSuites);
            sb.append(", enabled protocols: ").append(this.enabledProtocols);
            sb.append(", proxy address forwarding: ").append(this.proxyAddressForwarding);
            sb.append(", peer host lookup: ").append(this.peerHostLookup);
            sb.append(", disallowed methods: ").append(this.disallowedMethods);
            sb.append(" }");
            return sb.toString();
        }
    }

    @XmlType(name="http-listener-type", namespace="urn:jboss:domain:undertow:4.0")
    public static class HttpListener
    extends Listener {
        @XmlAttribute(name="redirect-socket")
        private String redirectSocket;
        @XmlAttribute(name="proxy-address-forwarding")
        protected String proxyAddressForwarding;
        @XmlAttribute(name="resolve-peer-address")
        protected String peerHostLookup;

        public String getRedirectSocket() {
            return this.redirectSocket;
        }

        public void setRedirectSocket(String redirectSocket) {
            this.redirectSocket = redirectSocket;
        }

        public String getProxyAddressForwarding() {
            return this.proxyAddressForwarding;
        }

        public void setProxyAddressForwarding(String proxyAddressForwarding) {
            this.proxyAddressForwarding = proxyAddressForwarding;
        }

        public String getPeerHostLookup() {
            return this.peerHostLookup;
        }

        public void setPeerHostLookup(String peerHostLookup) {
            this.peerHostLookup = peerHostLookup;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append("name: ").append(this.name);
            sb.append(", receive buffer: ").append(this.receiveBuffer);
            sb.append(", send buffer: ").append(this.sendBuffer);
            sb.append(", tcp backlog: ").append(this.tcpBacklog);
            sb.append(", tcp KeepAlive: ").append(this.tcpKeepAlive);
            sb.append(", read timeoout: ").append(this.readTimeoout);
            sb.append(", write timeoout: ").append(this.writeTimeoout);
            sb.append(", max connections: ").append(this.maxConnections);
            sb.append(", socket binding name: ").append(this.socketBindingName);
            sb.append(", buffer pool name: ").append(this.bufferPoolName);
            sb.append(", enabled: ").append(this.enabled);
            sb.append(", url charset: ").append(this.urlCharset);
            sb.append(", secure: ").append(this.secure);
            sb.append(", redirect socket: ").append(this.redirectSocket);
            sb.append(", proxy address forwarding: ").append(this.proxyAddressForwarding);
            sb.append(", peer host lookup: ").append(this.peerHostLookup);
            sb.append(", disallowed methods: ").append(this.disallowedMethods);
            sb.append(" }");
            return sb.toString();
        }
    }

    @XmlType(name="listener-type", namespace="urn:jboss:domain:undertow:4.0")
    public static abstract class Listener
    extends SocketOptions {
        @XmlAttribute
        protected String name;
        @XmlAttribute(name="socket-binding")
        protected String socketBindingName;
        @XmlAttribute(name="buffer-pool")
        protected String bufferPoolName = "default";
        @XmlAttribute
        protected boolean enabled = true;
        @XmlAttribute(name="url-charset")
        protected String urlCharset = "UTF-8";
        @XmlAttribute
        protected boolean secure = false;
        @XmlAttribute(name="record-request-start-time")
        protected boolean recordRequestStartTime = false;
        @XmlAttribute(name="disallowed-methods")
        protected List<String> disallowedMethods = new ArrayList<String>(Collections.singletonList("TRACE"));

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSocketBindingName() {
            return this.socketBindingName;
        }

        public void setSocketBindingName(String socketBindingName) {
            this.socketBindingName = socketBindingName;
        }

        public String getBufferPoolName() {
            return this.bufferPoolName;
        }

        public void setBufferPoolName(String bufferPoolName) {
            this.bufferPoolName = bufferPoolName;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getUrlCharset() {
            return this.urlCharset;
        }

        public void setUrlCharset(String urlCharset) {
            this.urlCharset = urlCharset;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public boolean isRecordRequestStartTime() {
            return this.recordRequestStartTime;
        }

        public void setRecordRequestStartTime(boolean recordRequestStartTime) {
            this.recordRequestStartTime = recordRequestStartTime;
        }

        public List<String> getDisallowedMethods() {
            return this.disallowedMethods;
        }
    }

    @XmlType(name="socket-options-type", namespace="urn:jboss:domain:undertow:4.0")
    public static abstract class SocketOptions {
        @XmlAttribute(name="receive-buffer")
        protected int receiveBuffer = 0;
        @XmlAttribute(name="send-buffer")
        protected int sendBuffer = 0;
        @XmlAttribute(name="tcp-backlog")
        protected int tcpBacklog = 10000;
        @XmlAttribute(name="tcp-keep-alive")
        protected boolean tcpKeepAlive = false;
        @XmlAttribute(name="read-timeout")
        protected long readTimeoout = 0L;
        @XmlAttribute(name="write-timeout")
        protected long writeTimeoout = 0L;
        @XmlAttribute(name="max-connections")
        protected int maxConnections = 0;

        public int getReceiveBuffer() {
            return this.receiveBuffer;
        }

        public void setReceiveBuffer(int receiveBuffer) {
            this.receiveBuffer = receiveBuffer;
        }

        public int getSendBuffer() {
            return this.sendBuffer;
        }

        public void setSendBuffer(int sendBuffer) {
            this.sendBuffer = sendBuffer;
        }

        public int getTcpBacklog() {
            return this.tcpBacklog;
        }

        public void setTcpBacklog(int tcpBacklog) {
            this.tcpBacklog = tcpBacklog;
        }

        public boolean isTcpKeepAlive() {
            return this.tcpKeepAlive;
        }

        public void setTcpKeepAlive(boolean tcpKeepAlive) {
            this.tcpKeepAlive = tcpKeepAlive;
        }

        public long getReadTimeoout() {
            return this.readTimeoout;
        }

        public void setReadTimeoout(long readTimeoout) {
            this.readTimeoout = readTimeoout;
        }

        public long getWriteTimeoout() {
            return this.writeTimeoout;
        }

        public void setWriteTimeoout(long writeTimeoout) {
            this.writeTimeoout = writeTimeoout;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append("receive buffer: ").append(this.receiveBuffer);
            sb.append(", send buffer: ").append(this.sendBuffer);
            sb.append(", tcp backlog: ").append(this.tcpBacklog);
            sb.append(", tcp KeepAlive: ").append(this.tcpKeepAlive);
            sb.append(", read timeoout: ").append(this.readTimeoout);
            sb.append(", write timeoout: ").append(this.writeTimeoout);
            sb.append(", max connections: ").append(this.maxConnections);
            sb.append(" }");
            return sb.toString();
        }
    }
}

