/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal.configuration.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.ops4j.pax.web.service.undertow.internal.configuration.model.Interface;
import org.ops4j.pax.web.service.undertow.internal.configuration.model.IoSubsystem;
import org.ops4j.pax.web.service.undertow.internal.configuration.model.SecurityRealm;
import org.ops4j.pax.web.service.undertow.internal.configuration.model.SocketBinding;
import org.ops4j.pax.web.service.undertow.internal.configuration.model.UndertowSubsystem;

@XmlRootElement(name="undertow")
@XmlType(name="UndertowType", propOrder={"ioSubsystem", "subsystem", "securityRealms", "interfaces", "socketBindings"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class UndertowConfiguration {
    @XmlElement(name="subsystem", namespace="urn:jboss:domain:io:3.0")
    private IoSubsystem ioSubsystem;
    @XmlElement(namespace="urn:jboss:domain:undertow:4.0")
    private UndertowSubsystem subsystem;
    @XmlElement(name="security-realm", namespace="urn:org.ops4j.pax.web:undertow:1.0")
    private List<SecurityRealm> securityRealms = new ArrayList<SecurityRealm>();
    @XmlElement(name="interface")
    private List<Interface> interfaces = new ArrayList<Interface>();
    @XmlElement(name="socket-binding")
    private List<SocketBinding> socketBindings = new ArrayList<SocketBinding>();
    @XmlTransient
    private Map<String, SecurityRealm> securityRealmsMap = new HashMap<String, SecurityRealm>();
    @XmlTransient
    private Map<String, Interface> interfacesMap = new HashMap<String, Interface>();
    @XmlTransient
    private Map<String, SocketBinding> socketBindingsMap = new HashMap<String, SocketBinding>();
    @XmlTransient
    private Map<String, UndertowSubsystem.FileHandler> handlersMap = new HashMap<String, UndertowSubsystem.FileHandler>();
    @XmlTransient
    private Map<String, UndertowSubsystem.AbstractFilter> filtersMap = new HashMap<String, UndertowSubsystem.AbstractFilter>();
    @XmlTransient
    private Map<String, IoSubsystem.Worker> workers = new HashMap<String, IoSubsystem.Worker>();
    @XmlTransient
    private Map<String, IoSubsystem.BufferPool> bufferPools = new HashMap<String, IoSubsystem.BufferPool>();

    public synchronized void init() {
        for (SocketBinding socketBinding : this.socketBindings) {
            this.socketBindingsMap.put(socketBinding.getName(), socketBinding);
        }
        for (SecurityRealm securityRealm : this.securityRealms) {
            this.securityRealmsMap.put(securityRealm.getName(), securityRealm);
        }
        for (Interface interface_ : this.interfaces) {
            this.interfacesMap.put(interface_.getName(), interface_);
        }
        if (this.subsystem != null) {
            for (UndertowSubsystem.FileHandler fileHandler : this.subsystem.getFileHandlers()) {
                this.handlersMap.put(fileHandler.getName(), fileHandler);
            }
            if (this.subsystem.getFilters() != null) {
                for (UndertowSubsystem.ResponseHeaderFilter responseHeaderFilter : this.subsystem.getFilters().getResponseHeaders()) {
                    this.filtersMap.put(responseHeaderFilter.getName(), responseHeaderFilter);
                }
                for (UndertowSubsystem.RequestLimitFilter requestLimitFilter : this.subsystem.getFilters().getRequestLimits()) {
                    this.filtersMap.put(requestLimitFilter.getName(), requestLimitFilter);
                }
                for (UndertowSubsystem.ErrorPageFilter errorPageFilter : this.subsystem.getFilters().getErrorPages()) {
                    this.filtersMap.put(errorPageFilter.getName(), errorPageFilter);
                }
                for (UndertowSubsystem.CustomFilter customFilter : this.subsystem.getFilters().getCustomFilters()) {
                    this.filtersMap.put(customFilter.getName(), customFilter);
                }
                for (UndertowSubsystem.ExpressionFilter expressionFilter : this.subsystem.getFilters().getExpressionFilters()) {
                    this.filtersMap.put(expressionFilter.getName(), expressionFilter);
                }
            }
        }
        if (this.ioSubsystem != null) {
            for (IoSubsystem.Worker worker : this.ioSubsystem.getWorkers()) {
                this.workers.put(worker.getName(), worker);
            }
            for (IoSubsystem.BufferPool bufferPool : this.ioSubsystem.getBuferPools()) {
                this.bufferPools.put(bufferPool.getName(), bufferPool);
            }
        }
    }

    public UndertowSubsystem.FileHandler handler(String name) {
        return this.handlersMap.get(name);
    }

    public UndertowSubsystem.AbstractFilter filter(String name) {
        return this.filtersMap.get(name);
    }

    public SocketBinding socketBinding(String name) {
        return this.socketBindingsMap.get(name);
    }

    public Interface interfaceRef(String name) {
        return this.interfacesMap.get(name);
    }

    public SecurityRealm securityRealm(String name) {
        return this.securityRealmsMap.get(name);
    }

    public IoSubsystem.Worker worker(String name) {
        return this.workers.get(name);
    }

    public IoSubsystem.BufferPool bufferPool(String name) {
        return this.bufferPools.get(name);
    }

    public BindingInfo bindingInfo(String socketBindingName) {
        SocketBinding sb = this.socketBinding(socketBindingName);
        if (sb == null) {
            throw new IllegalArgumentException("Can't find socket binding with name \"" + socketBindingName + "\"");
        }
        Interface iface = this.interfaceRef(sb.getInterfaceRef());
        if (iface == null) {
            throw new IllegalArgumentException("Can't find interface with name \"" + sb.getInterfaceRef() + "\"");
        }
        BindingInfo result = new BindingInfo(sb.getPort());
        for (Interface.InetAddress address : iface.getAddresses()) {
            result.getAddresses().add(address.getIp());
        }
        return result;
    }

    public void setSubsystem(UndertowSubsystem subsystem) {
        this.subsystem = subsystem;
    }

    public UndertowSubsystem getSubsystem() {
        return this.subsystem;
    }

    public IoSubsystem getIoSubsystem() {
        return this.ioSubsystem;
    }

    public void setIoSubsystem(IoSubsystem ioSubsystem) {
        this.ioSubsystem = ioSubsystem;
    }

    public List<SecurityRealm> getSecurityRealms() {
        return this.securityRealms;
    }

    public List<Interface> getInterfaces() {
        return this.interfaces;
    }

    public List<SocketBinding> getSocketBindings() {
        return this.socketBindings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n\tsubsystem: " + this.subsystem + "\n");
        sb.append("\tsecurity realms: {");
        for (SecurityRealm sr : this.securityRealms) {
            sb.append("\n\t\t" + sr);
        }
        sb.append("\n\t}\n\tinterfaces: {");
        for (Interface i : this.interfaces) {
            sb.append("\n\t\t" + i);
        }
        sb.append("\n\t}\n\tsocket bindings: {");
        for (SocketBinding b : this.socketBindings) {
            sb.append("\n\t\t" + b);
        }
        sb.append("\n\t}\n\tworkers: {");
        for (IoSubsystem.Worker w : this.workers.values()) {
            sb.append("\n\t\t" + w);
        }
        sb.append("\n\t}\n\tbuffer pools: {");
        for (IoSubsystem.BufferPool bp : this.bufferPools.values()) {
            sb.append("\n\t\t" + bp);
        }
        sb.append("\n\t}\n}\n");
        return sb.toString();
    }

    public static class BindingInfo {
        private List<String> addresses = new ArrayList<String>();
        private int port;

        public BindingInfo(int port) {
            this.port = port;
        }

        public List<String> getAddresses() {
            return this.addresses;
        }

        public int getPort() {
            return this.port;
        }
    }
}

