/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal.configuration.model;

import io.undertow.Handlers;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.RequestLimitingHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.server.handlers.builder.HandlerParser;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.ops4j.pax.web.service.undertow.internal.configuration.model.Server;
import org.ops4j.pax.web.service.undertow.internal.configuration.model.ServletContainer;

@XmlType(name="undertow-subsystemType", namespace="urn:jboss:domain:undertow:4.0", propOrder={"bufferCache", "server", "servletContainer", "fileHandlers", "filters"})
public class UndertowSubsystem {
    @XmlElement(name="buffer-cache")
    private BufferCache bufferCache;
    @XmlElement
    private Server server;
    @XmlElement(name="servlet-container")
    private ServletContainer servletContainer;
    @XmlElementWrapper(name="handlers")
    @XmlElement(name="file")
    private List<FileHandler> fileHandlers = new ArrayList<FileHandler>();
    @XmlElement
    private Filters filters;

    public BufferCache getBufferCache() {
        return this.bufferCache;
    }

    public void setBufferCache(BufferCache bufferCache) {
        this.bufferCache = bufferCache;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public ServletContainer getServletContainer() {
        return this.servletContainer;
    }

    public void setServletContainer(ServletContainer servletContainer) {
        this.servletContainer = servletContainer;
    }

    public Filters getFilters() {
        return this.filters;
    }

    public void setFilters(Filters filters) {
        this.filters = filters;
    }

    public List<FileHandler> getFileHandlers() {
        return this.fileHandlers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\n\t\tbuffer cache: " + this.bufferCache);
        sb.append("\n\t\tserver: " + this.server);
        sb.append("\n\t\tservlet container: " + this.servletContainer);
        sb.append("\n\t}");
        return sb.toString();
    }

    @XmlType(name="expressionFilterType", namespace="urn:jboss:domain:undertow:4.0")
    public static class ExpressionFilter
    extends AbstractFilter {
        @XmlAttribute(name="expression")
        private String expression;
        @XmlAttribute
        private String module;

        @Override
        public HttpHandler configure(HttpHandler handler, String predicate) {
            HandlerWrapper wrapper = HandlerParser.parse((String)this.expression, (ClassLoader)HttpHandler.class.getClassLoader());
            if (predicate == null) {
                return wrapper.wrap(handler);
            }
            Predicate p = Predicates.parse((String)predicate, (ClassLoader)HttpHandler.class.getClassLoader());
            return Handlers.predicate((Predicate)p, (HttpHandler)wrapper.wrap(handler), (HttpHandler)handler);
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public String getModule() {
            return this.module;
        }

        public void setModule(String module) {
            this.module = module;
        }
    }

    @XmlType(name="customFilterType", namespace="urn:jboss:domain:undertow:4.0")
    public static class CustomFilter
    extends AbstractFilter {
        @XmlAttribute(name="class-name")
        private String className;
        @XmlAttribute
        private String module;

        @Override
        public HttpHandler configure(HttpHandler handler, String predicate) {
            return handler;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getModule() {
            return this.module;
        }

        public void setModule(String module) {
            this.module = module;
        }
    }

    @XmlType(name="errorPageType", namespace="urn:jboss:domain:undertow:4.0")
    public static class ErrorPageFilter
    extends AbstractFilter {
        @XmlAttribute
        private String code;
        @XmlAttribute
        private String path;

        @Override
        public HttpHandler configure(HttpHandler handler, String predicate) {
            return handler;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    @XmlType(name="request-limitType", namespace="urn:jboss:domain:undertow:4.0")
    public static class RequestLimitFilter
    extends AbstractFilter {
        @XmlAttribute(name="max-concurrent-requests")
        private int maxConcurrentRequests;
        @XmlAttribute(name="queue-size")
        private int queueSize;

        @Override
        public HttpHandler configure(HttpHandler handler, String predicate) {
            RequestLimitingHandler requestLimitingHandler = new RequestLimitingHandler(this.getMaxConcurrentRequests(), this.getQueueSize(), handler);
            if (predicate == null) {
                return requestLimitingHandler;
            }
            Predicate p = Predicates.parse((String)predicate, (ClassLoader)HttpHandler.class.getClassLoader());
            return Handlers.predicate((Predicate)p, (HttpHandler)requestLimitingHandler, (HttpHandler)handler);
        }

        public int getMaxConcurrentRequests() {
            return this.maxConcurrentRequests;
        }

        public void setMaxConcurrentRequests(int maxConcurrentRequests) {
            this.maxConcurrentRequests = maxConcurrentRequests;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }
    }

    @XmlType(name="response-headerType", namespace="urn:jboss:domain:undertow:4.0")
    public static class ResponseHeaderFilter
    extends AbstractFilter {
        @XmlAttribute(name="header-name")
        private String header;
        @XmlAttribute(name="header-value")
        private String value;

        @Override
        public HttpHandler configure(HttpHandler handler, String predicate) {
            SetHeaderHandler setHeaderHandler = new SetHeaderHandler(handler, this.header, this.value);
            if (predicate == null) {
                return setHeaderHandler;
            }
            Predicate p = Predicates.parse((String)predicate, (ClassLoader)HttpHandler.class.getClassLoader());
            return Handlers.predicate((Predicate)p, (HttpHandler)setHeaderHandler, (HttpHandler)handler);
        }

        public String getHeader() {
            return this.header;
        }

        public void setHeader(String header) {
            this.header = header;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    @XmlType(name="abstractFilterType", namespace="urn:jboss:domain:undertow:4.0")
    public static abstract class AbstractFilter {
        @XmlAttribute
        protected String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public abstract HttpHandler configure(HttpHandler var1, String var2);
    }

    @XmlType(name="filterType", namespace="urn:jboss:domain:undertow:4.0", propOrder={"responseHeaders", "requestLimits", "errorPages", "customFilters", "expressionFilters"})
    public static class Filters {
        @XmlElement(name="response-header")
        private List<ResponseHeaderFilter> responseHeaders = new ArrayList<ResponseHeaderFilter>();
        @XmlElement(name="request-limit")
        private List<RequestLimitFilter> requestLimits = new ArrayList<RequestLimitFilter>();
        @XmlElement(name="error-page")
        private List<ErrorPageFilter> errorPages = new ArrayList<ErrorPageFilter>();
        @XmlElement(name="filter")
        private List<CustomFilter> customFilters = new ArrayList<CustomFilter>();
        @XmlElement(name="expression-filter")
        private List<ExpressionFilter> expressionFilters = new ArrayList<ExpressionFilter>();

        public List<ResponseHeaderFilter> getResponseHeaders() {
            return this.responseHeaders;
        }

        public List<RequestLimitFilter> getRequestLimits() {
            return this.requestLimits;
        }

        public List<ErrorPageFilter> getErrorPages() {
            return this.errorPages;
        }

        public List<CustomFilter> getCustomFilters() {
            return this.customFilters;
        }

        public List<ExpressionFilter> getExpressionFilters() {
            return this.expressionFilters;
        }
    }

    @XmlType(name="file-handlerType", namespace="urn:jboss:domain:undertow:4.0")
    public static class FileHandler {
        @XmlAttribute
        private String name;
        @XmlAttribute
        private String path;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    @XmlType(name="buffer-cacheType", namespace="urn:jboss:domain:undertow:4.0")
    public static class BufferCache {
        @XmlAttribute
        private String name;
        @XmlAttribute(name="buffer-size")
        private int bufferSize = 1024;
        @XmlAttribute(name="buffers-per-region")
        private int buffersPerRegion = 1024;
        @XmlAttribute(name="max-regions")
        private int maxRegions = 10;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public void setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        public int getBuffersPerRegion() {
            return this.buffersPerRegion;
        }

        public void setBuffersPerRegion(int buffersPerRegion) {
            this.buffersPerRegion = buffersPerRegion;
        }

        public int getMaxRegions() {
            return this.maxRegions;
        }

        public void setMaxRegions(int maxRegions) {
            this.maxRegions = maxRegions;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            sb.append("name: ").append(this.name);
            sb.append(", buffer size: ").append(this.bufferSize);
            sb.append(", buffers per region: ").append(this.buffersPerRegion);
            sb.append(", max regions: ").append(this.maxRegions);
            sb.append(" }");
            return sb.toString();
        }
    }
}

