/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import org.opendaylight.yangtools.yang.xpath.api.AbstractYangXPathMathSupport;
import org.opendaylight.yangtools.yang.xpath.api.DoubleNumberExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangBooleanConstantExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;

final class DoubleXPathMathSupport
extends AbstractYangXPathMathSupport<DoubleNumberExpr> {
    static final DoubleXPathMathSupport INSTANCE = new DoubleXPathMathSupport();
    private static final long serialVersionUID = 1L;

    private DoubleXPathMathSupport() {
        super(DoubleNumberExpr.class);
    }

    @Override
    public DoubleNumberExpr createNumber(String str) {
        return DoubleNumberExpr.of(Double.parseDouble(str));
    }

    @Override
    public DoubleNumberExpr createNumber(int value) {
        return DoubleNumberExpr.of(value);
    }

    @Override
    protected DoubleNumberExpr doNegateNumber(DoubleNumberExpr number) {
        return DoubleNumberExpr.of(-number.getValue());
    }

    @Override
    protected YangExpr doEvaluate(YangBinaryOperator operator, DoubleNumberExpr left, DoubleNumberExpr right) {
        double result;
        double l = left.getValue();
        double r = right.getValue();
        switch (operator) {
            case DIV: {
                result = l / r;
                break;
            }
            case EQUALS: {
                return YangBooleanConstantExpr.of(left.equals(right));
            }
            case GT: {
                return YangBooleanConstantExpr.of(l > r);
            }
            case GTE: {
                return YangBooleanConstantExpr.of(l >= r);
            }
            case LT: {
                return YangBooleanConstantExpr.of(l < r);
            }
            case LTE: {
                return YangBooleanConstantExpr.of(l <= r);
            }
            case MINUS: {
                result = l - r;
                break;
            }
            case MOD: {
                result = l % r;
                break;
            }
            case MUL: {
                result = l * r;
                break;
            }
            case NOT_EQUALS: {
                return YangBooleanConstantExpr.of(!left.equals(right));
            }
            case PLUS: {
                result = l + r;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled operator " + operator);
            }
        }
        return DoubleNumberExpr.of(result);
    }

    @Override
    protected Object readResolve() {
        return INSTANCE;
    }
}

