/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import com.google.common.annotations.Beta;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;

@Beta
public class YangPathExpr
implements YangExpr {
    private static final long serialVersionUID = 1L;
    private final YangExpr filterExpr;

    YangPathExpr(YangExpr filterExpr) {
        this.filterExpr = Objects.requireNonNull(filterExpr);
    }

    public static YangPathExpr of(YangExpr filterExpr) {
        return new YangPathExpr(filterExpr);
    }

    public static YangPathExpr of(YangExpr expr, YangLocationPath.Relative locationPath) {
        return new WithLocation(expr, locationPath);
    }

    public final YangExpr getFilterExpr() {
        return this.filterExpr;
    }

    public Optional<YangLocationPath.Relative> getLocationPath() {
        return Optional.empty();
    }

    public final int hashCode() {
        return Objects.hash(this.filterExpr, this.getLocationPath());
    }

    public final boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof YangPathExpr)) {
            return false;
        }
        YangPathExpr other = (YangPathExpr)obj;
        return this.filterExpr.equals(((YangPathExpr)obj).filterExpr) && this.getLocationPath().equals(other.getLocationPath());
    }

    public final String toString() {
        return "-(" + this.filterExpr + ")";
    }

    private static final class WithLocation
    extends YangPathExpr {
        private static final long serialVersionUID = 1L;
        private final YangLocationPath.Relative locationPath;

        WithLocation(YangExpr filterExpr, YangLocationPath.Relative locationPath) {
            super(filterExpr);
            this.locationPath = Objects.requireNonNull(locationPath);
        }

        @Override
        public Optional<YangLocationPath.Relative> getLocationPath() {
            return Optional.of(this.locationPath);
        }
    }
}

