/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataEffectiveStatement;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextProvider;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.SchemaTreeInference;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.CaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefNamespace;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.spi.AbstractEffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.spi.DefaultSchemaTreeInference;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathAxis;
import org.slf4j.LoggerFactory;

@Beta
public final class SchemaInferenceStack
implements Mutable,
EffectiveModelContextProvider,
LeafrefResolver {
    private static final String VERIFY_DEFAULT_SCHEMA_TREE_INFERENCE_PROP = "org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack.verifyDefaultSchemaTreeInference";
    private static final boolean VERIFY_DEFAULT_SCHEMA_TREE_INFERENCE = Boolean.getBoolean("org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack.verifyDefaultSchemaTreeInference");
    private final @NonNull EffectiveModelContext effectiveModel;
    private final ArrayDeque<EffectiveStatement<?, ?>> deque;
    private @Nullable ModuleEffectiveStatement currentModule;
    private int groupingDepth;
    private boolean clean;

    private SchemaInferenceStack(EffectiveModelContext effectiveModel, int expectedSize) {
        this.deque = new ArrayDeque(expectedSize);
        this.effectiveModel = Objects.requireNonNull(effectiveModel);
        this.clean = true;
    }

    private SchemaInferenceStack(SchemaInferenceStack source) {
        this.deque = source.deque.clone();
        this.effectiveModel = source.effectiveModel;
        this.currentModule = source.currentModule;
        this.groupingDepth = source.groupingDepth;
        this.clean = source.clean;
    }

    private SchemaInferenceStack(EffectiveModelContext effectiveModel, ArrayDeque<EffectiveStatement<?, ?>> deque, ModuleEffectiveStatement currentModule, int groupingDepth, boolean clean) {
        this.effectiveModel = Objects.requireNonNull(effectiveModel);
        this.deque = deque.clone();
        this.currentModule = currentModule;
        this.groupingDepth = groupingDepth;
        this.clean = clean;
    }

    private SchemaInferenceStack(EffectiveModelContext effectiveModel) {
        this.effectiveModel = Objects.requireNonNull(effectiveModel);
        this.deque = new ArrayDeque();
        this.clean = true;
    }

    public static @NonNull SchemaInferenceStack of(EffectiveModelContext effectiveModel) {
        return new SchemaInferenceStack(effectiveModel);
    }

    public static @NonNull SchemaInferenceStack of(EffectiveModelContext effectiveModel, SchemaNodeIdentifier.Absolute path) {
        SchemaInferenceStack ret = new SchemaInferenceStack(effectiveModel);
        path.getNodeIdentifiers().forEach(ret::enterSchemaTree);
        return ret;
    }

    public static @NonNull SchemaInferenceStack ofInference(EffectiveStatementInference inference) {
        if (inference.statementPath().isEmpty()) {
            return new SchemaInferenceStack(inference.getEffectiveModelContext());
        }
        if (inference instanceof SchemaTreeInference) {
            return SchemaInferenceStack.ofInference((SchemaTreeInference)inference);
        }
        if (inference instanceof Inference) {
            return ((Inference)inference).toSchemaInferenceStack();
        }
        throw new IllegalArgumentException("Unsupported Inference " + inference);
    }

    public static @NonNull SchemaInferenceStack ofInference(SchemaTreeInference inference) {
        return inference instanceof DefaultSchemaTreeInference ? SchemaInferenceStack.ofInference((DefaultSchemaTreeInference)inference) : SchemaInferenceStack.of(inference.getEffectiveModelContext(), inference.toSchemaNodeIdentifier());
    }

    public static @NonNull SchemaInferenceStack ofInference(DefaultSchemaTreeInference inference) {
        return VERIFY_DEFAULT_SCHEMA_TREE_INFERENCE ? SchemaInferenceStack.ofUntrusted(inference) : SchemaInferenceStack.ofTrusted(inference);
    }

    private static @NonNull SchemaInferenceStack ofTrusted(DefaultSchemaTreeInference inference) {
        List path = inference.statementPath();
        SchemaInferenceStack ret = new SchemaInferenceStack(inference.getEffectiveModelContext(), path.size());
        ret.currentModule = ret.getModule((QName)((SchemaTreeEffectiveStatement)path.get(0)).argument());
        path.forEach(ret.deque::push);
        return ret;
    }

    @VisibleForTesting
    static @NonNull SchemaInferenceStack ofUntrusted(DefaultSchemaTreeInference inference) {
        SchemaInferenceStack ret = SchemaInferenceStack.of(inference.getEffectiveModelContext(), inference.toSchemaNodeIdentifier());
        if (!Iterators.elementsEqual(ret.deque.descendingIterator(), inference.statementPath().iterator())) {
            throw new IllegalArgumentException("Provided " + inference + " is not consistent with resolved path " + ret.toSchemaTreeInference());
        }
        return ret;
    }

    public static @NonNull SchemaInferenceStack ofDataTreePath(EffectiveModelContext effectiveModel, QName ... path) {
        SchemaInferenceStack ret = new SchemaInferenceStack(effectiveModel);
        for (QName qname : path) {
            ret.enterDataTree(qname);
        }
        return ret;
    }

    @Deprecated
    public static @NonNull SchemaInferenceStack ofInstantiatedPath(EffectiveModelContext effectiveModel, SchemaPath path) {
        Preconditions.checkArgument((boolean)path.isAbsolute(), (String)"Cannot operate on relative path %s", (Object)path);
        SchemaInferenceStack ret = new SchemaInferenceStack(effectiveModel);
        path.getPathFromRoot().forEach(ret::enterSchemaTree);
        return ret;
    }

    @Deprecated
    public static @NonNull SchemaInferenceStack ofSchemaPath(EffectiveModelContext effectiveModel, SchemaPath path) {
        Preconditions.checkArgument((boolean)path.isAbsolute(), (String)"Cannot operate on relative path %s", (Object)path);
        SchemaInferenceStack ret = new SchemaInferenceStack(effectiveModel);
        for (QName step : path.getPathFromRoot()) {
            try {
                ret.enterSchemaTree(step);
            }
            catch (IllegalArgumentException schemaEx) {
                try {
                    ret.enterGrouping(step);
                }
                catch (IllegalArgumentException ex) {
                    ex.addSuppressed(schemaEx);
                    throw ex;
                }
            }
        }
        return ret;
    }

    public EffectiveModelContext getEffectiveModelContext() {
        return this.effectiveModel;
    }

    public @NonNull SchemaInferenceStack copy() {
        return new SchemaInferenceStack(this);
    }

    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    public @NonNull EffectiveStatement<?, ?> currentStatement() {
        return SchemaInferenceStack.checkNonNullState(this.deque.peekFirst());
    }

    public @NonNull ModuleEffectiveStatement currentModule() {
        return SchemaInferenceStack.checkNonNullState(this.currentModule);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean inInstantiatedContext() {
        if (this.groupingDepth != 0) return false;
        if (this.deque.isEmpty()) return false;
        if (!this.deque.stream().allMatch(SchemaTreeEffectiveStatement.class::isInstance)) return false;
        return true;
    }

    public boolean inGrouping() {
        return this.groupingDepth != 0;
    }

    public void clear() {
        this.deque.clear();
        this.currentModule = null;
        this.groupingDepth = 0;
        this.clean = true;
    }

    public @NonNull ChoiceEffectiveStatement enterChoice(QName nodeIdentifier) {
        QName nodeId = Objects.requireNonNull(nodeIdentifier);
        EffectiveStatement<?, ?> parent = this.deque.peek();
        if (parent instanceof ChoiceEffectiveStatement) {
            return this.enterChoice((ChoiceEffectiveStatement)parent, nodeId);
        }
        SchemaTreeEffectiveStatement<?> result = this.enterSchemaTree(nodeId);
        if (result instanceof ChoiceEffectiveStatement) {
            return (ChoiceEffectiveStatement)result;
        }
        this.exit();
        if (parent != null) {
            throw SchemaInferenceStack.notPresent(parent, "Choice", nodeId);
        }
        throw new IllegalArgumentException("Choice " + nodeId + " not present");
    }

    private @NonNull ChoiceEffectiveStatement enterChoice(@NonNull ChoiceEffectiveStatement parent, QName nodeIdentifier) {
        for (EffectiveStatement stmt : parent.effectiveSubstatements()) {
            if (!(stmt instanceof CaseEffectiveStatement)) continue;
            Optional<ChoiceEffectiveStatement> optMatch = ((CaseEffectiveStatement)stmt).findSchemaTreeNode(nodeIdentifier).filter(ChoiceEffectiveStatement.class::isInstance).map(ChoiceEffectiveStatement.class::cast);
            if (!optMatch.isPresent()) continue;
            SchemaTreeEffectiveStatement match = (SchemaTreeEffectiveStatement)optMatch.orElseThrow();
            this.deque.push((EffectiveStatement<?, ?>)match);
            this.clean = false;
            return (ChoiceEffectiveStatement)match;
        }
        throw SchemaInferenceStack.notPresent(parent, "Choice", nodeIdentifier);
    }

    public @NonNull GroupingEffectiveStatement enterGrouping(QName nodeIdentifier) {
        return this.pushGrouping(Objects.requireNonNull(nodeIdentifier));
    }

    public @NonNull SchemaTreeEffectiveStatement<?> enterSchemaTree(QName nodeIdentifier) {
        return this.pushSchema(Objects.requireNonNull(nodeIdentifier));
    }

    public @NonNull SchemaTreeEffectiveStatement<?> enterSchemaTree(SchemaNodeIdentifier nodeIdentifier) {
        SchemaTreeEffectiveStatement<?> ret;
        if (nodeIdentifier instanceof SchemaNodeIdentifier.Absolute) {
            this.clear();
        }
        Iterator it = nodeIdentifier.getNodeIdentifiers().iterator();
        do {
            ret = this.enterSchemaTree((QName)it.next());
        } while (it.hasNext());
        return ret;
    }

    public @NonNull DataTreeEffectiveStatement<?> enterDataTree(QName nodeIdentifier) {
        return this.pushData(Objects.requireNonNull(nodeIdentifier));
    }

    public @NonNull TypedefEffectiveStatement enterTypedef(QName nodeIdentifier) {
        return this.pushTypedef(Objects.requireNonNull(nodeIdentifier));
    }

    public @NonNull YangDataEffectiveStatement enterYangData(QNameModule namespace, String name) {
        EffectiveStatement<?, ?> parent = this.deque.peekFirst();
        Preconditions.checkState((parent == null ? 1 : 0) != 0, (Object)"Cannot lookup yang-data in a non-empty stack");
        String templateName = Objects.requireNonNull(name);
        ModuleEffectiveStatement module = (ModuleEffectiveStatement)this.effectiveModel.getModuleStatements().get(Objects.requireNonNull(namespace));
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (String)"Module for %s not found", (Object)namespace);
        YangDataEffectiveStatement ret = module.streamEffectiveSubstatements(YangDataEffectiveStatement.class).filter(stmt -> templateName.equals(stmt.argument())).findFirst().orElseThrow(() -> new IllegalArgumentException("yang-data " + templateName + " not present in " + namespace));
        this.deque.push((EffectiveStatement<?, ?>)ret);
        this.currentModule = module;
        return ret;
    }

    public @NonNull EffectiveStatement<?, ?> exit() {
        EffectiveStatement<?, ?> prev = this.deque.pop();
        if (prev instanceof GroupingEffectiveStatement) {
            --this.groupingDepth;
        }
        if (this.deque.isEmpty()) {
            this.currentModule = null;
            this.clean = true;
        }
        return prev;
    }

    public @NonNull DataTreeEffectiveStatement<?> exitToDataTree() {
        EffectiveStatement<?, ?> child = this.exit();
        Preconditions.checkState((boolean)(child instanceof DataTreeEffectiveStatement), (String)"Unexpected current %s", child);
        EffectiveStatement<?, ?> parent = this.deque.peekFirst();
        while (parent instanceof ChoiceEffectiveStatement || parent instanceof CaseEffectiveStatement) {
            this.deque.pollFirst();
            parent = this.deque.peekFirst();
        }
        Preconditions.checkState((parent == null || parent instanceof DataTreeAwareEffectiveStatement ? 1 : 0) != 0, (String)"Unexpected parent %s", parent);
        return (DataTreeEffectiveStatement)child;
    }

    @Override
    public TypeDefinition<?> resolveLeafref(LeafrefTypeDefinition type) {
        TypeDefinition result;
        SchemaInferenceStack tmp = this.copy();
        LeafrefTypeDefinition current = type;
        while (true) {
            EffectiveStatement<?, ?> resolved = tmp.resolvePathExpression(current.getPathStatement());
            Preconditions.checkState((boolean)(resolved instanceof TypeAware), (String)"Unexpected result %s resultion of %s", resolved, (Object)type);
            result = ((TypedDataSchemaNode)resolved).getType();
            if (!(result instanceof LeafrefTypeDefinition)) break;
            Preconditions.checkArgument((result != type ? 1 : 0) != 0, (String)"Resolution of %s loops back onto itself via %s", (Object)type, (Object)current);
            current = (LeafrefTypeDefinition)result;
        }
        return result;
    }

    public @NonNull EffectiveStatement<?, ?> resolvePathExpression(PathExpression path) {
        PathExpression.Steps steps = path.getSteps();
        if (steps instanceof PathExpression.LocationPathSteps) {
            return this.resolveLocationPath(((PathExpression.LocationPathSteps)steps).getLocationPath());
        }
        if (steps instanceof PathExpression.DerefSteps) {
            return this.resolveDeref((PathExpression.DerefSteps)steps);
        }
        throw new VerifyException("Unhandled steps " + steps);
    }

    private @NonNull EffectiveStatement<?, ?> resolveDeref(PathExpression.DerefSteps deref) {
        EffectiveStatement<?, ?> leafRefSchemaNode = this.currentStatement();
        YangLocationPath.Relative derefArg = deref.getDerefArgument();
        EffectiveStatement<?, ?> derefStmt = this.resolveLocationPath((YangLocationPath)derefArg);
        Preconditions.checkArgument((derefStmt != null ? 1 : 0) != 0, (String)"Cannot find deref(%s) target node %s in context of %s", (Object)derefArg, leafRefSchemaNode);
        Preconditions.checkArgument((boolean)(derefStmt instanceof TypedDataSchemaNode), (String)"deref(%s) resolved to non-typed %s", (Object)derefArg, derefStmt);
        TypeDefinition targetType = ((TypedDataSchemaNode)derefStmt).getType();
        if (targetType instanceof InstanceIdentifierTypeDefinition) {
            throw new UnsupportedOperationException("Cannot infer instance-identifier reference " + targetType);
        }
        Preconditions.checkArgument((boolean)(targetType instanceof LeafrefTypeDefinition), (String)"Illegal target type %s", (Object)targetType);
        PathExpression dereferencedLeafRefPath = ((LeafrefTypeDefinition)targetType).getPathStatement();
        EffectiveStatement<?, ?> derefNode = this.resolvePathExpression(dereferencedLeafRefPath);
        Preconditions.checkArgument((derefStmt != null ? 1 : 0) != 0, (String)"Can not find target node of dereferenced node %s", derefStmt);
        Preconditions.checkArgument((boolean)(derefNode instanceof LeafSchemaNode), (String)"Unexpected %s reference in %s", (Object)deref, (Object)dereferencedLeafRefPath);
        return this.resolveLocationPath((YangLocationPath)deref.getRelativePath());
    }

    private @NonNull EffectiveStatement<?, ?> resolveLocationPath(YangLocationPath path) {
        QNameModule defaultNamespace;
        QNameModule qNameModule = defaultNamespace = this.deque.isEmpty() ? null : ((QName)this.deque.peek().argument()).getModule();
        if (path.isAbsolute()) {
            this.clear();
        }
        DataTreeEffectiveStatement<?> current = null;
        block6: for (YangLocationPath.Step step : path.getSteps()) {
            YangXPathAxis axis = step.getAxis();
            switch (axis) {
                case PARENT: {
                    Verify.verify((boolean)(step instanceof YangLocationPath.AxisStep), (String)"Unexpected parent step %s", (Object)step);
                    try {
                        current = this.exitToDataTree();
                        continue block6;
                    }
                    catch (IllegalStateException | NoSuchElementException e) {
                        throw new IllegalArgumentException("Illegal parent access in " + path, e);
                    }
                }
                case CHILD: {
                    Verify.verify((boolean)(step instanceof YangLocationPath.QNameStep), (String)"Unexpected child step %s", (Object)step);
                    current = this.enterChild((YangLocationPath.QNameStep)step, defaultNamespace);
                    continue block6;
                }
            }
            throw new VerifyException("Unexpected step " + step);
        }
        return (EffectiveStatement)Verify.verifyNotNull(current);
    }

    private @NonNull EffectiveStatement<?, ?> enterChild(YangLocationPath.QNameStep step, QNameModule defaultNamespace) {
        QName qname;
        AbstractQName toResolve = step.getQName();
        if (toResolve instanceof QName) {
            qname = (QName)toResolve;
        } else if (toResolve instanceof UnresolvedQName.Unqualified) {
            Preconditions.checkArgument((defaultNamespace != null ? 1 : 0) != 0, (String)"Can not find target module of step %s", (Object)step);
            qname = ((UnresolvedQName.Unqualified)toResolve).bindTo(defaultNamespace);
        } else {
            throw new VerifyException("Unexpected child step QName " + toResolve);
        }
        return this.enterDataTree(qname);
    }

    public @NonNull Inference toInference() {
        return new Inference(this.effectiveModel, (ArrayDeque<EffectiveStatement<?, ?>>)this.deque.clone(), this.currentModule, this.groupingDepth, this.clean);
    }

    public @NonNull SchemaTreeInference toSchemaTreeInference() {
        Preconditions.checkState((boolean)this.inInstantiatedContext(), (String)"Cannot convert uninstantiated context %s", (Object)this);
        ArrayDeque<EffectiveStatement<?, ?>> cleanDeque = this.clean ? this.deque : this.reconstructSchemaInferenceStack().deque;
        return DefaultSchemaTreeInference.unsafeOf((EffectiveModelContext)this.getEffectiveModelContext(), (ImmutableList)ImmutableList.builderWithExpectedSize((int)cleanDeque.size()).addAll(Iterators.transform(cleanDeque.descendingIterator(), stmt -> (SchemaTreeEffectiveStatement)stmt)).build());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SchemaNodeIdentifier.Absolute toSchemaNodeIdentifier() {
        Preconditions.checkState((boolean)this.inInstantiatedContext(), (String)"Cannot convert uninstantiated context %s", (Object)this);
        return SchemaNodeIdentifier.Absolute.of((Collection)ImmutableList.builderWithExpectedSize((int)this.deque.size()).addAll(this.simplePathFromRoot()).build());
    }

    @Deprecated
    public @NonNull SchemaPath toSchemaPath() {
        SchemaPath ret = SchemaPath.ROOT;
        Iterator<QName> it = this.simplePathFromRoot();
        while (it.hasNext()) {
            ret = ret.createChild(it.next());
        }
        return ret;
    }

    @Deprecated
    public @NonNull Iterator<QName> schemaPathIterator() {
        return Iterators.unmodifiableIterator(this.simplePathFromRoot());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stack", this.deque).toString();
    }

    private @NonNull GroupingEffectiveStatement pushGrouping(@NonNull QName nodeIdentifier) {
        EffectiveStatement<?, ?> parent = this.deque.peekFirst();
        return parent != null ? this.pushGrouping(parent, nodeIdentifier) : this.pushFirstGrouping(nodeIdentifier);
    }

    private @NonNull GroupingEffectiveStatement pushGrouping(@NonNull EffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        GroupingEffectiveStatement ret = parent.streamEffectiveSubstatements(GroupingEffectiveStatement.class).filter(stmt -> nodeIdentifier.equals(stmt.argument())).findFirst().orElseThrow(() -> SchemaInferenceStack.notPresent(parent, "Grouping", nodeIdentifier));
        this.deque.push((EffectiveStatement<?, ?>)ret);
        ++this.groupingDepth;
        return ret;
    }

    private @NonNull GroupingEffectiveStatement pushFirstGrouping(@NonNull QName nodeIdentifier) {
        ModuleEffectiveStatement module = this.getModule(nodeIdentifier);
        GroupingEffectiveStatement ret = this.pushGrouping((EffectiveStatement<?, ?>)module, nodeIdentifier);
        this.currentModule = module;
        return ret;
    }

    private @NonNull SchemaTreeEffectiveStatement<?> pushSchema(@NonNull QName nodeIdentifier) {
        EffectiveStatement<?, ?> parent = this.deque.peekFirst();
        return parent != null ? this.pushSchema(parent, nodeIdentifier) : this.pushFirstSchema(nodeIdentifier);
    }

    private @NonNull SchemaTreeEffectiveStatement<?> pushSchema(EffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        Preconditions.checkState((boolean)(parent instanceof SchemaTreeAwareEffectiveStatement), (String)"Cannot descend schema tree at %s", parent);
        return this.pushSchema((SchemaTreeAwareEffectiveStatement)parent, nodeIdentifier);
    }

    private @NonNull SchemaTreeEffectiveStatement<?> pushSchema(@NonNull SchemaTreeAwareEffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        SchemaTreeEffectiveStatement ret = (SchemaTreeEffectiveStatement)parent.findSchemaTreeNode(nodeIdentifier).orElseThrow(() -> SchemaInferenceStack.notPresent(parent, "Schema tree child ", nodeIdentifier));
        this.deque.push((EffectiveStatement<?, ?>)ret);
        return ret;
    }

    private @NonNull SchemaTreeEffectiveStatement<?> pushFirstSchema(@NonNull QName nodeIdentifier) {
        ModuleEffectiveStatement module = this.getModule(nodeIdentifier);
        SchemaTreeEffectiveStatement<?> ret = this.pushSchema((SchemaTreeAwareEffectiveStatement<?, ?>)module, nodeIdentifier);
        this.currentModule = module;
        return ret;
    }

    private @NonNull DataTreeEffectiveStatement<?> pushData(@NonNull QName nodeIdentifier) {
        EffectiveStatement<?, ?> parent = this.deque.peekFirst();
        return parent != null ? this.pushData(parent, nodeIdentifier) : this.pushFirstData(nodeIdentifier);
    }

    private @NonNull DataTreeEffectiveStatement<?> pushData(EffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        Preconditions.checkState((boolean)(parent instanceof DataTreeAwareEffectiveStatement), (String)"Cannot descend data tree at %s", parent);
        return this.pushData((DataTreeAwareEffectiveStatement)parent, nodeIdentifier);
    }

    private @NonNull DataTreeEffectiveStatement<?> pushData(@NonNull DataTreeAwareEffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        DataTreeEffectiveStatement ret = (DataTreeEffectiveStatement)parent.findDataTreeNode(nodeIdentifier).orElseThrow(() -> SchemaInferenceStack.notPresent(parent, "Data tree child", nodeIdentifier));
        this.deque.push((EffectiveStatement<?, ?>)ret);
        this.clean = false;
        return ret;
    }

    private @NonNull DataTreeEffectiveStatement<?> pushFirstData(@NonNull QName nodeIdentifier) {
        ModuleEffectiveStatement module = this.getModule(nodeIdentifier);
        DataTreeEffectiveStatement<?> ret = this.pushData((DataTreeAwareEffectiveStatement<?, ?>)module, nodeIdentifier);
        this.currentModule = module;
        return ret;
    }

    private @NonNull TypedefEffectiveStatement pushTypedef(@NonNull QName nodeIdentifier) {
        EffectiveStatement<?, ?> parent = this.deque.peekFirst();
        return parent != null ? this.pushTypedef(parent, nodeIdentifier) : this.pushFirstTypedef(nodeIdentifier);
    }

    private @NonNull TypedefEffectiveStatement pushTypedef(@NonNull EffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        TypedefEffectiveStatement ret = (TypedefEffectiveStatement)parent.get(TypedefNamespace.class, (Object)nodeIdentifier).orElseThrow(() -> SchemaInferenceStack.notPresent(parent, "Typedef", nodeIdentifier));
        this.deque.push((EffectiveStatement<?, ?>)ret);
        return ret;
    }

    private @NonNull TypedefEffectiveStatement pushFirstTypedef(@NonNull QName nodeIdentifier) {
        ModuleEffectiveStatement module = this.getModule(nodeIdentifier);
        TypedefEffectiveStatement ret = this.pushTypedef((EffectiveStatement<?, ?>)module, nodeIdentifier);
        this.currentModule = module;
        return ret;
    }

    private @NonNull ModuleEffectiveStatement getModule(@NonNull QName nodeIdentifier) {
        ModuleEffectiveStatement module = (ModuleEffectiveStatement)this.effectiveModel.getModuleStatements().get(nodeIdentifier.getModule());
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (String)"Module for %s not found", (Object)nodeIdentifier);
        return module;
    }

    private Iterator<QName> simplePathFromRoot() {
        return this.clean ? this.iterateQNames() : this.reconstructQNames();
    }

    private Iterator<QName> iterateQNames() {
        return Iterators.transform(this.deque.descendingIterator(), stmt -> {
            Object argument = stmt.argument();
            Verify.verify((boolean)(argument instanceof QName), (String)"Unexpected statement %s", (Object)stmt);
            return (QName)argument;
        });
    }

    private Iterator<QName> reconstructQNames() {
        return this.reconstructSchemaInferenceStack().iterateQNames();
    }

    private SchemaInferenceStack reconstructSchemaInferenceStack() {
        SchemaInferenceStack tmp = new SchemaInferenceStack(this.effectiveModel, this.deque.size());
        Iterator<EffectiveStatement<?, ?>> it = this.deque.descendingIterator();
        while (it.hasNext()) {
            EffectiveStatement<?, ?> stmt = it.next();
            if (stmt instanceof DataTreeEffectiveStatement) {
                tmp.resolveDataTreeSteps((QName)((DataTreeEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof ChoiceEffectiveStatement) {
                tmp.resolveChoiceSteps((QName)((ChoiceEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof SchemaTreeEffectiveStatement) {
                tmp.enterSchemaTree((QName)((SchemaTreeEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof GroupingEffectiveStatement) {
                tmp.enterGrouping((QName)((GroupingEffectiveStatement)stmt).argument());
                continue;
            }
            if (stmt instanceof TypedefEffectiveStatement) {
                tmp.enterTypedef((QName)((TypedefEffectiveStatement)stmt).argument());
                continue;
            }
            throw new VerifyException("Unexpected statement " + stmt);
        }
        if (this.deque.size() == tmp.deque.size()) {
            this.clean = true;
            return this;
        }
        return tmp;
    }

    private void resolveChoiceSteps(@NonNull QName nodeIdentifier) {
        EffectiveStatement<?, ?> parent = this.deque.peekFirst();
        if (parent instanceof ChoiceEffectiveStatement) {
            this.resolveChoiceSteps((ChoiceEffectiveStatement)parent, nodeIdentifier);
        } else {
            this.enterSchemaTree(nodeIdentifier);
        }
    }

    private void resolveChoiceSteps(@NonNull ChoiceEffectiveStatement parent, @NonNull QName nodeIdentifier) {
        for (EffectiveStatement stmt : parent.effectiveSubstatements()) {
            CaseEffectiveStatement caze;
            SchemaTreeEffectiveStatement found;
            if (!(stmt instanceof CaseEffectiveStatement) || !((found = (SchemaTreeEffectiveStatement)(caze = (CaseEffectiveStatement)stmt).findSchemaTreeNode(nodeIdentifier).orElse(null)) instanceof ChoiceEffectiveStatement)) continue;
            this.deque.push((EffectiveStatement<?, ?>)caze);
            this.deque.push((EffectiveStatement<?, ?>)found);
            return;
        }
        throw new VerifyException("Failed to resolve " + nodeIdentifier + " in " + parent);
    }

    private void resolveDataTreeSteps(@NonNull QName nodeIdentifier) {
        EffectiveStatement<?, ?> parent = this.deque.peekFirst();
        if (parent != null) {
            Verify.verify((boolean)(parent instanceof SchemaTreeAwareEffectiveStatement), (String)"Unexpected parent %s", parent);
            this.resolveDataTreeSteps((SchemaTreeAwareEffectiveStatement)parent, nodeIdentifier);
            return;
        }
        ModuleEffectiveStatement module = this.getModule(nodeIdentifier);
        this.resolveDataTreeSteps((SchemaTreeAwareEffectiveStatement<?, ?>)module, nodeIdentifier);
        this.currentModule = module;
    }

    private void resolveDataTreeSteps(@NonNull SchemaTreeAwareEffectiveStatement<?, ?> parent, @NonNull QName nodeIdentifier) {
        SchemaTreeEffectiveStatement found = parent.findSchemaTreeNode(nodeIdentifier).orElse(null);
        if (found instanceof DataTreeEffectiveStatement) {
            this.deque.push((EffectiveStatement<?, ?>)found);
            return;
        }
        ArrayDeque match = new ArrayDeque();
        for (EffectiveStatement stmt : parent.effectiveSubstatements()) {
            if (!(stmt instanceof ChoiceEffectiveStatement) || !SchemaInferenceStack.searchChoice(match, (ChoiceEffectiveStatement)stmt, nodeIdentifier)) continue;
            match.descendingIterator().forEachRemaining(this.deque::push);
            return;
        }
        throw new VerifyException("Failed to resolve " + nodeIdentifier + " in " + parent);
    }

    private static boolean searchCase(@NonNull Deque<EffectiveStatement<QName, ?>> result, @NonNull CaseEffectiveStatement parent, @NonNull QName nodeIdentifier) {
        result.push((EffectiveStatement<QName, ?>)parent);
        for (EffectiveStatement stmt : parent.effectiveSubstatements()) {
            if (stmt instanceof DataTreeEffectiveStatement && nodeIdentifier.equals(stmt.argument())) {
                result.push((EffectiveStatement<QName, ?>)((DataTreeEffectiveStatement)stmt));
                return true;
            }
            if (!(stmt instanceof ChoiceEffectiveStatement) || !SchemaInferenceStack.searchChoice(result, (ChoiceEffectiveStatement)stmt, nodeIdentifier)) continue;
            return true;
        }
        result.pop();
        return false;
    }

    private static boolean searchChoice(@NonNull Deque<EffectiveStatement<QName, ?>> result, @NonNull ChoiceEffectiveStatement parent, @NonNull QName nodeIdentifier) {
        result.push((EffectiveStatement<QName, ?>)parent);
        for (EffectiveStatement stmt : parent.effectiveSubstatements()) {
            if (!(stmt instanceof CaseEffectiveStatement) || !SchemaInferenceStack.searchCase(result, (CaseEffectiveStatement)stmt, nodeIdentifier)) continue;
            return true;
        }
        result.pop();
        return false;
    }

    private static <T> @NonNull T checkNonNullState(@Nullable T obj) {
        if (obj == null) {
            throw new IllegalStateException("Cannot execute on empty stack");
        }
        return obj;
    }

    private static @NonNull IllegalArgumentException notPresent(@NonNull EffectiveStatement<?, ?> parent, @NonNull String name, QName nodeIdentifier) {
        return new IllegalArgumentException(name + " " + nodeIdentifier + " not present in " + SchemaInferenceStack.describeParent(parent));
    }

    private static @NonNull String describeParent(@NonNull EffectiveStatement<?, ?> parent) {
        if (parent instanceof SchemaTreeEffectiveStatement) {
            return "schema parent " + parent.argument();
        }
        if (parent instanceof GroupingEffectiveStatement) {
            return "grouping " + parent.argument();
        }
        if (parent instanceof ModuleEffectiveStatement) {
            ModuleEffectiveStatement module = (ModuleEffectiveStatement)parent;
            return "module " + ((UnresolvedQName.Unqualified)module.argument()).bindTo(module.localQNameModule());
        }
        EffectiveStatement<?, ?> arg = parent.argument();
        return "parent " + (arg instanceof QName ? arg : parent);
    }

    static {
        if (VERIFY_DEFAULT_SCHEMA_TREE_INFERENCE) {
            LoggerFactory.getLogger(SchemaInferenceStack.class).info("SchemaTreeStack.ofInference(DefaultSchemaTreeInference) argument is being verified");
        }
    }

    @Beta
    public static final class Inference
    extends AbstractEffectiveStatementInference<EffectiveStatement<?, ?>> {
        private final ArrayDeque<EffectiveStatement<?, ?>> deque;
        private final ModuleEffectiveStatement currentModule;
        private final int groupingDepth;
        private final boolean clean;

        Inference(@NonNull EffectiveModelContext modelContext, ArrayDeque<EffectiveStatement<?, ?>> deque, ModuleEffectiveStatement currentModule, int groupingDepth, boolean clean) {
            super(modelContext);
            this.deque = Objects.requireNonNull(deque);
            this.currentModule = currentModule;
            this.groupingDepth = groupingDepth;
            this.clean = clean;
        }

        public static @NonNull Inference ofDataTreePath(EffectiveModelContext effectiveModel, QName ... qnames) {
            return SchemaInferenceStack.ofDataTreePath(effectiveModel, qnames).toInference();
        }

        public List<EffectiveStatement<?, ?>> statementPath() {
            return ImmutableList.copyOf(this.deque.descendingIterator());
        }

        public @NonNull SchemaInferenceStack toSchemaInferenceStack() {
            return new SchemaInferenceStack(this.getEffectiveModelContext(), this.deque, this.currentModule, this.groupingDepth, this.clean);
        }
    }
}

