/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.ETv1;

@NonNullByDefault
public final class ErrorTag
implements Serializable {
    public static final ErrorTag ACCESS_DENIED = new ErrorTag("access-denied");
    public static final ErrorTag BAD_ATTRIBUTE = new ErrorTag("bad-attribute");
    public static final ErrorTag BAD_ELEMENT = new ErrorTag("bad-element");
    public static final ErrorTag DATA_EXISTS = new ErrorTag("data-exists");
    public static final ErrorTag DATA_MISSING = new ErrorTag("data-missing");
    public static final ErrorTag IN_USE = new ErrorTag("in-use");
    public static final ErrorTag INVALID_VALUE = new ErrorTag("invalid-value");
    public static final ErrorTag LOCK_DENIED = new ErrorTag("lock-denied");
    public static final ErrorTag MALFORMED_MESSAGE = new ErrorTag("malformed-message");
    public static final ErrorTag MISSING_ATTRIBUTE = new ErrorTag("missing-attribute");
    public static final ErrorTag MISSING_ELEMENT = new ErrorTag("missing-element");
    public static final ErrorTag OPERATION_FAILED = new ErrorTag("operation-failed");
    public static final ErrorTag OPERATION_NOT_SUPPORTED = new ErrorTag("operation-not-supported");
    @Deprecated(since="RFC6241")
    public static final ErrorTag PARTIAL_OPERATION = new ErrorTag("partial-operation");
    public static final ErrorTag RESOURCE_DENIED = new ErrorTag("resource-denied");
    public static final ErrorTag ROLLBACK_FAILED = new ErrorTag("rollback-failed");
    public static final ErrorTag TOO_BIG = new ErrorTag("too-big");
    public static final ErrorTag UNKNOWN_ATTRIBUTE = new ErrorTag("unknown-attribute");
    public static final ErrorTag UNKNOWN_ELEMENT = new ErrorTag("unknown-element");
    public static final ErrorTag UNKNOWN_NAMESPACE = new ErrorTag("unknown-namespace");
    private static final long serialVersionUID = 1L;
    private final String elementBody;

    public ErrorTag(String elementBody) {
        this.elementBody = Objects.requireNonNull(elementBody);
    }

    public String elementBody() {
        return this.elementBody;
    }

    public int hashCode() {
        return this.elementBody.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj == this || obj instanceof ErrorTag && this.elementBody.equals(((ErrorTag)obj).elementBody);
    }

    public String toString() {
        return this.elementBody;
    }

    Object writeReplace() {
        return new ETv1(this);
    }
}

