/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Either;
import org.opendaylight.yangtools.yang.common.AbstractCanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValue;
import org.opendaylight.yangtools.yang.common.CanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValueViolation;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.UintConversions;

@Beta
@NonNullByDefault
public class Uint8
extends Number
implements CanonicalValue<Uint8> {
    private static final CanonicalValueSupport<Uint8> SUPPORT = new Support();
    private static final short MAX_VALUE_SHORT = 255;
    private static final String MAX_VALUE_STR = "255";
    private static final long serialVersionUID = 1L;
    private static final @NonNull Uint8[] CACHE;
    public static final Uint8 ZERO;
    public static final Uint8 ONE;
    public static final Uint8 TWO;
    public static final Uint8 TEN;
    public static final Uint8 MAX_VALUE;
    private final byte value;

    private Uint8(byte value) {
        this.value = value;
    }

    protected Uint8(Uint8 other) {
        this(other.value);
    }

    private static Uint8 instanceFor(byte value) {
        return CACHE[Byte.toUnsignedInt(value)];
    }

    public static Uint8 fromByteBits(byte bits) {
        return Uint8.instanceFor(bits);
    }

    public static Uint8 valueOf(byte byteVal) {
        UintConversions.checkNonNegative(byteVal, MAX_VALUE_STR);
        return Uint8.instanceFor(byteVal);
    }

    public static Uint8 valueOf(short shortVal) {
        UintConversions.checkRange(shortVal, (short)255);
        return Uint8.instanceFor((byte)shortVal);
    }

    public static Uint8 valueOf(int intVal) {
        UintConversions.checkRange(intVal, 255);
        return Uint8.instanceFor((byte)intVal);
    }

    public static Uint8 valueOf(long longVal) {
        UintConversions.checkRange(longVal, 255L);
        return Uint8.instanceFor((byte)longVal);
    }

    public static Uint8 valueOf(Uint16 uint) {
        return Uint8.valueOf(uint.intValue());
    }

    public static Uint8 valueOf(Uint32 uint) {
        return Uint8.valueOf(uint.longValue());
    }

    public static Uint8 valueOf(Uint64 uint) {
        return Uint8.valueOf(uint.longValue());
    }

    public static Uint8 valueOf(String string) {
        return Uint8.valueOf(string, 10);
    }

    public static Uint8 valueOf(String string, int radix) {
        return Uint8.valueOf(Short.parseShort(Objects.requireNonNull(string), radix));
    }

    public static Uint8 saturatedOf(byte byteVal) {
        return byteVal <= 0 ? ZERO : Uint8.instanceFor(byteVal);
    }

    public static Uint8 saturatedOf(short shortVal) {
        if (shortVal <= 0) {
            return ZERO;
        }
        if (shortVal >= 255) {
            return MAX_VALUE;
        }
        return Uint8.instanceFor((byte)shortVal);
    }

    public static Uint8 saturatedOf(int intVal) {
        if (intVal <= 0) {
            return ZERO;
        }
        if (intVal >= 255) {
            return MAX_VALUE;
        }
        return Uint8.instanceFor((byte)intVal);
    }

    public static Uint8 saturatedOf(long longVal) {
        if (longVal <= 0L) {
            return ZERO;
        }
        if (longVal >= 255L) {
            return MAX_VALUE;
        }
        return Uint8.instanceFor((byte)longVal);
    }

    @Override
    public final byte byteValue() {
        return this.value;
    }

    @Override
    public final int intValue() {
        return Byte.toUnsignedInt(this.value);
    }

    @Override
    public final long longValue() {
        return Byte.toUnsignedLong(this.value);
    }

    @Override
    public final float floatValue() {
        return this.intValue();
    }

    @Override
    public final double doubleValue() {
        return this.intValue();
    }

    @Override
    public final int compareTo(Uint8 o) {
        return Byte.compareUnsigned(this.value, o.value);
    }

    @Override
    public final String toCanonicalString() {
        return Integer.toString(this.intValue());
    }

    @Override
    public final CanonicalValueSupport<Uint8> support() {
        return SUPPORT;
    }

    public final short toJava() {
        return this.shortValue();
    }

    public final Uint16 toUint16() {
        return Uint16.fromShortBits(this.shortValue());
    }

    public final Uint32 toUint32() {
        return Uint32.fromIntBits(this.intValue());
    }

    public final Uint64 toUint64() {
        return Uint64.fromLongBits(this.longValue());
    }

    public final int hashCode() {
        return Byte.hashCode(this.value);
    }

    public final boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Uint8 && this.value == ((Uint8)obj).value;
    }

    public final boolean equals(@Nullable Uint8 obj) {
        return this == obj || obj != null && this.value == obj.value;
    }

    public final String toString() {
        return this.toCanonicalString();
    }

    private Object readResolve() {
        return Uint8.instanceFor(this.value);
    }

    static {
        Uint8[] c = new Uint8[256];
        for (int i = 0; i <= 255; ++i) {
            c[i] = new Uint8((byte)i);
        }
        CACHE = c;
        ZERO = Uint8.valueOf(0);
        ONE = Uint8.valueOf(1);
        TWO = Uint8.valueOf(2);
        TEN = Uint8.valueOf(10);
        MAX_VALUE = Uint8.valueOf((short)255);
    }

    public static final class Support
    extends AbstractCanonicalValueSupport<Uint8> {
        public Support() {
            super(Uint8.class);
        }

        @Override
        public Either<Uint8, CanonicalValueViolation> fromString(String str) {
            try {
                return Either.ofFirst((Object)Uint8.valueOf(str));
            }
            catch (IllegalArgumentException e) {
                return CanonicalValueViolation.variantOf(e);
            }
        }
    }
}

