/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QQNv1;
import org.opendaylight.yangtools.yang.common.UQNv1;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;

@NonNullByDefault
public abstract class UnresolvedQName
extends AbstractQName {
    private static final long serialVersionUID = 1L;

    private UnresolvedQName(String localName) {
        super(localName);
    }

    public static Qualified qualified(String prefix, String localName) {
        return new Qualified(UnresolvedQName.checkLocalName(prefix), UnresolvedQName.checkLocalName(localName));
    }

    public static Unqualified unqualified(String localName) {
        return new Unqualified(UnresolvedQName.checkLocalName(localName));
    }

    @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"}, justification="Non-grok of @Nullable")
    public static @Nullable Unqualified tryLocalName(String localName) {
        return UnresolvedQName.isValidLocalName(localName) ? new Unqualified(localName) : null;
    }

    @Override
    public abstract UnresolvedQName intern();

    public abstract @Nullable String getPrefix();

    public abstract Qualified withPrefix(String var1);

    public static final class Unqualified
    extends UnresolvedQName
    implements Comparable<Unqualified> {
        private static final long serialVersionUID = 1L;
        private static final Interner<Unqualified> INTERNER = Interners.newWeakInterner();

        private Unqualified(String localName) {
            super(localName);
        }

        public static Unqualified readFrom(DataInput in) throws IOException {
            return Unqualified.unqualified(in.readUTF());
        }

        @Override
        @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="Interning identity check")
        public Unqualified intern() {
            String name = this.getLocalName();
            String internedName = name.intern();
            Unqualified template = internedName == name ? this : new Unqualified(internedName);
            return (Unqualified)INTERNER.intern((Object)template);
        }

        @Override
        @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"}, justification="Non-grok of @Nullable")
        public @Nullable String getPrefix() {
            return null;
        }

        @Override
        public Qualified withPrefix(String newPrefix) {
            return new Qualified(newPrefix, this.getLocalName());
        }

        @Override
        public int compareTo(Unqualified o) {
            return this.getLocalName().compareTo(o.getLocalName());
        }

        public void writeTo(DataOutput out) throws IOException {
            out.writeUTF(this.getLocalName());
        }

        @Override
        public int hashCode() {
            return this.getLocalName().hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Unqualified && this.getLocalName().equals(((AbstractQName)obj).getLocalName());
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("localName", (Object)this.getLocalName()).toString();
        }

        @Override
        Object writeReplace() {
            return new UQNv1(this);
        }
    }

    public static final class Qualified
    extends UnresolvedQName
    implements Comparable<Qualified> {
        private static final long serialVersionUID = 1L;
        private static final Interner<Qualified> INTERNER = Interners.newWeakInterner();
        private final String prefix;

        private Qualified(String prefix, String localName) {
            super(localName);
            this.prefix = Objects.requireNonNull(prefix);
        }

        public static Qualified readFrom(DataInput in) throws IOException {
            return Qualified.qualified(in.readUTF(), in.readUTF());
        }

        @Override
        public @NonNull String getPrefix() {
            return this.prefix;
        }

        public Optional<QName> bindTo(YangNamespaceContext namespaceContext) {
            return namespaceContext.findNamespaceForPrefix(this.prefix).map(this::bindTo);
        }

        @Override
        @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="Interning identity check")
        public Qualified intern() {
            String name = this.getLocalName();
            String internedName = name.intern();
            Qualified template = internedName == name ? this : new Qualified(this.prefix.intern(), internedName);
            return (Qualified)INTERNER.intern((Object)template);
        }

        @Override
        public Qualified withPrefix(String newPrefix) {
            return this.prefix.equals(newPrefix) ? this : new Qualified(newPrefix, this.getLocalName());
        }

        @Override
        public int compareTo(Qualified o) {
            return this.getLocalName().compareTo(o.getLocalName());
        }

        public void writeTo(DataOutput out) throws IOException {
            out.writeUTF(this.getLocalName());
        }

        @Override
        public int hashCode() {
            return this.getLocalName().hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Qualified && this.getLocalName().equals(((Qualified)obj).getLocalName());
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("localName", (Object)this.getLocalName()).toString();
        }

        @Override
        Object writeReplace() {
            return new QQNv1(this);
        }
    }
}

