/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.XNv1;

public final class XMLNamespace
implements Comparable<XMLNamespace>,
Immutable,
Serializable {
    private static final Interner<XMLNamespace> INTERNER = Interners.newWeakInterner();
    private static final long serialVersionUID = 1L;
    private final String namespace;

    private XMLNamespace(String namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    }

    public static @NonNull XMLNamespace of(String namespace) {
        try {
            new URI(namespace);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' is not a valid URI", e);
        }
        return new XMLNamespace(namespace);
    }

    public @NonNull XMLNamespace intern() {
        return (XMLNamespace)INTERNER.intern((Object)this);
    }

    @Override
    public int compareTo(XMLNamespace o) {
        return this.namespace.compareTo(o.namespace);
    }

    public int hashCode() {
        return this.namespace.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof XMLNamespace && this.namespace.equals(((XMLNamespace)obj).namespace);
    }

    public String toString() {
        return this.namespace;
    }

    Object writeReplace() {
        return new XNv1(this);
    }
}

