/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import java.net.URI;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;

@NonNullByDefault
public final class YangConstants {
    public static final String RFC6020_YANG_FILE_EXTENSION = ".yang";
    public static final String RFC6020_YANG_MAC_FILE_TYPE = "TEXT";
    public static final String RFC6020_YANG_MEDIA_TYPE = "application/yang";
    public static final String RFC6020_YANG_NAMESPACE_STRING = "urn:ietf:params:xml:ns:yang:1";
    public static final XMLNamespace RFC6020_YANG_NAMESPACE = XMLNamespace.of("urn:ietf:params:xml:ns:yang:1").intern();
    public static final QNameModule RFC6020_YANG_MODULE = QNameModule.create(RFC6020_YANG_NAMESPACE).intern();
    public static final String RFC6020_YIN_FILE_EXTENSION = ".yin";
    public static final String RFC6020_MAC_FILE_TYPE = "TEXT";
    public static final String RFC6020_YIN_MEDIA_TYPE = "application/yin+xml";
    public static final String RFC6020_YIN_NAMESPACE_STRING = "urn:ietf:params:xml:ns:yang:yin:1";
    public static final XMLNamespace RFC6020_YIN_NAMESPACE = XMLNamespace.of("urn:ietf:params:xml:ns:yang:yin:1").intern();
    public static final QNameModule RFC6020_YIN_MODULE = QNameModule.create(RFC6020_YIN_NAMESPACE).intern();
    public static final URI RFC7950_YANG_LIBRARY_CAPABILITY = URI.create("urn:ietf:params:netconf:capability:yang-library:1.0");
    public static final String YANG_XPATH_FUNCTIONS_PREFIX = "yang";
    public static final String NETCONF_NAMESPACE_STRING = "urn:ietf:params:xml:ns:netconf:base:1.0";
    public static final XMLNamespace NETCONF_NAMESPACE = XMLNamespace.of("urn:ietf:params:xml:ns:netconf:base:1.0").intern();
    public static final QNameModule RFC6241_YANG_MODULE = QNameModule.create(NETCONF_NAMESPACE, Revision.of("2011-06-01")).intern();
    public static final QName BAD_ATTRIBUTE_QNAME = QName.create(RFC6241_YANG_MODULE, "bad-attribute").intern();
    public static final QName BAD_ELEMENT_QNAME = QName.create(RFC6241_YANG_MODULE, "bad-element").intern();
    public static final QName BAD_NAMESPACE_QNAME = QName.create(RFC6241_YANG_MODULE, "bad-namespace").intern();
    public static final QName SESSION_ID_QNAME = QName.create(RFC6241_YANG_MODULE, "session-id").intern();
    @Deprecated(since="RFC6241")
    public static final QName ERR_ELEMENT_QNAME = QName.create(RFC6241_YANG_MODULE, "err-element").intern();
    @Deprecated(since="RFC6241")
    public static final QName NOOP_ELEMENT_QNAME = QName.create(RFC6241_YANG_MODULE, "noop-element").intern();
    @Deprecated(since="RFC6241")
    public static final QName OK_ELEMENT_QNAME = QName.create(RFC6241_YANG_MODULE, "ok-element").intern();
    public static final QName MISSING_CHOICE_QNAME = QName.create(RFC6020_YANG_MODULE, "missing-choice").intern();
    public static final QName NON_UNIQUE_QNAME = QName.create(RFC6020_YANG_MODULE, "non-unique").intern();
    private static final UnresolvedQName.Unqualified DUMMY_OPERATION_INPUT = UnresolvedQName.unqualified("input");
    private static final UnresolvedQName.Unqualified DUMMY_OPERATION_OUTPUT = UnresolvedQName.unqualified("output");

    private YangConstants() {
    }

    public static QName operationInputQName(QNameModule module) {
        return DUMMY_OPERATION_INPUT.bindTo(module);
    }

    public static QName operationOutputQName(QNameModule module) {
        return DUMMY_OPERATION_OUTPUT.bindTo(module);
    }
}

