/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.singleton.dom.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.eos.common.api.CandidateAlreadyRegisteredException;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipChangeState;
import org.opendaylight.mdsal.eos.common.api.GenericEntity;
import org.opendaylight.mdsal.eos.common.api.GenericEntityOwnershipCandidateRegistration;
import org.opendaylight.mdsal.eos.common.api.GenericEntityOwnershipChange;
import org.opendaylight.mdsal.eos.common.api.GenericEntityOwnershipListener;
import org.opendaylight.mdsal.eos.common.api.GenericEntityOwnershipService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceRegistration;
import org.opendaylight.mdsal.singleton.common.api.ServiceGroupIdentifier;
import org.opendaylight.mdsal.singleton.dom.impl.ClusterSingletonServiceGroup;
import org.opendaylight.mdsal.singleton.dom.impl.ServiceInfo;
import org.opendaylight.yangtools.concepts.HierarchicalIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClusterSingletonServiceGroupImpl<P extends HierarchicalIdentifier<P>, E extends GenericEntity<P>, C extends GenericEntityOwnershipChange<P, E>, G extends GenericEntityOwnershipListener<P, C>, S extends GenericEntityOwnershipService<P, E, G>>
extends ClusterSingletonServiceGroup<P, E, C> {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterSingletonServiceGroupImpl.class);
    private final S entityOwnershipService;
    private final String identifier;
    private final E serviceEntity;
    private final E cleanupEntity;
    private final Set<ClusterSingletonServiceRegistration> members = ConcurrentHashMap.newKeySet();
    private final Map<ClusterSingletonServiceRegistration, ServiceInfo> services = new HashMap<ClusterSingletonServiceRegistration, ServiceInfo>();
    private static final AtomicIntegerFieldUpdater<ClusterSingletonServiceGroupImpl> DIRTY_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ClusterSingletonServiceGroupImpl.class, "dirty");
    private volatile int dirty;
    private static final AtomicIntegerFieldUpdater<ClusterSingletonServiceGroupImpl> LOCK_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ClusterSingletonServiceGroupImpl.class, "lock");
    private volatile int lock;
    private final AtomicReference<SettableFuture<Void>> closeFuture = new AtomicReference();
    private @GuardedBy(value={"this"}) GenericEntityOwnershipCandidateRegistration<P, E> serviceEntityReg = null;
    private @GuardedBy(value={"this"}) EntityState serviceEntityState = EntityState.UNREGISTERED;
    private @GuardedBy(value={"this"}) GenericEntityOwnershipCandidateRegistration<P, E> cleanupEntityReg;
    private @GuardedBy(value={"this"}) EntityState cleanupEntityState = EntityState.UNREGISTERED;
    private volatile boolean initialized;

    ClusterSingletonServiceGroupImpl(String identifier, S entityOwnershipService, E mainEntity, E closeEntity, Collection<ClusterSingletonServiceRegistration> services) {
        Preconditions.checkArgument((!identifier.isEmpty() ? 1 : 0) != 0, (Object)"Identifier may not be empty");
        this.identifier = identifier;
        this.entityOwnershipService = (GenericEntityOwnershipService)Objects.requireNonNull(entityOwnershipService);
        this.serviceEntity = (GenericEntity)Objects.requireNonNull(mainEntity);
        this.cleanupEntity = (GenericEntity)Objects.requireNonNull(closeEntity);
        this.members.addAll(services);
        LOG.debug("Instantiated new service group for {}", (Object)identifier);
    }

    @VisibleForTesting
    ClusterSingletonServiceGroupImpl(String identifier, E mainEntity, E closeEntity, S entityOwnershipService) {
        this(identifier, entityOwnershipService, mainEntity, closeEntity, (Collection<ClusterSingletonServiceRegistration>)ImmutableList.of());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    ListenableFuture<?> closeClusterSingletonGroup() {
        ListenableFuture<?> ret = this.destroyGroup();
        this.members.clear();
        this.markDirty();
        if (this.tryLock()) {
            this.reconcileState();
        } else {
            LOG.debug("Service group {} postponing sync on close", (Object)this.identifier);
        }
        return ret;
    }

    private boolean isClosed() {
        return this.closeFuture.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initialize() throws CandidateAlreadyRegisteredException {
        Verify.verify((boolean)this.tryLock());
        try {
            Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (String)"Singleton group %s was already initilized", (Object)this.identifier);
            LOG.debug("Initializing service group {} with services {}", (Object)this.identifier, this.members);
            ClusterSingletonServiceGroupImpl clusterSingletonServiceGroupImpl = this;
            synchronized (clusterSingletonServiceGroupImpl) {
                this.serviceEntityState = EntityState.REGISTERED;
                this.serviceEntityReg = this.entityOwnershipService.registerCandidate(this.serviceEntity);
                this.initialized = true;
            }
        }
        finally {
            this.unlock();
        }
    }

    private void checkNotClosed() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (String)"Service group %s has already been closed", (Object)this.identifier);
    }

    @Override
    void registerService(ClusterSingletonServiceRegistration reg) {
        ClusterSingletonService service = this.verifyRegistration(reg);
        this.checkNotClosed();
        Preconditions.checkState((boolean)this.initialized, (String)"Service group %s is not initialized yet", (Object)this.identifier);
        LOG.debug("Adding service {} to service group {}", (Object)service, (Object)this.identifier);
        Verify.verify((boolean)this.members.add(reg));
        this.markDirty();
        if (!this.tryLock()) {
            LOG.debug("Service group {} delayed register of {}", (Object)this.identifier, (Object)reg);
            return;
        }
        this.reconcileState();
    }

    @Override
    ListenableFuture<?> unregisterService(ClusterSingletonServiceRegistration reg) {
        this.verifyRegistration(reg);
        this.checkNotClosed();
        Verify.verify((boolean)this.members.remove(reg));
        this.markDirty();
        if (this.members.isEmpty()) {
            return this.destroyGroup();
        }
        if (this.tryLock()) {
            this.reconcileState();
        } else {
            LOG.debug("Service group {} delayed unregister of {}", (Object)this.identifier, (Object)reg);
        }
        return null;
    }

    private ClusterSingletonService verifyRegistration(ClusterSingletonServiceRegistration reg) {
        ClusterSingletonService service = (ClusterSingletonService)reg.getInstance();
        Verify.verify((boolean)this.identifier.equals(((ServiceGroupIdentifier)service.getIdentifier()).getName()));
        return service;
    }

    private synchronized @NonNull ListenableFuture<?> destroyGroup() {
        SettableFuture future = SettableFuture.create();
        if (!this.closeFuture.compareAndSet(null, (SettableFuture<Void>)future)) {
            return (ListenableFuture)Verify.verifyNotNull(this.closeFuture.get());
        }
        if (this.serviceEntityReg != null) {
            LOG.debug("Service group {} unregistering service entity {}", (Object)this.identifier, this.serviceEntity);
            this.serviceEntityReg.close();
            this.serviceEntityReg = null;
        }
        this.markDirty();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void ownershipChanged(C ownershipChange) {
        LOG.debug("Ownership change {} for ClusterSingletonServiceGroup {}", ownershipChange, (Object)this.identifier);
        ClusterSingletonServiceGroupImpl clusterSingletonServiceGroupImpl = this;
        synchronized (clusterSingletonServiceGroupImpl) {
            this.lockedOwnershipChanged(ownershipChange);
        }
        if (this.isDirty()) {
            if (!this.tryLock()) {
                LOG.debug("Service group {} postponing ownership change sync", (Object)this.identifier);
                return;
            }
            this.reconcileState();
        }
    }

    @Holding(value={"this"})
    private void lockedOwnershipChanged(C ownershipChange) {
        GenericEntity entity = ownershipChange.getEntity();
        if (this.serviceEntity.equals((Object)entity)) {
            this.serviceOwnershipChanged(ownershipChange.getState(), ownershipChange.inJeopardy());
            this.markDirty();
        } else if (this.cleanupEntity.equals((Object)entity)) {
            this.cleanupCandidateOwnershipChanged(ownershipChange.getState(), ownershipChange.inJeopardy());
            this.markDirty();
        } else {
            LOG.warn("Group {} received unrecognized change {}", (Object)this.identifier, ownershipChange);
        }
    }

    @Holding(value={"this"})
    private void cleanupCandidateOwnershipChanged(EntityOwnershipChangeState state, boolean jeopardy) {
        if (jeopardy) {
            switch (state) {
                case LOCAL_OWNERSHIP_GRANTED: 
                case LOCAL_OWNERSHIP_RETAINED_WITH_NO_CHANGE: {
                    LOG.warn("Service group {} cleanup entity owned without certainty", (Object)this.identifier);
                    this.cleanupEntityState = EntityState.OWNED_JEOPARDY;
                    break;
                }
                case LOCAL_OWNERSHIP_LOST_NEW_OWNER: 
                case LOCAL_OWNERSHIP_LOST_NO_OWNER: 
                case REMOTE_OWNERSHIP_CHANGED: 
                case REMOTE_OWNERSHIP_LOST_NO_OWNER: {
                    LOG.info("Service group {} cleanup entity ownership uncertain", (Object)this.identifier);
                    this.cleanupEntityState = EntityState.UNOWNED;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled cleanup entity jeopardy change " + state);
                }
            }
            return;
        }
        if (this.cleanupEntityState == EntityState.OWNED_JEOPARDY) {
            LOG.info("Service group {} cleanup entity ownership ascertained", (Object)this.identifier);
        }
        switch (state) {
            case LOCAL_OWNERSHIP_GRANTED: 
            case LOCAL_OWNERSHIP_RETAINED_WITH_NO_CHANGE: {
                this.cleanupEntityState = EntityState.OWNED;
                break;
            }
            case LOCAL_OWNERSHIP_LOST_NEW_OWNER: 
            case LOCAL_OWNERSHIP_LOST_NO_OWNER: 
            case REMOTE_OWNERSHIP_CHANGED: 
            case REMOTE_OWNERSHIP_LOST_NO_OWNER: {
                this.cleanupEntityState = EntityState.UNOWNED;
                break;
            }
            default: {
                LOG.warn("Service group {} ignoring unhandled cleanup entity change {}", (Object)this.identifier, (Object)state);
            }
        }
    }

    @Holding(value={"this"})
    private void serviceOwnershipChanged(EntityOwnershipChangeState state, boolean jeopardy) {
        if (jeopardy) {
            LOG.info("Service group {} service entity ownership uncertain", (Object)this.identifier);
            switch (state) {
                case LOCAL_OWNERSHIP_GRANTED: 
                case LOCAL_OWNERSHIP_RETAINED_WITH_NO_CHANGE: {
                    this.serviceEntityState = EntityState.OWNED_JEOPARDY;
                    break;
                }
                case LOCAL_OWNERSHIP_LOST_NEW_OWNER: 
                case LOCAL_OWNERSHIP_LOST_NO_OWNER: 
                case REMOTE_OWNERSHIP_CHANGED: 
                case REMOTE_OWNERSHIP_LOST_NO_OWNER: {
                    this.serviceEntityState = EntityState.UNOWNED;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled cleanup entity jeopardy change " + state);
                }
            }
            return;
        }
        if (this.serviceEntityState == EntityState.OWNED_JEOPARDY) {
            LOG.info("Service group {} service entity ownership ascertained", (Object)this.identifier);
        }
        switch (state) {
            case LOCAL_OWNERSHIP_GRANTED: 
            case LOCAL_OWNERSHIP_RETAINED_WITH_NO_CHANGE: {
                LOG.debug("Service group {} acquired service entity ownership", (Object)this.identifier);
                this.serviceEntityState = EntityState.OWNED;
                break;
            }
            case LOCAL_OWNERSHIP_LOST_NEW_OWNER: 
            case LOCAL_OWNERSHIP_LOST_NO_OWNER: 
            case REMOTE_OWNERSHIP_CHANGED: 
            case REMOTE_OWNERSHIP_LOST_NO_OWNER: {
                LOG.debug("Service group {} lost service entity ownership", (Object)this.identifier);
                this.serviceEntityState = EntityState.UNOWNED;
                break;
            }
            default: {
                LOG.warn("Service group {} ignoring unhandled cleanup entity change {}", (Object)this.identifier, (Object)state);
            }
        }
    }

    private void reconcileState() {
        block7: {
            block6: {
                while (true) {
                    try {
                        if (this.conditionalClean()) {
                            this.tryReconcileState();
                        }
                    }
                    finally {
                        this.unlock();
                    }
                    if (!this.isDirty()) break block6;
                    if (!this.tryLock()) break;
                    LOG.debug("Service group {} re-running reconciliation", (Object)this.identifier);
                }
                LOG.debug("Service group {} will be reconciled by someone else", (Object)this.identifier);
                break block7;
            }
            LOG.debug("Service group {} is completely reconciled", (Object)this.identifier);
        }
    }

    private void serviceTransitionCompleted() {
        this.markDirty();
        if (this.tryLock()) {
            this.reconcileState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryReconcileState() {
        ImmutableSet localMembers;
        boolean haveCleanup;
        boolean haveService;
        ClusterSingletonServiceGroupImpl clusterSingletonServiceGroupImpl = this;
        synchronized (clusterSingletonServiceGroupImpl) {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            if (this.serviceEntityReg == null) break block26;
                            switch (this.serviceEntityState) {
                                case OWNED: 
                                case OWNED_JEOPARDY: {
                                    haveService = true;
                                    break block27;
                                }
                                case REGISTERED: 
                                case UNOWNED: 
                                case UNREGISTERED: {
                                    haveService = false;
                                    break block27;
                                }
                                default: {
                                    throw new IllegalStateException("Unhandled service entity state " + this.serviceEntityState);
                                }
                            }
                        }
                        haveService = false;
                    }
                    if (haveService && this.cleanupEntityReg == null) {
                        block25: {
                            LOG.debug("Service group {} registering cleanup entity", (Object)this.identifier);
                            try {
                                this.cleanupEntityState = EntityState.REGISTERED;
                                this.cleanupEntityReg = this.entityOwnershipService.registerCandidate(this.cleanupEntity);
                            }
                            catch (CandidateAlreadyRegisteredException e) {
                                LOG.error("Service group {} failed to take ownership, aborting", (Object)this.identifier, (Object)e);
                                if (this.serviceEntityReg == null) break block25;
                                this.serviceEntityReg.close();
                                this.serviceEntityReg = null;
                            }
                        }
                        this.markDirty();
                        return;
                    }
                    if (this.cleanupEntityReg == null) break block28;
                    switch (this.cleanupEntityState) {
                        case OWNED: {
                            haveCleanup = true;
                            break block29;
                        }
                        case OWNED_JEOPARDY: 
                        case REGISTERED: 
                        case UNOWNED: 
                        case UNREGISTERED: {
                            haveCleanup = false;
                            break block29;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled service entity state " + this.serviceEntityState);
                        }
                    }
                }
                haveCleanup = false;
            }
            localMembers = ImmutableSet.copyOf(this.members);
        }
        if (haveService && haveCleanup) {
            this.ensureServicesStarting((Set<ClusterSingletonServiceRegistration>)localMembers);
            return;
        }
        this.ensureServicesStopping();
        if (!haveService && this.services.isEmpty()) {
            SettableFuture<Void> localFuture;
            boolean canFinishClose;
            LOG.debug("Service group {} has no running services", (Object)this.identifier);
            ClusterSingletonServiceGroupImpl e = this;
            synchronized (e) {
                if (this.cleanupEntityReg != null) {
                    LOG.debug("Service group {} releasing cleanup entity", (Object)this.identifier);
                    this.cleanupEntityReg.close();
                    this.cleanupEntityReg = null;
                }
                switch (this.cleanupEntityState) {
                    case OWNED: 
                    case OWNED_JEOPARDY: 
                    case REGISTERED: {
                        canFinishClose = false;
                        break;
                    }
                    case UNOWNED: 
                    case UNREGISTERED: {
                        canFinishClose = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled cleanup entity state " + this.cleanupEntityState);
                    }
                }
            }
            if (canFinishClose && (localFuture = this.closeFuture.get()) != null && !localFuture.isDone()) {
                LOG.debug("Service group {} completing termination", (Object)this.identifier);
                localFuture.set(null);
            }
        }
    }

    private void ensureServicesStarting(Set<ClusterSingletonServiceRegistration> localConfig) {
        LOG.debug("Service group {} starting services", (Object)this.identifier);
        Iterator<Map.Entry<ClusterSingletonServiceRegistration, ServiceInfo>> it = this.services.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ClusterSingletonServiceRegistration, ServiceInfo> entry = it.next();
            ClusterSingletonServiceRegistration reg = entry.getKey();
            if (localConfig.contains(reg)) continue;
            ServiceInfo newInfo = this.ensureStopping(reg, entry.getValue());
            if (newInfo != null) {
                entry.setValue(newInfo);
                continue;
            }
            it.remove();
        }
        for (ClusterSingletonServiceRegistration reg : localConfig) {
            if (this.services.containsKey(reg)) continue;
            ClusterSingletonService service = (ClusterSingletonService)reg.getInstance();
            LOG.debug("Starting service {}", (Object)service);
            try {
                service.instantiateServiceInstance();
            }
            catch (Exception e) {
                LOG.warn("Service group {} service {} failed to start, attempting to continue", new Object[]{this.identifier, service, e});
                continue;
            }
            this.services.put(reg, ServiceInfo.started());
        }
    }

    private void ensureServicesStopping() {
        Iterator<Map.Entry<ClusterSingletonServiceRegistration, ServiceInfo>> it = this.services.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ClusterSingletonServiceRegistration, ServiceInfo> entry = it.next();
            ServiceInfo newInfo = this.ensureStopping(entry.getKey(), entry.getValue());
            if (newInfo != null) {
                entry.setValue(newInfo);
                continue;
            }
            it.remove();
        }
    }

    private ServiceInfo ensureStopping(ClusterSingletonServiceRegistration reg, ServiceInfo info) {
        switch (info.getState()) {
            case STARTED: {
                ListenableFuture future;
                final ClusterSingletonService service = (ClusterSingletonService)reg.getInstance();
                LOG.debug("Service group {} stopping service {}", (Object)this.identifier, (Object)service);
                try {
                    future = (ListenableFuture)Verify.verifyNotNull((Object)service.closeServiceInstance());
                }
                catch (Exception e) {
                    LOG.warn("Service group {} service {} failed to stop, attempting to continue", new Object[]{this.identifier, service, e});
                    return null;
                }
                Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

                    public void onSuccess(Object result) {
                        LOG.debug("Service group {} service {} stopped successfully", (Object)ClusterSingletonServiceGroupImpl.this.identifier, (Object)service);
                        ClusterSingletonServiceGroupImpl.this.serviceTransitionCompleted();
                    }

                    public void onFailure(Throwable cause) {
                        LOG.debug("Service group {} service {} stopped with error", new Object[]{ClusterSingletonServiceGroupImpl.this.identifier, service, cause});
                        ClusterSingletonServiceGroupImpl.this.serviceTransitionCompleted();
                    }
                }, (Executor)MoreExecutors.directExecutor());
                return info.toState(ServiceState.STOPPING, future);
            }
            case STOPPING: {
                if (info.getFuture().isDone()) {
                    LOG.debug("Service group {} removed stopped service {}", (Object)this.identifier, reg.getInstance());
                    return null;
                }
                return info;
            }
        }
        throw new IllegalStateException("Unhandled state " + info.getState());
    }

    private void markDirty() {
        this.dirty = 1;
    }

    private boolean isDirty() {
        return this.dirty != 0;
    }

    private boolean conditionalClean() {
        return DIRTY_UPDATER.compareAndSet(this, 1, 0);
    }

    private boolean tryLock() {
        return LOCK_UPDATER.compareAndSet(this, 0, 1);
    }

    private boolean unlock() {
        Verify.verify((boolean)LOCK_UPDATER.compareAndSet(this, 1, 0));
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("identifier", (Object)this.identifier).toString();
    }

    static enum ServiceState {
        STARTED,
        STOPPING;

    }

    private static enum EntityState {
        UNREGISTERED,
        REGISTERED,
        OWNED,
        OWNED_JEOPARDY,
        UNOWNED;

    }
}

