/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.meta;

import com.google.common.annotations.Beta;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.ModelStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementOrigin;

public interface EffectiveStatement<A, D extends DeclaredStatement<A>>
extends ModelStatement<A> {
    default public @NonNull StatementOrigin statementOrigin() {
        return this.getDeclared() != null ? StatementOrigin.DECLARATION : StatementOrigin.CONTEXT;
    }

    public @Nullable D getDeclared();

    public <K, V, N extends IdentifierNamespace<K, V>> @NonNull Optional<V> get(@NonNull Class<N> var1, @NonNull K var2);

    public <K, V, N extends IdentifierNamespace<K, V>> @NonNull Map<K, V> getAll(@NonNull Class<N> var1);

    public @NonNull List<? extends @NonNull EffectiveStatement<?, ?>> effectiveSubstatements();

    @Beta
    default public <T> Optional<T> findFirstEffectiveSubstatement(@NonNull Class<T> type) {
        return this.effectiveSubstatements().stream().filter(type::isInstance).findFirst().map(type::cast);
    }

    @Beta
    default public <V, T extends EffectiveStatement<V, ?>> Optional<V> findFirstEffectiveSubstatementArgument(@NonNull Class<T> type) {
        return this.findFirstEffectiveSubstatement(type).map(ModelStatement::argument);
    }

    @Beta
    default public <T extends EffectiveStatement<?, ?>> Stream<T> streamEffectiveSubstatements(@NonNull Class<T> type) {
        return this.effectiveSubstatements().stream().filter(type::isInstance).map(type::cast);
    }
}

