/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import com.google.common.annotations.Beta;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultMethodHelpers;
import org.opendaylight.yangtools.yang.model.api.stmt.EffectiveStatementNamespace;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;

@Beta
public interface DataTreeAwareEffectiveStatement<A, D extends DeclaredStatement<A>>
extends SchemaTreeAwareEffectiveStatement<A, D> {
    default public @NonNull Optional<DataTreeEffectiveStatement<?>> findDataTreeNode(@NonNull QName qname) {
        return this.get(DataTreeNamespace.class, Objects.requireNonNull(qname));
    }

    default public <E> @NonNull Optional<E> findDataTreeNode(Class<E> type, @NonNull QName qname) {
        return DefaultMethodHelpers.filterOptional(type, this.findDataTreeNode(qname));
    }

    @NonNullByDefault
    public static abstract class DataTreeNamespace
    extends EffectiveStatementNamespace<DataTreeEffectiveStatement<?>> {
        private DataTreeNamespace() {
        }
    }
}

