/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import com.google.common.annotations.Beta;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultMethodHelpers;
import org.opendaylight.yangtools.yang.model.api.stmt.EffectiveStatementNamespace;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;

@Beta
public interface SchemaTreeAwareEffectiveStatement<A, D extends DeclaredStatement<A>>
extends EffectiveStatement<A, D> {
    default public @NonNull Optional<SchemaTreeEffectiveStatement<?>> findSchemaTreeNode(@NonNull QName qname) {
        return this.get(SchemaTreeNamespace.class, Objects.requireNonNull(qname));
    }

    default public <E> @NonNull Optional<E> findSchemaTreeNode(@NonNull Class<E> type, @NonNull QName qname) {
        return DefaultMethodHelpers.filterOptional(type, this.findSchemaTreeNode(qname));
    }

    default public @NonNull Optional<SchemaTreeEffectiveStatement<?>> findSchemaTreeNode(QName ... qnames) {
        return this.findSchemaTreeNode(Arrays.asList(qnames));
    }

    default public <E> @NonNull Optional<E> findSchemaTreeNode(@NonNull Class<E> type, QName ... qnames) {
        return DefaultMethodHelpers.filterOptional(type, this.findSchemaTreeNode(Arrays.asList(qnames)));
    }

    default public @NonNull Optional<SchemaTreeEffectiveStatement<?>> findSchemaTreeNode(@NonNull List<QName> qnames) {
        Iterator<QName> it = qnames.iterator();
        SchemaTreeAwareEffectiveStatement parent = this;
        while (true) {
            Optional<SchemaTreeEffectiveStatement<?>> found = parent.findSchemaTreeNode(it.next());
            if (!it.hasNext() || found.isEmpty()) {
                return found;
            }
            SchemaTreeEffectiveStatement<?> node = found.orElseThrow();
            if (!(node instanceof SchemaTreeAwareEffectiveStatement)) break;
            parent = (SchemaTreeAwareEffectiveStatement)((Object)node);
        }
        return Optional.empty();
    }

    default public <E> @NonNull Optional<E> findSchemaTreeNode(@NonNull Class<E> type, @NonNull List<QName> qnames) {
        return DefaultMethodHelpers.filterOptional(type, this.findSchemaTreeNode(qnames));
    }

    default public @NonNull Optional<SchemaTreeEffectiveStatement<?>> findSchemaTreeNode(@NonNull SchemaNodeIdentifier.Descendant descendant) {
        return this.findSchemaTreeNode(descendant.getNodeIdentifiers());
    }

    default public <E> @NonNull Optional<E> findSchemaTreeNode(@NonNull Class<E> type, @NonNull SchemaNodeIdentifier.Descendant descendant) {
        return this.findSchemaTreeNode(type, descendant.getNodeIdentifiers());
    }

    @NonNullByDefault
    public static abstract class SchemaTreeNamespace
    extends EffectiveStatementNamespace<SchemaTreeEffectiveStatement<?>> {
        private SchemaTreeNamespace() {
        }
    }
}

