/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BitStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.EnumStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FractionDigitsStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LengthStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PathStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RangeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RequireInstanceStatement;

public interface TypeStatement
extends DeclaredStatement<QName> {
    @Override
    default public StatementDefinition statementDefinition() {
        return YangStmtMapping.TYPE;
    }

    public static interface BinarySpecification
    extends TypeStatement {
        default public @NonNull Collection<? extends LengthStatement> getLength() {
            return this.declaredSubstatements(LengthStatement.class);
        }
    }

    public static interface UnionSpecification
    extends TypeStatement {
        default public @NonNull Collection<? extends TypeStatement> getTypes() {
            return this.declaredSubstatements(TypeStatement.class);
        }
    }

    public static interface BitsSpecification
    extends TypeStatement {
        default public @NonNull Collection<? extends BitStatement> getBits() {
            return this.declaredSubstatements(BitStatement.class);
        }
    }

    public static interface IdentityRefSpecification
    extends TypeStatement {
        default public @NonNull Collection<? extends BaseStatement> getBases() {
            return this.declaredSubstatements(BaseStatement.class);
        }
    }

    public static interface InstanceIdentifierSpecification
    extends TypeStatement {
        default public @Nullable RequireInstanceStatement getRequireInstance() {
            Optional<RequireInstanceStatement> opt = this.findFirstDeclaredSubstatement(RequireInstanceStatement.class);
            return opt.isPresent() ? opt.get() : null;
        }
    }

    public static interface LeafrefSpecification
    extends TypeStatement {
        default public @NonNull PathStatement getPath() {
            return this.findFirstDeclaredSubstatement(PathStatement.class).get();
        }

        default public @Nullable RequireInstanceStatement getRequireInstance() {
            Optional<RequireInstanceStatement> opt = this.findFirstDeclaredSubstatement(RequireInstanceStatement.class);
            return opt.isPresent() ? opt.get() : null;
        }
    }

    public static interface EnumSpecification
    extends TypeStatement {
        default public @NonNull Collection<? extends EnumStatement> getEnums() {
            return this.declaredSubstatements(EnumStatement.class);
        }
    }

    public static interface StringRestrictions
    extends TypeStatement {
        default public @Nullable LengthStatement getLength() {
            Optional<LengthStatement> opt = this.findFirstDeclaredSubstatement(LengthStatement.class);
            return opt.isPresent() ? opt.get() : null;
        }

        default public @NonNull Collection<? extends PatternStatement> getPatterns() {
            return this.declaredSubstatements(PatternStatement.class);
        }
    }

    public static interface Decimal64Specification
    extends TypeStatement {
        default public @NonNull FractionDigitsStatement getFractionDigits() {
            return this.findFirstDeclaredSubstatement(FractionDigitsStatement.class).get();
        }

        default public @Nullable RangeStatement getRange() {
            Optional<RangeStatement> opt = this.findFirstDeclaredSubstatement(RangeStatement.class);
            return opt.isPresent() ? opt.get() : null;
        }
    }

    public static interface NumericalRestrictions
    extends TypeStatement {
        default public @Nullable RangeStatement getRange() {
            return this.findFirstDeclaredSubstatement(RangeStatement.class).orElse(null);
        }
    }
}

