/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.runtime.spi;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;

final class DefaultModuleInfoSnapshot
implements ModuleInfoSnapshot {
    private final ImmutableMap<SourceIdentifier, YangModuleInfo> moduleInfos;
    private final ImmutableMap<String, ClassLoader> classLoaders;
    private final @NonNull EffectiveModelContext effectiveModel;

    DefaultModuleInfoSnapshot(EffectiveModelContext effectiveModel, Map<SourceIdentifier, YangModuleInfo> moduleInfos, Map<String, ClassLoader> classLoaders) {
        this.effectiveModel = Objects.requireNonNull(effectiveModel);
        this.moduleInfos = ImmutableMap.copyOf(moduleInfos);
        this.classLoaders = ImmutableMap.copyOf(classLoaders);
    }

    public EffectiveModelContext getEffectiveModelContext() {
        return this.effectiveModel;
    }

    public ListenableFuture<? extends YangTextSchemaSource> getSource(SourceIdentifier sourceIdentifier) {
        YangModuleInfo info = (YangModuleInfo)this.moduleInfos.get((Object)sourceIdentifier);
        if (info == null) {
            return Futures.immediateFailedFuture((Throwable)new MissingSchemaSourceException("No source registered", sourceIdentifier));
        }
        return Futures.immediateFuture((Object)YangTextSchemaSource.delegateForByteSource((SourceIdentifier)sourceIdentifier, (ByteSource)info.getYangTextByteSource()));
    }

    public <T> Class<T> loadClass(String fullyQualifiedName) throws ClassNotFoundException {
        String packageName = BindingReflections.getModelRootPackageName((String)fullyQualifiedName);
        ClassLoader loader = (ClassLoader)this.classLoaders.get((Object)packageName);
        if (loader == null) {
            throw new ClassNotFoundException("Package " + packageName + " not found");
        }
        Class<?> loaded = loader.loadClass(fullyQualifiedName);
        return loaded;
    }
}

