/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.runtime.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.mdsal.binding.runtime.spi.DefaultModuleInfoSnapshot;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.repo.YangTextSchemaContextResolver;
import org.opendaylight.yangtools.yang.parser.repo.YangTextSchemaSourceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class ModuleInfoSnapshotResolver
implements Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleInfoSnapshotResolver.class);
    private final YangTextSchemaContextResolver ctxResolver;
    private final @GuardedBy(value={"this"}) ListMultimap<SourceIdentifier, RegisteredModuleInfo> sourceToInfoReg = MultimapBuilder.hashKeys().arrayListValues().build();
    private @GuardedBy(value={"this"}) @Nullable ModuleInfoSnapshot currentSnapshot;

    public ModuleInfoSnapshotResolver(String name, YangParserFactory parserFactory) {
        this.ctxResolver = YangTextSchemaContextResolver.create((String)name, (YangParserFactory)parserFactory);
    }

    public synchronized List<ObjectRegistration<YangModuleInfo>> registerModuleInfos(Iterable<? extends YangModuleInfo> moduleInfos) {
        ArrayList<ObjectRegistration<YangModuleInfo>> ret = new ArrayList<ObjectRegistration<YangModuleInfo>>();
        for (YangModuleInfo yangModuleInfo : moduleInfos) {
            ret.add(this.register(Objects.requireNonNull(yangModuleInfo)));
        }
        return ret;
    }

    @Holding(value={"this"})
    private ObjectRegistration<YangModuleInfo> register(@NonNull YangModuleInfo moduleInfo) {
        ImmutableList.Builder regBuilder = ImmutableList.builder();
        for (YangModuleInfo info : ModuleInfoSnapshotResolver.flatDependencies(moduleInfo)) {
            regBuilder.add((Object)this.registerModuleInfo(info));
        }
        final ImmutableList regInfos = regBuilder.build();
        return new AbstractObjectRegistration<YangModuleInfo>(moduleInfo){

            protected void removeRegistration() {
                ModuleInfoSnapshotResolver.this.unregister((ImmutableList<RegisteredModuleInfo>)regInfos);
            }
        };
    }

    @Holding(value={"this"})
    private RegisteredModuleInfo registerModuleInfo(@NonNull YangModuleInfo info) {
        YangTextSchemaSourceRegistration reg;
        SourceIdentifier sourceId = ModuleInfoSnapshotResolver.sourceIdentifierFrom(info);
        for (RegisteredModuleInfo reg2 : this.sourceToInfoReg.get((Object)sourceId)) {
            if (!info.equals(reg2.info)) continue;
            reg2.incRef();
            LOG.debug("Reusing registration {}", (Object)reg2);
            return reg2;
        }
        try {
            reg = this.ctxResolver.registerSource(ModuleInfoSnapshotResolver.toYangTextSource(sourceId, info));
        }
        catch (IOException | SchemaSourceException | YangSyntaxErrorException e) {
            throw new IllegalStateException("Failed to register info " + info, e);
        }
        RegisteredModuleInfo regInfo = new RegisteredModuleInfo(info, (Registration)reg, info.getClass().getClassLoader());
        LOG.debug("Created new registration {}", (Object)regInfo);
        this.sourceToInfoReg.put((Object)sourceId, (Object)regInfo);
        return regInfo;
    }

    public synchronized @NonNull ModuleInfoSnapshot takeSnapshot() {
        EffectiveModelContext effectiveModel = (EffectiveModelContext)this.ctxResolver.getEffectiveModelContext().orElseThrow();
        ModuleInfoSnapshot local = this.currentSnapshot;
        if (local != null && local.getEffectiveModelContext().equals(effectiveModel)) {
            return local;
        }
        return this.updateSnapshot(effectiveModel);
    }

    @Holding(value={"this"})
    private @NonNull ModuleInfoSnapshot updateSnapshot(EffectiveModelContext effectiveModel) {
        HashSet<RevisionSourceIdentifier> sources = new HashSet<RevisionSourceIdentifier>();
        for (Map.Entry entry : effectiveModel.getModuleStatements().entrySet()) {
            Optional revision = ((QNameModule)entry.getKey()).getRevision();
            ModuleEffectiveStatement moduleEffectiveStatement = (ModuleEffectiveStatement)entry.getValue();
            sources.add(RevisionSourceIdentifier.create((String)((UnresolvedQName.Unqualified)moduleEffectiveStatement.argument()).getLocalName(), (Optional)revision));
            moduleEffectiveStatement.streamEffectiveSubstatements(SubmoduleEffectiveStatement.class).map(submodule -> RevisionSourceIdentifier.create((String)((UnresolvedQName.Unqualified)submodule.argument()).getLocalName(), (Optional)revision)).forEach(sources::add);
        }
        HashMap<SourceIdentifier, YangModuleInfo> moduleInfos = new HashMap<SourceIdentifier, YangModuleInfo>();
        HashMap<String, ClassLoader> classLoaders = new HashMap<String, ClassLoader>();
        for (SourceIdentifier sourceIdentifier : sources) {
            List regs = this.sourceToInfoReg.get((Object)sourceIdentifier);
            Preconditions.checkState((!regs.isEmpty() ? 1 : 0) != 0, (String)"No registration for %s", (Object)sourceIdentifier);
            RegisteredModuleInfo reg = (RegisteredModuleInfo)regs.get(0);
            YangModuleInfo info = reg.info;
            moduleInfos.put(sourceIdentifier, info);
            Class<?> infoClass = info.getClass();
            classLoaders.put(BindingReflections.getModelRootPackageName((Package)infoClass.getPackage()), infoClass.getClassLoader());
        }
        DefaultModuleInfoSnapshot next = new DefaultModuleInfoSnapshot(effectiveModel, moduleInfos, classLoaders);
        this.currentSnapshot = next;
        return next;
    }

    private synchronized void unregister(ImmutableList<RegisteredModuleInfo> regInfos) {
        for (RegisteredModuleInfo regInfo : regInfos) {
            if (!regInfo.decRef()) {
                LOG.debug("Registration {} has references, not removing it", (Object)regInfo);
                continue;
            }
            SourceIdentifier sourceId = ModuleInfoSnapshotResolver.sourceIdentifierFrom(regInfo.info);
            if (!this.sourceToInfoReg.remove((Object)sourceId, (Object)regInfo)) {
                LOG.warn("Failed to find {} registered under {}", (Object)regInfo, (Object)sourceId);
            }
            regInfo.reg.close();
        }
    }

    static @NonNull YangTextSchemaSource toYangTextSource(YangModuleInfo moduleInfo) {
        return YangTextSchemaSource.delegateForByteSource((SourceIdentifier)ModuleInfoSnapshotResolver.sourceIdentifierFrom(moduleInfo), (ByteSource)moduleInfo.getYangTextByteSource());
    }

    private static @NonNull YangTextSchemaSource toYangTextSource(SourceIdentifier identifier, YangModuleInfo moduleInfo) {
        return YangTextSchemaSource.delegateForByteSource((SourceIdentifier)identifier, (ByteSource)moduleInfo.getYangTextByteSource());
    }

    private static SourceIdentifier sourceIdentifierFrom(YangModuleInfo moduleInfo) {
        QName name = moduleInfo.getName();
        return RevisionSourceIdentifier.create((String)name.getLocalName(), (Optional)name.getRevision());
    }

    private static @NonNull List<@NonNull YangModuleInfo> flatDependencies(YangModuleInfo moduleInfo) {
        LinkedHashSet<YangModuleInfo> requiredInfos = new LinkedHashSet<YangModuleInfo>();
        ModuleInfoSnapshotResolver.flatDependencies(requiredInfos, moduleInfo);
        return ImmutableList.copyOf(requiredInfos).reverse();
    }

    static void flatDependencies(Set<YangModuleInfo> set, YangModuleInfo moduleInfo) {
        if (set.add(moduleInfo)) {
            for (YangModuleInfo dep : moduleInfo.getImportedModules()) {
                ModuleInfoSnapshotResolver.flatDependencies(set, dep);
            }
        }
    }

    private static final class RegisteredModuleInfo {
        final Registration reg;
        final YangModuleInfo info;
        final ClassLoader loader;
        private int refcount = 1;

        RegisteredModuleInfo(YangModuleInfo info, Registration reg, ClassLoader loader) {
            this.info = Objects.requireNonNull(info);
            this.reg = Objects.requireNonNull(reg);
            this.loader = Objects.requireNonNull(loader);
        }

        void incRef() {
            ++this.refcount;
        }

        boolean decRef() {
            return --this.refcount == 0;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("info", (Object)this.info).add("registration", (Object)this.reg).add("classLoader", (Object)this.loader).add("refCount", this.refcount).toString();
        }
    }
}

