/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.field.FieldDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.field.FieldList;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.method.MethodDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.type.TypeDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.StackManipulation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.member.FieldAccess;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.matcher.ElementMatchers;

final class ByteBuddyUtils {
    private ByteBuddyUtils() {
    }

    static StackManipulation invokeMethod(Method method) {
        return MethodInvocation.invoke(ByteBuddyUtils.describe(method));
    }

    static StackManipulation invokeMethod(Class<?> clazz, String name, Class<?> ... args) {
        return MethodInvocation.invoke(ByteBuddyUtils.describe(clazz, name, args));
    }

    static StackManipulation getField(Field field) {
        return FieldAccess.forField(new FieldDescription.ForLoadedField(field).asDefined()).read();
    }

    static StackManipulation getField(TypeDescription instrumentedType, String fieldName) {
        return ByteBuddyUtils.fieldAccess(instrumentedType, fieldName).read();
    }

    static StackManipulation putField(TypeDescription instrumentedType, String fieldName) {
        return ByteBuddyUtils.fieldAccess(instrumentedType, fieldName).write();
    }

    private static MethodDescription.ForLoadedMethod describe(Method method) {
        return new MethodDescription.ForLoadedMethod(method);
    }

    private static MethodDescription.ForLoadedMethod describe(Class<?> clazz, String name, Class<?> ... args) {
        return ByteBuddyUtils.describe(ByteBuddyUtils.getMethod(clazz, name, args));
    }

    private static FieldAccess.Defined fieldAccess(TypeDescription instrumentedType, String fieldName) {
        return FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(fieldName))).getOnly());
    }

    private static Method getMethod(Class<?> clazz, String name, Class<?> ... args) {
        try {
            return clazz.getDeclaredMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }
}

