/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Verify;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.impl.AugmentationNodeContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CaseNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ChoiceNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ContainerNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.KeyedListNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ListNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeContextSupplier;
import org.opendaylight.mdsal.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeTypes;
import org.opendaylight.mdsal.binding.runtime.api.CaseRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ChoiceRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ContainerLikeRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ListRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.NotificationRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeTypeContainer;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DataContainerCodecPrototype<T extends RuntimeTypeContainer>
implements NodeContextSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(DataContainerCodecPrototype.class);
    private static final VarHandle INSTANCE;
    private final T type;
    private final QNameModule namespace;
    private final NodeCodecContext.CodecContextFactory factory;
    private final InstanceIdentifier.Item<?> bindingArg;
    private final YangInstanceIdentifier.PathArgument yangArg;
    private final BindingDataObjectCodecTreeNode.ChildAddressabilitySummary childAddressabilitySummary;
    private volatile DataContainerCodecContext<?, T> instance;

    private DataContainerCodecPrototype(Class<?> cls, YangInstanceIdentifier.PathArgument arg, T type, NodeCodecContext.CodecContextFactory factory) {
        this(InstanceIdentifier.Item.of(cls), arg, type, factory);
    }

    private DataContainerCodecPrototype(InstanceIdentifier.Item<?> bindingArg, YangInstanceIdentifier.PathArgument arg, T type, NodeCodecContext.CodecContextFactory factory) {
        this.bindingArg = bindingArg;
        this.yangArg = arg;
        this.type = type;
        this.factory = factory;
        if (arg instanceof YangInstanceIdentifier.AugmentationIdentifier) {
            Set childNames = ((YangInstanceIdentifier.AugmentationIdentifier)arg).getPossibleChildNames();
            Verify.verify((!childNames.isEmpty() ? 1 : 0) != 0, (String)"Unexpected empty identifier for %s", type);
            this.namespace = ((QName)childNames.iterator().next()).getModule();
        } else {
            this.namespace = arg.getNodeType().getModule();
        }
        this.childAddressabilitySummary = type instanceof RuntimeType ? DataContainerCodecPrototype.computeChildAddressabilitySummary(((RuntimeType)type).statement()) : BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.MIXED;
    }

    private static BindingDataObjectCodecTreeNode.ChildAddressabilitySummary computeChildAddressabilitySummary(Object nodeSchema) {
        if (nodeSchema instanceof DataNodeContainer) {
            boolean haveAddressable = false;
            boolean haveUnaddressable = false;
            block10: for (DataSchemaNode child : ((DataNodeContainer)nodeSchema).getChildNodes()) {
                if (child instanceof ContainerSchemaNode || child instanceof AugmentationSchemaNode) {
                    haveAddressable = true;
                    continue;
                }
                if (child instanceof ListSchemaNode) {
                    if (((ListSchemaNode)child).getKeyDefinition().isEmpty()) {
                        haveUnaddressable = true;
                        continue;
                    }
                    haveAddressable = true;
                    continue;
                }
                if (child instanceof AnydataSchemaNode || child instanceof AnyxmlSchemaNode || child instanceof TypedDataSchemaNode) {
                    haveUnaddressable = true;
                    continue;
                }
                if (child instanceof ChoiceSchemaNode) {
                    switch (DataContainerCodecPrototype.computeChildAddressabilitySummary(child)) {
                        case ADDRESSABLE: {
                            haveAddressable = true;
                            continue block10;
                        }
                        case MIXED: {
                            haveAddressable = true;
                            haveUnaddressable = true;
                            continue block10;
                        }
                        case UNADDRESSABLE: {
                            haveUnaddressable = true;
                            continue block10;
                        }
                    }
                    throw new IllegalStateException("Unhandled accessibility summary for " + child);
                }
                LOG.warn("Unhandled child node {}", (Object)child);
            }
            if (!haveAddressable) {
                return BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.UNADDRESSABLE;
            }
            return haveUnaddressable ? BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.MIXED : BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.ADDRESSABLE;
        }
        if (nodeSchema instanceof ChoiceSchemaNode) {
            boolean haveAddressable = false;
            boolean haveUnaddressable = false;
            block11: for (CaseSchemaNode child : ((ChoiceSchemaNode)nodeSchema).getCases()) {
                switch (DataContainerCodecPrototype.computeChildAddressabilitySummary(child)) {
                    case ADDRESSABLE: {
                        haveAddressable = true;
                        continue block11;
                    }
                    case UNADDRESSABLE: {
                        haveUnaddressable = true;
                        continue block11;
                    }
                    case MIXED: {
                        return BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.MIXED;
                    }
                }
                throw new IllegalStateException("Unhandled accessibility summary for " + child);
            }
            if (!haveAddressable) {
                return BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.UNADDRESSABLE;
            }
            return haveUnaddressable ? BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.MIXED : BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.ADDRESSABLE;
        }
        return BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.UNADDRESSABLE;
    }

    static DataContainerCodecPrototype<BindingRuntimeTypes> rootPrototype(NodeCodecContext.CodecContextFactory factory) {
        return new DataContainerCodecPrototype<BindingRuntimeTypes>(DataRoot.class, (YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)SchemaContext.NAME), factory.getRuntimeContext().getTypes(), factory);
    }

    static <T extends CompositeRuntimeType> DataContainerCodecPrototype<T> from(Class<?> cls, T type, NodeCodecContext.CodecContextFactory factory) {
        return new DataContainerCodecPrototype<T>(cls, (YangInstanceIdentifier.PathArgument)DataContainerCodecPrototype.createIdentifier(type), type, factory);
    }

    static <T extends CompositeRuntimeType> DataContainerCodecPrototype<T> from(InstanceIdentifier.Item<?> bindingArg, T type, NodeCodecContext.CodecContextFactory factory) {
        return new DataContainerCodecPrototype<T>(bindingArg, (YangInstanceIdentifier.PathArgument)DataContainerCodecPrototype.createIdentifier(type), type, factory);
    }

    static DataContainerCodecPrototype<AugmentRuntimeType> from(Class<?> augClass, YangInstanceIdentifier.AugmentationIdentifier arg, AugmentRuntimeType schema, NodeCodecContext.CodecContextFactory factory) {
        return new DataContainerCodecPrototype<AugmentRuntimeType>(augClass, (YangInstanceIdentifier.PathArgument)arg, schema, factory);
    }

    static DataContainerCodecPrototype<NotificationRuntimeType> from(Class<?> augClass, NotificationRuntimeType schema, NodeCodecContext.CodecContextFactory factory) {
        YangInstanceIdentifier.NodeIdentifier arg = YangInstanceIdentifier.NodeIdentifier.create((QName)((QName)schema.statement().argument()));
        return new DataContainerCodecPrototype<NotificationRuntimeType>(augClass, (YangInstanceIdentifier.PathArgument)arg, schema, factory);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier createIdentifier(CompositeRuntimeType type) {
        Object arg = type.statement().argument();
        Verify.verify((boolean)(arg instanceof QName), (String)"Unexpected type %s argument %s", (Object)type, (Object)arg);
        return YangInstanceIdentifier.NodeIdentifier.create((QName)((QName)arg));
    }

    @NonNull T getType() {
        return this.type;
    }

    BindingDataObjectCodecTreeNode.ChildAddressabilitySummary getChildAddressabilitySummary() {
        return this.childAddressabilitySummary;
    }

    QNameModule getNamespace() {
        return this.namespace;
    }

    NodeCodecContext.CodecContextFactory getFactory() {
        return this.factory;
    }

    Class<?> getBindingClass() {
        return this.bindingArg.getType();
    }

    InstanceIdentifier.Item<?> getBindingArg() {
        return this.bindingArg;
    }

    YangInstanceIdentifier.PathArgument getYangArg() {
        return this.yangArg;
    }

    @Override
    public DataContainerCodecContext<?, T> get() {
        DataContainerCodecContext<?, T> existing = INSTANCE.getAcquire(this);
        return existing != null ? existing : this.loadInstance();
    }

    private @NonNull DataContainerCodecContext<?, T> loadInstance() {
        DataContainerCodecContext tmp = this.createInstance();
        DataContainerCodecContext witness = INSTANCE.compareAndExchangeRelease(this, null, tmp);
        return witness == null ? tmp : witness;
    }

    private @NonNull DataContainerCodecContext<?, T> createInstance() {
        if (this.type instanceof ContainerLikeRuntimeType) {
            return new ContainerNodeCodecContext(this);
        }
        if (this.type instanceof ListRuntimeType) {
            return Identifiable.class.isAssignableFrom(this.getBindingClass()) ? KeyedListNodeCodecContext.create(this) : new ListNodeCodecContext(this);
        }
        if (this.type instanceof ChoiceRuntimeType) {
            return new ChoiceNodeCodecContext(this);
        }
        if (this.type instanceof AugmentRuntimeType) {
            return new AugmentationNodeContext(this);
        }
        if (this.type instanceof CaseRuntimeType) {
            return new CaseNodeCodecContext(this);
        }
        throw new IllegalArgumentException("Unsupported type " + this.getBindingClass() + " " + this.type);
    }

    static {
        try {
            INSTANCE = MethodHandles.lookup().findVarHandle(DataContainerCodecPrototype.class, "instance", DataContainerCodecContext.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

