/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingStreamEventWriter;
import org.opendaylight.mdsal.binding.dom.codec.impl.ByteBuddyUtils;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectSerializerRegistry;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectStreamer;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.ByteBuddy;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.field.FieldDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.method.MethodDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.method.MethodList;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.type.TypeDefinition;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.type.TypeDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.dynamic.DynamicType;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.Implementation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.Duplication;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.StackManipulation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.TypeCreation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.constant.ClassConstant;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.constant.TextConstant;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.jar.asm.MethodVisitor;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.matcher.ElementMatcher;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.matcher.ElementMatchers;
import org.opendaylight.mdsal.binding.dom.codec.loader.CodecClassLoader;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingSchemaMapping;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DataObjectStreamerGenerator<T extends DataObjectStreamer<?>>
implements CodecClassLoader.ClassGenerator<T> {
    static final String INSTANCE_FIELD = "INSTANCE";
    private static final Logger LOG = LoggerFactory.getLogger(DataObjectStreamerGenerator.class);
    private static final TypeDescription.Generic BB_VOID = TypeDefinition.Sort.describe(Void.TYPE);
    private static final TypeDescription.Generic BB_DATAOBJECT = TypeDefinition.Sort.describe(DataObject.class);
    private static final TypeDescription.Generic BB_DOSR = TypeDefinition.Sort.describe(DataObjectSerializerRegistry.class);
    private static final TypeDescription.Generic BB_BESV = TypeDefinition.Sort.describe(BindingStreamEventWriter.class);
    private static final TypeDescription.Generic BB_IOX = TypeDefinition.Sort.describe(IOException.class);
    private static final int PUB_FINAL = 4113;
    private static final int PUB_CONST = 4121;
    private static final DynamicType.Builder<?> TEMPLATE = new ByteBuddy().subclass(DataObjectStreamer.class).modifiers(4113);
    private static final StackManipulation REG = MethodVariableAccess.REFERENCE.loadFrom(1);
    private static final StackManipulation OBJ = MethodVariableAccess.REFERENCE.loadFrom(2);
    private static final StackManipulation STREAM = MethodVariableAccess.REFERENCE.loadFrom(3);
    private static final StackManipulation UNKNOWN_SIZE = IntegerConstant.forValue(-1);
    private static final StackManipulation START_AUGMENTATION_NODE = ByteBuddyUtils.invokeMethod(BindingStreamEventWriter.class, "startAugmentationNode", Class.class);
    private static final StackManipulation START_CASE = ByteBuddyUtils.invokeMethod(BindingStreamEventWriter.class, "startCase", Class.class, Integer.TYPE);
    private static final StackManipulation START_CONTAINER_NODE = ByteBuddyUtils.invokeMethod(BindingStreamEventWriter.class, "startContainerNode", Class.class, Integer.TYPE);
    private static final StackManipulation END_NODE = ByteBuddyUtils.invokeMethod(BindingStreamEventWriter.class, "endNode", new Class[0]);
    private static final StackManipulation START_MAP_ENTRY_NODE = new StackManipulation.Compound(OBJ, ByteBuddyUtils.invokeMethod(Identifiable.class, "key", new Class[0]), UNKNOWN_SIZE, ByteBuddyUtils.invokeMethod(BindingStreamEventWriter.class, "startMapEntryNode", Identifier.class, Integer.TYPE));
    private static final StackManipulation START_UNKEYED_LIST_ITEM = new StackManipulation.Compound(UNKNOWN_SIZE, ByteBuddyUtils.invokeMethod(BindingStreamEventWriter.class, "startUnkeyedListItem", Integer.TYPE));
    private static final StackManipulation STREAM_ANYDATA = ByteBuddyUtils.invokeMethod(DataObjectStreamer.class, "streamAnydata", BindingStreamEventWriter.class, String.class, Object.class);
    private static final StackManipulation STREAM_ANYXML = ByteBuddyUtils.invokeMethod(DataObjectStreamer.class, "streamAnyxml", BindingStreamEventWriter.class, String.class, Object.class);
    private static final StackManipulation STREAM_CHOICE = ByteBuddyUtils.invokeMethod(DataObjectStreamer.class, "streamChoice", Class.class, DataObjectSerializerRegistry.class, BindingStreamEventWriter.class, DataContainer.class);
    private static final StackManipulation STREAM_CONTAINER = ByteBuddyUtils.invokeMethod(DataObjectStreamer.class, "streamContainer", DataObjectStreamer.class, DataObjectSerializerRegistry.class, BindingStreamEventWriter.class, DataObject.class);
    private static final StackManipulation STREAM_LEAF = ByteBuddyUtils.invokeMethod(DataObjectStreamer.class, "streamLeaf", BindingStreamEventWriter.class, String.class, Object.class);
    private static final StackManipulation STREAM_LEAF_LIST = ByteBuddyUtils.invokeMethod(DataObjectStreamer.class, "streamLeafList", BindingStreamEventWriter.class, String.class, Set.class);
    private static final StackManipulation STREAM_ORDERED_LEAF_LIST = ByteBuddyUtils.invokeMethod(DataObjectStreamer.class, "streamOrderedLeafList", BindingStreamEventWriter.class, String.class, List.class);
    private static final StackManipulation STREAM_LIST = ByteBuddyUtils.invokeMethod(DataObjectStreamer.class, "streamList", Class.class, DataObjectStreamer.class, DataObjectSerializerRegistry.class, BindingStreamEventWriter.class, List.class);
    private static final StackManipulation STREAM_MAP = ByteBuddyUtils.invokeMethod(DataObjectStreamer.class, "streamMap", Class.class, DataObjectStreamer.class, DataObjectSerializerRegistry.class, BindingStreamEventWriter.class, Map.class);
    private static final StackManipulation STREAM_ORDERED_MAP = ByteBuddyUtils.invokeMethod(DataObjectStreamer.class, "streamOrderedMap", Class.class, DataObjectStreamer.class, DataObjectSerializerRegistry.class, BindingStreamEventWriter.class, List.class);
    private static final StackManipulation STREAM_AUGMENTATIONS = new StackManipulation.Compound(REG, STREAM, OBJ, ByteBuddyUtils.invokeMethod(DataObjectStreamer.class, "streamAugmentations", DataObjectSerializerRegistry.class, BindingStreamEventWriter.class, Augmentable.class));
    private final NodeCodecContext.CodecContextFactory registry;
    private final StackManipulation startEvent;
    private final DataNodeContainer schema;
    private final Class<?> type;
    private final GeneratedType genType;

    private DataObjectStreamerGenerator(NodeCodecContext.CodecContextFactory registry, GeneratedType genType, DataNodeContainer schema, Class<?> type, StackManipulation startEvent) {
        this.registry = Objects.requireNonNull(registry);
        this.genType = Objects.requireNonNull(genType);
        this.schema = Objects.requireNonNull(schema);
        this.type = Objects.requireNonNull(type);
        this.startEvent = Objects.requireNonNull(startEvent);
    }

    static Class<? extends DataObjectStreamer<?>> generateStreamer(CodecClassLoader loader, NodeCodecContext.CodecContextFactory registry, Class<?> type) {
        StackManipulation startEvent;
        RuntimeType typeAndSchema = registry.getRuntimeContext().getTypeWithSchema(type);
        EffectiveStatement schema = typeAndSchema.statement();
        if (schema instanceof ContainerLike || schema instanceof NotificationDefinition) {
            startEvent = DataObjectStreamerGenerator.classUnknownSizeMethod(START_CONTAINER_NODE, type);
        } else if (schema instanceof ListSchemaNode) {
            startEvent = ((ListSchemaNode)schema).getKeyDefinition().isEmpty() ? START_UNKEYED_LIST_ITEM : START_MAP_ENTRY_NODE;
        } else if (schema instanceof AugmentationSchemaNode) {
            startEvent = new StackManipulation.Compound(ClassConstant.of(TypeDefinition.Sort.describe(type).asErasure()), START_AUGMENTATION_NODE);
        } else if (schema instanceof CaseSchemaNode) {
            startEvent = DataObjectStreamerGenerator.classUnknownSizeMethod(START_CASE, type);
        } else {
            throw new UnsupportedOperationException("Schema type " + schema.getClass() + " is not supported");
        }
        return loader.generateClass(type, "streamer", new DataObjectStreamerGenerator(registry, (GeneratedType)typeAndSchema.javaType(), (DataNodeContainer)schema, type, startEvent));
    }

    @Override
    public CodecClassLoader.GeneratorResult<T> generateClass(CodecClassLoader loader, String fqcn, Class<?> bindingInterface) {
        LOG.trace("Definining streamer {}", (Object)fqcn);
        DynamicType.Builder<?> builder = TEMPLATE.name(fqcn);
        ImmutableMap<String, Type> props = DataObjectStreamerGenerator.collectAllProperties(this.genType);
        ArrayList<ChildStream> children = new ArrayList<ChildStream>(props.size());
        for (Object schemaChild : this.schema.getChildNodes()) {
            Method getter;
            if (schemaChild.isAugmenting()) continue;
            String getterName = BindingSchemaMapping.getGetterMethodName((DataSchemaNode)schemaChild);
            try {
                getter = this.type.getMethod(getterName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Failed to find getter " + getterName, e);
            }
            ChildStream child = this.createStream(loader, props, (DataSchemaNode)schemaChild, getter);
            if (child == null) continue;
            children.add(child);
        }
        ImmutableList.Builder depBuilder = ImmutableList.builder();
        for (ChildStream child : children) {
            Class<?> dependency = child.getDependency();
            if (dependency == null) continue;
            depBuilder.add(dependency);
        }
        CodecClassLoader.GeneratorResult result = CodecClassLoader.GeneratorResult.of(builder.defineMethod("serialize", (TypeDefinition)BB_VOID, 4113).withParameters(BB_DOSR, BB_DATAOBJECT, BB_BESV).throwing(BB_IOX).intercept(new SerializeImplementation(bindingInterface, this.startEvent, children)).make(), depBuilder.build());
        LOG.trace("Definition of {} done", (Object)fqcn);
        return result;
    }

    private ChildStream createStream(CodecClassLoader loader, ImmutableMap<String, Type> props, DataSchemaNode childSchema, Method getter) {
        if (childSchema instanceof LeafSchemaNode) {
            return DataObjectStreamerGenerator.qnameChildStream(STREAM_LEAF, getter, childSchema);
        }
        if (childSchema instanceof ContainerSchemaNode) {
            return this.containerChildStream(getter);
        }
        if (childSchema instanceof ListSchemaNode) {
            Class<?> valueClass;
            String getterName = getter.getName();
            Type childType = (Type)props.get((Object)getterName);
            Verify.verify((boolean)(childType instanceof ParameterizedType), (String)"Unexpected type %s for %s", (Object)childType, (Object)getterName);
            Type[] params = ((ParameterizedType)childType).getActualTypeArguments();
            ListSchemaNode listSchema = (ListSchemaNode)childSchema;
            if (!listSchema.isUserOrdered() && !listSchema.getKeyDefinition().isEmpty()) {
                DataObjectStreamerGenerator.loadTypeClass(loader, params[0]);
                valueClass = DataObjectStreamerGenerator.loadTypeClass(loader, params[1]);
            } else {
                valueClass = DataObjectStreamerGenerator.loadTypeClass(loader, params[0]);
            }
            return this.listChildStream(getter, valueClass.asSubclass(DataObject.class), listSchema);
        }
        if (childSchema instanceof ChoiceSchemaNode) {
            return DataObjectStreamerGenerator.choiceChildStream(getter);
        }
        if (childSchema instanceof AnydataSchemaNode) {
            return DataObjectStreamerGenerator.qnameChildStream(STREAM_ANYDATA, getter, childSchema);
        }
        if (childSchema instanceof AnyxmlSchemaNode) {
            return DataObjectStreamerGenerator.qnameChildStream(STREAM_ANYXML, getter, childSchema);
        }
        if (childSchema instanceof LeafListSchemaNode) {
            return DataObjectStreamerGenerator.qnameChildStream(((LeafListSchemaNode)childSchema).isUserOrdered() ? STREAM_ORDERED_LEAF_LIST : STREAM_LEAF_LIST, getter, childSchema);
        }
        LOG.debug("Ignoring {} due to unhandled schema {}", (Object)getter, (Object)childSchema);
        return null;
    }

    private static ChildStream choiceChildStream(Method getter) {
        return new ChildStream(ClassConstant.of(TypeDefinition.Sort.describe(getter.getReturnType()).asErasure()), REG, STREAM, OBJ, ByteBuddyUtils.invokeMethod(getter), STREAM_CHOICE);
    }

    private ChildStream containerChildStream(Method getter) {
        Class<DataObject> itemClass = getter.getReturnType().asSubclass(DataObject.class);
        DataObjectStreamer<?> streamer = this.registry.getDataObjectSerializer(itemClass);
        return new ChildStream(streamer, DataObjectStreamerGenerator.streamerInstance(streamer), REG, STREAM, OBJ, ByteBuddyUtils.invokeMethod(getter), STREAM_CONTAINER);
    }

    private ChildStream listChildStream(Method getter, Class<? extends DataObject> itemClass, ListSchemaNode childSchema) {
        DataObjectStreamer<?> streamer = this.registry.getDataObjectSerializer(itemClass);
        StackManipulation method = childSchema.getKeyDefinition().isEmpty() ? STREAM_LIST : (childSchema.isUserOrdered() ? STREAM_ORDERED_MAP : STREAM_MAP);
        return new ChildStream(streamer, ClassConstant.of(TypeDefinition.Sort.describe(itemClass).asErasure()), DataObjectStreamerGenerator.streamerInstance(streamer), REG, STREAM, OBJ, ByteBuddyUtils.invokeMethod(getter), method);
    }

    private static ChildStream qnameChildStream(StackManipulation method, Method getter, DataSchemaNode schema) {
        return new ChildStream(STREAM, new TextConstant(schema.getQName().getLocalName()), OBJ, ByteBuddyUtils.invokeMethod(getter), method);
    }

    private static StackManipulation streamerInstance(DataObjectStreamer<?> streamer) {
        try {
            return ByteBuddyUtils.getField(streamer.getClass().getDeclaredField(INSTANCE_FIELD));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    private static StackManipulation classUnknownSizeMethod(StackManipulation method, Class<?> type) {
        return new StackManipulation.Compound(ClassConstant.of(TypeDefinition.Sort.describe(type).asErasure()), UNKNOWN_SIZE, method);
    }

    private static ImmutableMap<String, Type> collectAllProperties(GeneratedType type) {
        HashMap<String, Type> props = new HashMap<String, Type>();
        DataObjectStreamerGenerator.collectAllProperties(type, props);
        return ImmutableMap.copyOf(props);
    }

    private static void collectAllProperties(GeneratedType type, Map<String, Type> hashMap) {
        for (MethodSignature definition : type.getMethodDefinitions()) {
            hashMap.put(definition.getName(), definition.getReturnType());
        }
        for (Type parent : type.getImplements()) {
            if (!(parent instanceof GeneratedType)) continue;
            DataObjectStreamerGenerator.collectAllProperties((GeneratedType)parent, hashMap);
        }
    }

    private static Class<?> loadTypeClass(CodecClassLoader loader, Type type) {
        try {
            return loader.loadClass(type.getFullyQualifiedName());
        }
        catch (ClassNotFoundException e) {
            throw new LinkageError("Failed to load " + type, e);
        }
    }

    private static enum InitializeInstanceField implements ByteCodeAppender
    {
        INSTANCE;

        private static final ElementMatcher<MethodDescription> IS_DEFAULT_CONSTRUCTOR;

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            TypeDescription instrumentedType = implementationContext.getInstrumentedType();
            StackManipulation.Size operandStackSize = new StackManipulation.Compound(TypeCreation.of(instrumentedType), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)instrumentedType.getDeclaredMethods().filter(IS_DEFAULT_CONSTRUCTOR)).getOnly()).asDefined()), ByteBuddyUtils.putField(instrumentedType, DataObjectStreamerGenerator.INSTANCE_FIELD)).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(operandStackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        static {
            IS_DEFAULT_CONSTRUCTOR = ElementMatchers.isDefaultConstructor();
        }
    }

    private static final class ChildStream
    extends StackManipulation.Compound {
        private final @Nullable Class<?> dependency;

        ChildStream(StackManipulation ... stackManipulation) {
            super(stackManipulation);
            this.dependency = null;
        }

        ChildStream(DataObjectStreamer<?> streamer, StackManipulation ... stackManipulation) {
            super(stackManipulation);
            this.dependency = streamer.getClass();
        }

        @Nullable Class<?> getDependency() {
            return this.dependency;
        }
    }

    private static final class SerializeImplementation
    implements Implementation {
        private final List<ChildStream> children;
        private final StackManipulation startEvent;
        private final Class<?> bindingInterface;

        SerializeImplementation(Class<?> bindingInterface, StackManipulation startEvent, List<ChildStream> children) {
            this.bindingInterface = Objects.requireNonNull(bindingInterface);
            this.startEvent = Objects.requireNonNull(startEvent);
            this.children = Objects.requireNonNull(children);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(new FieldDescription.Token(DataObjectStreamerGenerator.INSTANCE_FIELD, 4121, instrumentedType.asGenericType())).withInitializer(InitializeInstanceField.INSTANCE);
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            ArrayList<StackManipulation> manipulations = new ArrayList<StackManipulation>(this.children.size() + 6);
            manipulations.add(STREAM);
            manipulations.add(this.startEvent);
            manipulations.addAll(this.children);
            if (Augmentable.class.isAssignableFrom(this.bindingInterface)) {
                manipulations.add(STREAM_AUGMENTATIONS);
            }
            manipulations.add(STREAM);
            manipulations.add(END_NODE);
            manipulations.add(MethodReturn.VOID);
            return new ByteCodeAppender.Simple(manipulations);
        }
    }
}

