/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.SchemaUnawareCodec;

final class EncapsulatedValueCodec
extends SchemaUnawareCodec {
    private static final MethodType OBJ_METHOD = MethodType.methodType(Object.class, Object.class);
    private static final LoadingCache<Class<?>, EncapsulatedValueCodec> CACHE = CacheBuilder.newBuilder().weakKeys().softValues().build(new CacheLoader<Class<?>, EncapsulatedValueCodec>(){

        public EncapsulatedValueCodec load(Class<?> key) throws ReflectiveOperationException {
            Method m = key.getMethod("getValue", new Class[0]);
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodHandle getter = lookup.unreflect(m).asType(OBJ_METHOD);
            Class<?> valueType = m.getReturnType();
            MethodHandle constructor = lookup.findConstructor(key, MethodType.methodType(Void.TYPE, valueType)).asType(OBJ_METHOD);
            return new EncapsulatedValueCodec(constructor, getter, valueType);
        }
    });
    private final MethodHandle constructor;
    private final MethodHandle getter;
    private final Class<?> valueType;

    private EncapsulatedValueCodec(MethodHandle constructor, MethodHandle getter, Class<?> valueType) {
        this.constructor = Objects.requireNonNull(constructor);
        this.getter = Objects.requireNonNull(getter);
        this.valueType = Objects.requireNonNull(valueType);
    }

    static @NonNull EncapsulatedValueCodec of(Class<?> typeClz) throws ExecutionException {
        return (EncapsulatedValueCodec)((Object)CACHE.get(typeClz));
    }

    static @NonNull EncapsulatedValueCodec ofUnchecked(Class<?> typeClz) {
        return (EncapsulatedValueCodec)((Object)CACHE.getUnchecked(typeClz));
    }

    boolean canAcceptObject(Object value) {
        return this.valueType.isInstance(value);
    }

    protected Object deserializeImpl(Object input) {
        try {
            return this.constructor.invokeExact(input);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    protected Object serializeImpl(Object input) {
        try {
            return this.getter.invokeExact(input);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }
}

