/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.LazyBindingList;
import org.opendaylight.mdsal.binding.dom.codec.impl.LazyBindingMap;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LazyBindingMapIterState<K extends Identifier<V>, V extends DataObject & Identifiable<K>>
extends LazyBindingMap.State<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(LazyBindingMapIterState.class);
    private static final VarHandle ENTRY_SET;
    private static final VarHandle KEY_SET;
    private static final VarHandle LOOKUP_MAP;
    private final @NonNull Values<K, V> values;
    private volatile KeySet<K, V> keySet;
    private volatile EntrySet<K, V> entrySet;
    private volatile ImmutableMap<K, V> lookupMap;

    LazyBindingMapIterState(LazyBindingMap<K, V> map) {
        this.values = new Values<K, V>(map);
    }

    @Override
    boolean containsKey(Object key) {
        return this.lookupMap().containsKey(key);
    }

    @Override
    V get(Object key) {
        return (V)((DataObject)this.lookupMap().get(key));
    }

    Values<K, V> values() {
        return this.values;
    }

    EntrySet<K, V> entrySet() {
        EntrySet<K, V> ret = ENTRY_SET.getAcquire(this);
        return ret != null ? ret : this.loadEntrySet();
    }

    KeySet<K, V> keySet() {
        KeySet<K, V> ret = KEY_SET.getAcquire(this);
        return ret != null ? ret : this.loadKeySet();
    }

    private @NonNull ImmutableMap<K, V> lookupMap() {
        ImmutableMap<K, V> ret = LOOKUP_MAP.getAcquire(this);
        return ret != null ? ret : this.loadLookupMap();
    }

    private synchronized @NonNull ImmutableMap<K, V> loadLookupMap() {
        ImmutableMap ret = LOOKUP_MAP.getAcquire(this);
        if (ret == null) {
            this.lookupMap = ret = ImmutableMap.copyOf((Iterable)this.entrySet());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Inefficient instantiation of lookup secondary", new Throwable());
            }
        }
        return ret;
    }

    private @NonNull EntrySet<K, V> loadEntrySet() {
        EntrySet ret = new EntrySet(this.values);
        Object witness = ENTRY_SET.compareAndExchangeRelease(this, null, ret);
        return witness == null ? ret : (EntrySet)witness;
    }

    private @NonNull KeySet<K, V> loadKeySet() {
        KeySet ret = new KeySet(this.values);
        Object witness = KEY_SET.compareAndExchangeRelease(this, null, ret);
        return witness == null ? ret : (KeySet)witness;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            ENTRY_SET = lookup.findVarHandle(LazyBindingMapIterState.class, "entrySet", EntrySet.class);
            KEY_SET = lookup.findVarHandle(LazyBindingMapIterState.class, "keySet", KeySet.class);
            LOOKUP_MAP = lookup.findVarHandle(LazyBindingMapIterState.class, "lookupMap", ImmutableMap.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class Values<K extends Identifier<V>, V extends DataObject & Identifiable<K>>
    extends AbstractSet<V>
    implements Immutable {
        private final LazyBindingMap<K, V> map;
        private final Object[] objects;

        Values(LazyBindingMap<K, V> map) {
            this.map = Objects.requireNonNull(map);
            this.objects = map.mapNode().body().toArray();
        }

        @Override
        public Iterator<V> iterator() {
            return new AbstractIterator<V>(){
                private int nextOffset;

                protected V computeNext() {
                    return this.nextOffset < objects.length ? this.objectAt(this.nextOffset++) : (DataObject)this.endOfData();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @NonNull V objectAt(int offset) {
            Object obj = LazyBindingList.OBJ_AA.getAcquire(this.objects, offset);
            return (V)(obj instanceof MapEntryNode ? this.loadObjectAt(offset, (MapEntryNode)obj) : (DataObject)obj);
        }

        private @NonNull V loadObjectAt(int offset, MapEntryNode obj) {
            V ret = this.map.createValue(obj);
            Object witness = LazyBindingList.OBJ_AA.compareAndExchangeRelease(this.objects, offset, obj, (DataObject)ret);
            return (V)(witness == obj ? ret : (DataObject)witness);
        }
    }

    private static final class KeySet<K extends Identifier<V>, V extends DataObject & Identifiable<K>>
    extends AbstractSet<K>
    implements Immutable {
        private final Values<K, V> values;

        KeySet(Values<K, V> values) {
            this.values = Objects.requireNonNull(values);
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public Iterator<K> iterator() {
            return Iterators.transform(this.values.iterator(), value -> ((Identifiable)value).key());
        }

        @Override
        public boolean contains(Object o) {
            return this.values.map.containsKey(o);
        }
    }

    private static final class EntrySet<K extends Identifier<V>, V extends DataObject & Identifiable<K>>
    extends AbstractSet<Map.Entry<K, V>>
    implements Immutable {
        private final Values<K, V> values;

        EntrySet(Values<K, V> values) {
            this.values = Objects.requireNonNull(values);
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Iterators.transform(this.values.iterator(), value -> Map.entry(((Identifiable)value).key(), value));
        }

        @Override
        public boolean contains(Object o) {
            return this.values.contains(((Map.Entry)o).getValue());
        }
    }
}

