/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.LazyBindingList;
import org.opendaylight.mdsal.binding.runtime.api.ListRuntimeType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;

class ListNodeCodecContext<D extends DataObject>
extends DataObjectCodecContext<D, ListRuntimeType> {
    ListNodeCodecContext(DataContainerCodecPrototype<ListRuntimeType> prototype) {
        super(prototype);
    }

    ListNodeCodecContext(DataContainerCodecPrototype<ListRuntimeType> prototype, Method keyMethod) {
        super(prototype, keyMethod);
    }

    public D deserialize(NormalizedNode node) {
        if (node instanceof MapEntryNode) {
            return this.createBindingProxy((DistinctNodeContainer<?, ?>)((MapEntryNode)node));
        }
        if (node instanceof UnkeyedListEntryNode) {
            return this.createBindingProxy((DistinctNodeContainer<?, ?>)((UnkeyedListEntryNode)node));
        }
        throw new IllegalStateException("Unsupported data type " + node.getClass());
    }

    @Override
    protected Object deserializeObject(NormalizedNode node) {
        if (node instanceof MapNode) {
            return this.fromMap((MapNode)node);
        }
        if (node instanceof MapEntryNode) {
            return this.createBindingProxy((DistinctNodeContainer<?, ?>)((MapEntryNode)node));
        }
        if (node instanceof UnkeyedListNode) {
            return this.fromUnkeyedList((UnkeyedListNode)node);
        }
        if (node instanceof UnkeyedListEntryNode) {
            return this.createBindingProxy((DistinctNodeContainer<?, ?>)((UnkeyedListEntryNode)node));
        }
        throw new IllegalStateException("Unsupported data type " + node.getClass());
    }

    @NonNull Object fromMap(MapNode map, int size) {
        return LazyBindingList.create(this, size, map.body());
    }

    private Object fromMap(MapNode map) {
        int size = map.size();
        return size == 0 ? null : this.fromMap(map, size);
    }

    private List<D> fromUnkeyedList(UnkeyedListNode node) {
        int size = node.size();
        return size == 0 ? null : LazyBindingList.create(this, size, node.body());
    }
}

