/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.IncorrectNestingException;
import org.opendaylight.mdsal.binding.dom.codec.impl.ActionCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ChoiceNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ContainerNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NotificationCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.RpcInputCodec;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.runtime.api.ActionRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeTypes;
import org.opendaylight.mdsal.binding.runtime.api.ChoiceRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ContainerLikeRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.DataRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.InputRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.NotificationRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.OutputRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedListAction;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

final class SchemaRootCodecContext<D extends DataObject>
extends DataContainerCodecContext<D, BindingRuntimeTypes> {
    private final LoadingCache<Class<? extends DataObject>, DataContainerCodecContext<?, ?>> childrenByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<? extends DataObject>, DataContainerCodecContext<?, ?>>(){

        public DataContainerCodecContext<?, ?> load(Class<? extends DataObject> key) {
            return SchemaRootCodecContext.this.createDataTreeChildContext(key);
        }
    });
    private final LoadingCache<Class<? extends Action<?, ?, ?>>, ActionCodecContext> actionsByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<? extends Action<?, ?, ?>>, ActionCodecContext>(){

        public ActionCodecContext load(Class<? extends Action<?, ?, ?>> key) {
            return SchemaRootCodecContext.this.createActionContext(key);
        }
    });
    private final LoadingCache<Class<? extends DataObject>, ChoiceNodeCodecContext<?>> choicesByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<? extends DataObject>, ChoiceNodeCodecContext<?>>(){

        public ChoiceNodeCodecContext<?> load(Class<? extends DataObject> key) {
            return SchemaRootCodecContext.this.createChoiceDataContext(key);
        }
    });
    private final LoadingCache<Class<?>, NotificationCodecContext<?>> notificationsByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, NotificationCodecContext<?>>(){

        public NotificationCodecContext<?> load(Class<?> key) {
            Preconditions.checkArgument((boolean)key.isInterface(), (Object)"Supplied class must be interface.");
            QName qname = BindingReflections.findQName(key);
            RuntimeType child = ((BindingRuntimeTypes)SchemaRootCodecContext.this.getType()).schemaTreeChild(qname);
            Preconditions.checkArgument((boolean)(child instanceof NotificationRuntimeType), (String)"Supplied %s is not valid notification", key);
            return new NotificationCodecContext(key, (NotificationRuntimeType)child, SchemaRootCodecContext.this.factory());
        }
    });
    private final LoadingCache<Class<?>, ContainerNodeCodecContext<?>> rpcDataByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, ContainerNodeCodecContext<?>>(){

        public ContainerNodeCodecContext<?> load(Class<?> key) {
            BiFunction<BindingRuntimeTypes, QName, Optional> lookup;
            if (RpcInput.class.isAssignableFrom(key)) {
                lookup = BindingRuntimeTypes::findRpcInput;
            } else if (RpcOutput.class.isAssignableFrom(key)) {
                lookup = BindingRuntimeTypes::findRpcOutput;
            } else {
                throw new IllegalArgumentException(key + " does not represent an RPC container");
            }
            NodeCodecContext.CodecContextFactory factory = SchemaRootCodecContext.this.factory();
            BindingRuntimeContext context = factory.getRuntimeContext();
            QName qname = BindingReflections.findQName(key);
            QNameModule qnameModule = qname.getModule();
            Module module = (Module)context.getEffectiveModelContext().findModule(qnameModule).orElseThrow(() -> new IllegalArgumentException("Failed to find module for " + qnameModule));
            String className = BindingMapping.getClassName((QName)qname);
            for (RpcDefinition potential : module.getRpcs()) {
                QName potentialQName = potential.getQName();
                if (!key.getSimpleName().equals(BindingMapping.getClassName((QName)potentialQName) + className)) continue;
                ContainerLike schema = SchemaRootCodecContext.getRpcDataSchema(potential, qname);
                Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (String)"Schema for %s does not define input / output.", (Object)potentialQName);
                ContainerLikeRuntimeType type = (ContainerLikeRuntimeType)lookup.apply(context.getTypes(), potentialQName).orElseThrow(() -> new IllegalArgumentException("Cannot find runtime type for " + key));
                return (ContainerNodeCodecContext)DataContainerCodecPrototype.from(key, type, factory).get();
            }
            throw new IllegalArgumentException("Supplied class " + key + " is not valid RPC class.");
        }
    });
    private final LoadingCache<QName, DataContainerCodecContext<?, ?>> childrenByQName = CacheBuilder.newBuilder().build(new CacheLoader<QName, DataContainerCodecContext<?, ?>>(){

        public DataContainerCodecContext<?, ?> load(QName qname) throws ClassNotFoundException {
            BindingRuntimeTypes type = (BindingRuntimeTypes)SchemaRootCodecContext.this.getType();
            RuntimeType child = SchemaRootCodecContext.this.childNonNull(type.schemaTreeChild(qname), qname, "Argument %s is not valid child of %s", qname, type);
            if (!(child instanceof DataRuntimeType)) {
                throw IncorrectNestingException.create((String)"Argument %s is not valid data tree child of %s", (Object[])new Object[]{qname, type});
            }
            EffectiveStatement childSchema = child.statement();
            if (childSchema instanceof DataNodeContainer || childSchema instanceof ChoiceSchemaNode) {
                return SchemaRootCodecContext.this.streamChild(SchemaRootCodecContext.this.factory().getRuntimeContext().loadClass(child.javaType()));
            }
            throw new UnsupportedOperationException("Unsupported child type " + childSchema.getClass());
        }
    });
    private final LoadingCache<SchemaNodeIdentifier.Absolute, RpcInputCodec<?>> rpcDataByPath = CacheBuilder.newBuilder().build(new CacheLoader<SchemaNodeIdentifier.Absolute, RpcInputCodec<?>>(){

        public RpcInputCodec<?> load(SchemaNodeIdentifier.Absolute key) {
            Class container;
            QName rpcName = key.firstNodeIdentifier();
            BindingRuntimeContext context = SchemaRootCodecContext.this.factory().getRuntimeContext();
            switch (key.lastNodeIdentifier().getLocalName()) {
                case "input": {
                    container = context.getRpcInput(rpcName);
                    break;
                }
                case "output": {
                    container = context.getRpcOutput(rpcName);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled path " + key);
                }
            }
            return SchemaRootCodecContext.this.getRpc(container);
        }
    });
    private final LoadingCache<SchemaNodeIdentifier.Absolute, NotificationCodecContext<?>> notificationsByPath = CacheBuilder.newBuilder().build(new CacheLoader<SchemaNodeIdentifier.Absolute, NotificationCodecContext<?>>(){

        public NotificationCodecContext<?> load(SchemaNodeIdentifier.Absolute key) {
            Class cls = SchemaRootCodecContext.this.factory().getRuntimeContext().getClassForSchema(key);
            Preconditions.checkArgument((boolean)Notification.class.isAssignableFrom(cls), (String)"Path %s does not represent a notification", (Object)key);
            return SchemaRootCodecContext.this.getNotificationImpl(cls);
        }
    });

    private SchemaRootCodecContext(DataContainerCodecPrototype<BindingRuntimeTypes> dataPrototype) {
        super(dataPrototype);
    }

    static SchemaRootCodecContext<?> create(NodeCodecContext.CodecContextFactory factory) {
        return new SchemaRootCodecContext(DataContainerCodecPrototype.rootPrototype(factory));
    }

    public DocumentedNode.WithStatus getSchema() {
        return ((BindingRuntimeTypes)this.getType()).getEffectiveModelContext();
    }

    @Override
    public <C extends DataObject> DataContainerCodecContext<C, ?> streamChild(Class<C> childClass) {
        NotificationCodecContext<C> result = Notification.class.isAssignableFrom(childClass) ? this.getNotificationImpl(childClass) : SchemaRootCodecContext.getOrRethrow(this.childrenByClass, childClass);
        return result;
    }

    @Override
    public <C extends DataObject> Optional<DataContainerCodecContext<C, ?>> possibleStreamChild(Class<C> childClass) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public DataContainerCodecContext<?, ?> yangPathArgumentChild(YangInstanceIdentifier.PathArgument arg) {
        return SchemaRootCodecContext.getOrRethrow(this.childrenByQName, arg.getNodeType());
    }

    public D deserialize(NormalizedNode normalizedNode) {
        throw new UnsupportedOperationException("Could not create Binding data representation for root");
    }

    ActionCodecContext getAction(Class<? extends Action<?, ?, ?>> action) {
        return SchemaRootCodecContext.getOrRethrow(this.actionsByClass, action);
    }

    NotificationCodecContext<?> getNotification(SchemaNodeIdentifier.Absolute notification) {
        return SchemaRootCodecContext.getOrRethrow(this.notificationsByPath, notification);
    }

    NotificationCodecContext<?> getNotification(Class<? extends Notification<?>> notification) {
        return this.getNotificationImpl(notification);
    }

    private NotificationCodecContext<?> getNotificationImpl(Class<?> notification) {
        return SchemaRootCodecContext.getOrRethrow(this.notificationsByClass, notification);
    }

    ContainerNodeCodecContext<?> getRpc(Class<? extends DataContainer> rpcInputOrOutput) {
        return SchemaRootCodecContext.getOrRethrow(this.rpcDataByClass, rpcInputOrOutput);
    }

    RpcInputCodec<?> getRpc(SchemaNodeIdentifier.Absolute containerPath) {
        return SchemaRootCodecContext.getOrRethrow(this.rpcDataByPath, containerPath);
    }

    DataContainerCodecContext<?, ?> createDataTreeChildContext(Class<? extends DataObject> key) {
        RuntimeType childSchema = (RuntimeType)this.childNonNull(((BindingRuntimeTypes)this.getType()).bindingChild(JavaTypeName.create(key)), key, "%s is not top-level item.", key);
        if (childSchema instanceof CompositeRuntimeType && childSchema instanceof DataRuntimeType) {
            return DataContainerCodecPrototype.from(key, (CompositeRuntimeType)childSchema, this.factory()).get();
        }
        throw IncorrectNestingException.create((String)"%s is not a valid data tree child of %s", (Object[])new Object[]{key, this});
    }

    ActionCodecContext createActionContext(Class<? extends Action<?, ?, ?>> action) {
        if (KeyedListAction.class.isAssignableFrom(action)) {
            return this.prepareActionContext(2, 3, 4, action, KeyedListAction.class);
        }
        if (Action.class.isAssignableFrom(action)) {
            return this.prepareActionContext(1, 2, 3, action, Action.class);
        }
        throw new IllegalArgumentException("The specific action type does not exist for action " + action.getName());
    }

    private ActionCodecContext prepareActionContext(int inputOffset, int outputOffset, int expectedArgsLength, Class<? extends Action<?, ?, ?>> action, Class<?> actionType) {
        Optional optParamType = ClassLoaderUtils.findParameterizedType(action, actionType);
        Preconditions.checkState((boolean)optParamType.isPresent(), (String)"%s does not specialize %s", action, actionType);
        ParameterizedType paramType = (ParameterizedType)optParamType.get();
        Type[] args = paramType.getActualTypeArguments();
        Preconditions.checkArgument((args.length == expectedArgsLength ? 1 : 0) != 0, (String)"Unexpected (%s) Action generatic arguments", (int)args.length);
        ActionRuntimeType schema = this.factory().getRuntimeContext().getActionDefinition(action);
        return new ActionCodecContext((DataContainerCodecContext<?, InputRuntimeType>)DataContainerCodecPrototype.from(SchemaRootCodecContext.asClass(args[inputOffset], RpcInput.class), schema.input(), this.factory()).get(), (DataContainerCodecContext<?, OutputRuntimeType>)DataContainerCodecPrototype.from(SchemaRootCodecContext.asClass(args[outputOffset], RpcOutput.class), schema.output(), this.factory()).get());
    }

    private static <T extends DataObject> Class<? extends T> asClass(Type type, Class<T> target) {
        Verify.verify((boolean)(type instanceof Class), (String)"Type %s is not a class", (Object)type);
        return ((Class)type).asSubclass(target);
    }

    private static @Nullable ContainerLike getRpcDataSchema(@NonNull RpcDefinition rpc, @NonNull QName qname) {
        Objects.requireNonNull(rpc, "Rpc Schema must not be null");
        switch (Objects.requireNonNull(qname, "QName must not be null").getLocalName()) {
            case "input": {
                return rpc.getInput();
            }
            case "output": {
                return rpc.getOutput();
            }
        }
        throw new IllegalArgumentException("Supplied qname " + qname + " does not represent rpc input or output.");
    }

    ChoiceNodeCodecContext<?> createChoiceDataContext(Class<? extends DataObject> caseType) {
        Class<?> choiceClass = SchemaRootCodecContext.findCaseChoice(caseType);
        Preconditions.checkArgument((choiceClass != null ? 1 : 0) != 0, (String)"Class %s is not a valid case representation", caseType);
        CompositeRuntimeType schema = this.factory().getRuntimeContext().getSchemaDefinition(choiceClass);
        Preconditions.checkArgument((boolean)(schema instanceof ChoiceRuntimeType), (String)"Class %s does not refer to a choice", caseType);
        NodeCodecContext choice = DataContainerCodecPrototype.from(choiceClass, (ChoiceRuntimeType)schema, this.factory()).get();
        Verify.verify((boolean)(choice instanceof ChoiceNodeCodecContext));
        return (ChoiceNodeCodecContext)choice;
    }

    @Override
    protected Object deserializeObject(NormalizedNode normalizedNode) {
        throw new UnsupportedOperationException("Unable to deserialize root");
    }

    public InstanceIdentifier.PathArgument deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((arg == null ? 1 : 0) != 0);
        return null;
    }

    public YangInstanceIdentifier.PathArgument serializePathArgument(InstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((arg == null ? 1 : 0) != 0);
        return null;
    }

    @Override
    public DataContainerCodecContext<?, ?> bindingPathArgumentChild(InstanceIdentifier.PathArgument arg, List<YangInstanceIdentifier.PathArgument> builder) {
        Optional caseType = arg.getCaseType();
        if (caseType.isPresent()) {
            @NonNull Class type = (Class)caseType.orElseThrow();
            ChoiceNodeCodecContext choice = (ChoiceNodeCodecContext)this.choicesByClass.getUnchecked((Object)type);
            choice.addYangPathArgument(arg, builder);
            BindingDataObjectCodecTreeNode caze = choice.streamChild(type);
            caze.addYangPathArgument(arg, builder);
            return caze.bindingPathArgumentChild(arg, (List)builder);
        }
        return super.bindingPathArgumentChild(arg, (List)builder);
    }

    private static Class<?> findCaseChoice(Class<? extends DataObject> caseClass) {
        for (Type type : caseClass.getGenericInterfaces()) {
            Class typeClass;
            if (!(type instanceof Class) || !ChoiceIn.class.isAssignableFrom(typeClass = (Class)type)) continue;
            return typeClass.asSubclass(ChoiceIn.class);
        }
        return null;
    }

    private static <K, V> V getOrRethrow(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                Throwables.throwIfUnchecked((Throwable)cause);
            }
            throw e;
        }
    }
}

