/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.BitsCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.EncapsulatedValueCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.EnumerationCodec;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.concepts.AbstractIllegalArgumentCodec;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;

abstract class SchemaUnawareCodec
extends AbstractIllegalArgumentCodec<Object, Object> {
    static final @NonNull SchemaUnawareCodec NOOP_CODEC = new SchemaUnawareCodec(){

        protected Object serializeImpl(Object input) {
            return input;
        }

        protected Object deserializeImpl(Object input) {
            return input;
        }
    };

    SchemaUnawareCodec() {
    }

    static @NonNull SchemaUnawareCodec of(Class<?> typeClz, TypeDefinition<?> def) {
        if (BindingReflections.isBindingClass(typeClz)) {
            return SchemaUnawareCodec.getCachedSchemaUnawareCodec(typeClz, def);
        }
        return NOOP_CODEC;
    }

    private static @NonNull SchemaUnawareCodec getCachedSchemaUnawareCodec(Class<?> typeClz, TypeDefinition<?> def) {
        TypeDefinition base;
        TypeDefinition rootType = Objects.requireNonNull(def);
        while ((base = rootType.getBaseType()) != null) {
            rootType = base;
        }
        try {
            if (rootType instanceof EnumTypeDefinition) {
                return EnumerationCodec.of(typeClz, (EnumTypeDefinition)rootType);
            }
            if (rootType instanceof BitsTypeDefinition) {
                return BitsCodec.of(typeClz, (BitsTypeDefinition)rootType);
            }
            return EncapsulatedValueCodec.of(typeClz);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }
}

