/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.UnionValueOptionContext;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeGeneratedUnion;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.yangtools.concepts.IllegalArgumentCodec;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;

final class UnionTypeCodec
implements IllegalArgumentCodec<Object, Object> {
    private final ImmutableSet<UnionValueOptionContext> typeCodecs;
    private final Class<?> unionClass;

    private UnionTypeCodec(Class<?> unionClass, List<UnionValueOptionContext> typeCodecs) {
        this.unionClass = Objects.requireNonNull(unionClass);
        this.typeCodecs = ImmutableSet.copyOf(typeCodecs);
    }

    static UnionTypeCodec of(Class<?> unionCls, UnionTypeDefinition unionType, BindingCodecContext codecContext) throws Exception {
        List<String> unionProperties = UnionTypeCodec.extractUnionProperties(codecContext.getRuntimeContext().getTypeWithSchema(unionCls).javaType());
        List unionTypes = unionType.getTypes();
        Verify.verify((unionTypes.size() == unionProperties.size() ? 1 : 0) != 0, (String)"Mismatched union types %s and properties %s", (Object)unionTypes, unionProperties);
        ArrayList<UnionValueOptionContext> values = new ArrayList<UnionValueOptionContext>(unionTypes.size());
        Iterator<String> it = unionProperties.iterator();
        for (TypeDefinition subtype : unionTypes) {
            String getterName = "get" + BindingMapping.toFirstUpper((String)it.next());
            Method valueGetter = unionCls.getMethod(getterName, new Class[0]);
            Class<?> valueType = valueGetter.getReturnType();
            IllegalArgumentCodec<Object, Object> codec = codecContext.getCodec(valueType, subtype);
            values.add(new UnionValueOptionContext(unionCls, valueType, valueGetter, codec));
        }
        return new UnionTypeCodec(unionCls, values);
    }

    private static List<String> extractUnionProperties(Type type) {
        Verify.verify((boolean)(type instanceof GeneratedTransferObject), (String)"Unexpected runtime type %s", (Object)type);
        GeneratedTransferObject gto = (GeneratedTransferObject)type;
        while (!(gto instanceof RuntimeGeneratedUnion)) {
            gto = (GeneratedTransferObject)Verify.verifyNotNull((Object)gto.getSuperType(), (String)"Cannot find union type information for %s", (Object[])new Object[]{type});
        }
        return ((RuntimeGeneratedUnion)gto).typePropertyNames();
    }

    public Object deserialize(Object input) {
        for (UnionValueOptionContext member : this.typeCodecs) {
            Object ret = member.deserializeUnion(input);
            if (ret == null) continue;
            return ret;
        }
        throw new IllegalArgumentException(String.format("Failed to construct instance of %s for input %s", this.unionClass, input));
    }

    public Object serialize(Object input) {
        for (UnionValueOptionContext valCtx : this.typeCodecs) {
            Object domValue = valCtx.serialize(input);
            if (domValue == null) continue;
            return domValue;
        }
        throw new IllegalStateException("No codec matched value " + input);
    }
}

