/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.loader;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.type.TypeDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.dynamic.DynamicType;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.dom.codec.loader.LeafCodecClassLoader;
import org.opendaylight.mdsal.binding.dom.codec.loader.RootCodecClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class CodecClassLoader
extends ClassLoader {
    private static final ClassLoadingStrategy<CodecClassLoader> STRATEGY = (classLoader, types) -> {
        Verify.verify((types.size() == 1 ? 1 : 0) != 0, (String)"Unexpected multiple types", (Object)types);
        Map.Entry entry = types.entrySet().iterator().next();
        return ImmutableMap.of((Object)((TypeDescription)entry.getKey()), classLoader.loadClass(((TypeDescription)entry.getKey()).getName(), (byte[])entry.getValue()));
    };
    private static final Logger LOG;
    private static final File BYTECODE_DIRECTORY;

    CodecClassLoader(ClassLoader parentLoader) {
        super(parentLoader);
    }

    public static @NonNull CodecClassLoader create() {
        return AccessController.doPrivileged(() -> new RootCodecClassLoader());
    }

    public final <T> Class<T> generateClass(Class<?> bindingInterface, String suffix, ClassGenerator<T> generator) {
        return this.findClassLoader(Objects.requireNonNull(bindingInterface)).doGenerateClass(bindingInterface, suffix, generator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final @NonNull Class<?> getGeneratedClass(Class<?> bindingInterface, String suffix) {
        Class<?> ret;
        CodecClassLoader loader = this.findClassLoader(Objects.requireNonNull(bindingInterface));
        String fqcn = CodecClassLoader.generatedClassName(bindingInterface, suffix);
        Object object = loader.getClassLoadingLock(fqcn);
        synchronized (object) {
            ret = loader.findLoadedClass(fqcn);
        }
        Preconditions.checkArgument((ret != null ? 1 : 0) != 0, (String)"Failed to find generated class %s for %s of %s", (Object)fqcn, (Object)suffix, bindingInterface);
        return ret;
    }

    abstract void appendLoaders(@NonNull Set<LeafCodecClassLoader> var1);

    abstract @NonNull CodecClassLoader findClassLoader(@NonNull Class<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Class<T> doGenerateClass(Class<?> bindingInterface, String suffix, ClassGenerator<T> generator) {
        String fqcn = CodecClassLoader.generatedClassName(bindingInterface, suffix);
        Object object = this.getClassLoadingLock(fqcn);
        synchronized (object) {
            Class<?> existing = this.findLoadedClass(fqcn);
            if (existing != null) {
                return existing;
            }
            GeneratorResult<T> result = generator.generateClass(this, fqcn, bindingInterface);
            DynamicType.Unloaded unloaded = result.getResult();
            Verify.verify((boolean)fqcn.equals(unloaded.getTypeDescription().getName()), (String)"Unexpected class in %s", unloaded);
            Verify.verify((boolean)unloaded.getAuxiliaryTypes().isEmpty(), (String)"Auxiliary types present in %s", unloaded);
            CodecClassLoader.dumpBytecode(unloaded);
            this.processDependencies((Collection<Class<?>>)result.getDependencies());
            return generator.customizeLoading(() -> unloaded.load(this, STRATEGY).getLoaded());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Class<?> loadClass(String fqcn, byte[] byteCode) {
        Object object = this.getClassLoadingLock(fqcn);
        synchronized (object) {
            Class<?> existing = this.findLoadedClass(fqcn);
            Verify.verify((existing == null ? 1 : 0) != 0, (String)"Attempted to load existing %s", existing);
            return this.defineClass(fqcn, byteCode, 0, byteCode.length);
        }
    }

    private void processDependencies(Collection<Class<?>> deps) {
        HashSet<LeafCodecClassLoader> depLoaders = new HashSet<LeafCodecClassLoader>();
        for (Class<?> dep : deps) {
            ClassLoader depLoader = dep.getClassLoader();
            Verify.verify((boolean)(depLoader instanceof CodecClassLoader), (String)"Dependency %s is not a generated class", dep);
            if (this.equals(depLoader)) continue;
            try {
                this.loadClass(dep.getName());
            }
            catch (ClassNotFoundException e) {
                LOG.debug("Cannot find {} in local loader, attempting to compensate", dep, (Object)e);
                Verify.verify((boolean)(depLoader instanceof LeafCodecClassLoader), (String)"Dependency loader %s is not a leaf", (Object)depLoader);
                depLoaders.add((LeafCodecClassLoader)depLoader);
            }
        }
        if (!depLoaders.isEmpty()) {
            this.appendLoaders(depLoaders);
        }
    }

    private static void dumpBytecode(DynamicType.Unloaded<?> unloaded) {
        if (BYTECODE_DIRECTORY != null) {
            try {
                unloaded.saveIn(BYTECODE_DIRECTORY);
            }
            catch (IOException | IllegalArgumentException e) {
                LOG.info("Failed to save {}", (Object)unloaded.getTypeDescription().getName(), (Object)e);
            }
        }
    }

    private static String generatedClassName(Class<?> bindingInterface, String suffix) {
        return bindingInterface.getName() + "$$$" + suffix;
    }

    static {
        Verify.verify((boolean)ClassLoader.registerAsParallelCapable());
        LOG = LoggerFactory.getLogger(CodecClassLoader.class);
        String dir = System.getProperty("org.opendaylight.mdsal.binding.dom.codec.loader.bytecodeDumpDirectory");
        BYTECODE_DIRECTORY = Strings.isNullOrEmpty((String)dir) ? null : new File(dir);
    }

    public static final class GeneratorResult<T> {
        private final @NonNull ImmutableSet<Class<?>> dependecies;
        private final  @NonNull DynamicType.Unloaded<T> result;

        GeneratorResult(DynamicType.Unloaded<T> result, ImmutableSet<Class<?>> dependecies) {
            this.result = Objects.requireNonNull(result);
            this.dependecies = Objects.requireNonNull(dependecies);
        }

        public static <T> @NonNull GeneratorResult<T> of(DynamicType.Unloaded<T> result) {
            return new GeneratorResult<T>(result, ImmutableSet.of());
        }

        public static <T> @NonNull GeneratorResult<T> of(DynamicType.Unloaded<T> result, Collection<Class<?>> dependencies) {
            return dependencies.isEmpty() ? GeneratorResult.of(result) : new GeneratorResult<T>(result, ImmutableSet.copyOf(dependencies));
        }

         @NonNull DynamicType.Unloaded<T> getResult() {
            return this.result;
        }

        @NonNull ImmutableSet<Class<?>> getDependencies() {
            return this.dependecies;
        }
    }

    public static interface ClassGenerator<T> {
        public GeneratorResult<T> generateClass(CodecClassLoader var1, String var2, Class<?> var3);

        default public Class<T> customizeLoading(@NonNull Supplier<Class<T>> loader) {
            return (Class)loader.get();
        }
    }
}

