/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.loader;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.loader.CodecClassLoader;
import org.opendaylight.mdsal.binding.dom.codec.loader.RootCodecClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LeafCodecClassLoader
extends CodecClassLoader {
    private static final Logger LOG;
    private final @NonNull RootCodecClassLoader root;
    private final @NonNull ClassLoader target;
    private static final AtomicReferenceFieldUpdater<LeafCodecClassLoader, ImmutableSet> DEPENDENCIES_UPDATER;
    private volatile ImmutableSet<LeafCodecClassLoader> dependencies = ImmutableSet.of();

    LeafCodecClassLoader(RootCodecClassLoader root, ClassLoader target) {
        super(root);
        this.root = Objects.requireNonNull(root);
        this.target = Objects.requireNonNull(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return this.target.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            LOG.trace("Class {} not found in target, looking through dependencies", (Object)name);
            for (LeafCodecClassLoader loader : this.dependencies) {
                Object object = loader.getClassLoadingLock(name);
                synchronized (object) {
                    Class<?> loaded = loader.findLoadedClass(name);
                    if (loaded != null) {
                        LOG.trace("Class {} found in dependency {}", (Object)name, (Object)loader);
                        return loaded;
                    }
                }
            }
            throw e;
        }
    }

    @Override
    CodecClassLoader findClassLoader(Class<?> bindingClass) {
        ClassLoader bindingTarget = bindingClass.getClassLoader();
        return this.target.equals(bindingTarget) ? this : this.root.findClassLoader(bindingClass);
    }

    @Override
    void appendLoaders(Set<LeafCodecClassLoader> newLoaders) {
        ArrayList<LeafCodecClassLoader> builder;
        ImmutableSet updated;
        ImmutableSet<LeafCodecClassLoader> local;
        do {
            local = this.dependencies;
            builder = new ArrayList<LeafCodecClassLoader>(local.size() + newLoaders.size());
            builder.addAll((Collection<LeafCodecClassLoader>)local);
            builder.addAll(newLoaders);
        } while (!local.equals((Object)(updated = ImmutableSet.copyOf(builder))) && !DEPENDENCIES_UPDATER.compareAndSet(this, local, updated));
    }

    static {
        Verify.verify((boolean)LeafCodecClassLoader.registerAsParallelCapable());
        LOG = LoggerFactory.getLogger(LeafCodecClassLoader.class);
        DEPENDENCIES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(LeafCodecClassLoader.class, ImmutableSet.class, "dependencies");
    }
}

