/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.loader;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.security.AccessController;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.opendaylight.mdsal.binding.dom.codec.loader.CodecClassLoader;
import org.opendaylight.mdsal.binding.dom.codec.loader.LeafCodecClassLoader;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RootCodecClassLoader
extends CodecClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(RootCodecClassLoader.class);
    private static final ClassLoader LOADER = (ClassLoader)Verify.verifyNotNull((Object)RootCodecClassLoader.class.getClassLoader());
    private static final AtomicReferenceFieldUpdater<RootCodecClassLoader, ImmutableMap> LOADERS_UPDATER;
    private volatile ImmutableMap<ClassLoader, CodecClassLoader> loaders = ImmutableMap.of();

    RootCodecClassLoader() {
        super(LOADER);
    }

    @Override
    CodecClassLoader findClassLoader(Class<?> bindingClass) {
        CodecClassLoader recheck;
        CodecClassLoader found;
        ClassLoader target = bindingClass.getClassLoader();
        if (target == null) {
            return this;
        }
        ImmutableMap<ClassLoader, CodecClassLoader> local = this.loaders;
        CodecClassLoader known = (CodecClassLoader)local.get((Object)target);
        if (known != null) {
            return known;
        }
        if (!this.isOurClass(bindingClass)) {
            RootCodecClassLoader.verifyStaticLinkage(target);
            found = AccessController.doPrivileged(() -> new LeafCodecClassLoader(this, target));
        } else {
            found = this;
        }
        do {
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)(local.size() + 1));
            builder.putAll(local);
            builder.put((Object)target, (Object)found);
            if (!LOADERS_UPDATER.compareAndSet(this, local, builder.build())) continue;
            return found;
        } while ((recheck = (CodecClassLoader)(local = this.loaders).get((Object)target)) == null);
        return recheck;
    }

    @Override
    void appendLoaders(Set<LeafCodecClassLoader> newLoaders) {
        throw new IllegalStateException("Attempted to extend root loader with " + newLoaders);
    }

    private boolean isOurClass(Class<?> bindingClass) {
        Class<?> ourClass;
        try {
            ourClass = this.loadClass(bindingClass.getName(), false);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Failed to load {}", bindingClass, (Object)e);
            return false;
        }
        return bindingClass.equals(ourClass);
    }

    private static void verifyStaticLinkage(ClassLoader candidate) {
        Class<?> targetClazz;
        try {
            targetClazz = candidate.loadClass(DataContainer.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("ClassLoader " + candidate + " cannot load " + DataContainer.class, e);
        }
        Verify.verify((boolean)DataContainer.class.equals(targetClazz), (String)"Class mismatch on DataContainer. Ours is from %s, target %s has %s from %s", (Object)DataContainer.class.getClassLoader(), (Object)candidate, targetClazz, (Object)targetClazz.getClassLoader());
    }

    static {
        Verify.verify((boolean)RootCodecClassLoader.registerAsParallelCapable());
        LOADERS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(RootCodecClassLoader.class, ImmutableMap.class, "loaders");
    }
}

