/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.eos.common.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum EntityOwnershipChangeState {
    LOCAL_OWNERSHIP_GRANTED(false, true, true),
    LOCAL_OWNERSHIP_LOST_NEW_OWNER(true, false, true),
    LOCAL_OWNERSHIP_LOST_NO_OWNER(true, false, false),
    LOCAL_OWNERSHIP_RETAINED_WITH_NO_CHANGE(true, true, true),
    REMOTE_OWNERSHIP_CHANGED(false, false, true),
    REMOTE_OWNERSHIP_LOST_NO_OWNER(false, false, false);

    private static final Map<Key, EntityOwnershipChangeState> BY_KEY;
    private final boolean wasOwner;
    private final boolean isOwner;
    private final boolean hasOwner;

    private EntityOwnershipChangeState(boolean wasOwner, boolean isOwner, boolean hasOwner) {
        this.wasOwner = wasOwner;
        this.isOwner = isOwner;
        this.hasOwner = hasOwner;
    }

    public boolean wasOwner() {
        return this.wasOwner;
    }

    public boolean isOwner() {
        return this.isOwner;
    }

    public boolean hasOwner() {
        return this.hasOwner;
    }

    public String toString() {
        return this.name() + " [wasOwner=" + this.wasOwner + ", isOwner=" + this.isOwner + ", hasOwner=" + this.hasOwner + "]";
    }

    public static EntityOwnershipChangeState from(boolean wasOwner, boolean isOwner, boolean hasOwner) {
        EntityOwnershipChangeState state = BY_KEY.get(new Key(wasOwner, isOwner, hasOwner));
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (String)"Invalid combination of wasOwner: %s, isOwner: %s, hasOwner: %s", (Object)wasOwner, (Object)isOwner, (Object)hasOwner);
        return state;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EntityOwnershipChangeState e : EntityOwnershipChangeState.values()) {
            builder.put((Object)new Key(e.wasOwner, e.isOwner, e.hasOwner), (Object)e);
        }
        BY_KEY = builder.build();
    }

    private static final class Key {
        private final boolean wasOwner;
        private final boolean isOwner;
        private final boolean hasOwner;

        Key(boolean wasOwner, boolean isOwner, boolean hasOwner) {
            this.wasOwner = wasOwner;
            this.isOwner = isOwner;
            this.hasOwner = hasOwner;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.hasOwner ? 1231 : 1237);
            result = 31 * result + (this.isOwner ? 1231 : 1237);
            result = 31 * result + (this.wasOwner ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return this.hasOwner == other.hasOwner && this.isOwner == other.isOwner && this.wasOwner == other.wasOwner;
        }
    }
}

