/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FluentFuture;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.AbstractIdentifiable;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactoryConfiguration;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaResolutionException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SemVerSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.StatementParserMode;
import org.opendaylight.yangtools.yang.parser.api.YangParser;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.repo.DependencyResolver;
import org.opendaylight.yangtools.yang.parser.repo.RevisionDependencyResolver;
import org.opendaylight.yangtools.yang.parser.repo.SemVerDependencyResolver;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangModelDependencyInfo;
import org.opendaylight.yangtools.yang.parser.spi.meta.ReactorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AssembleSources
implements AsyncFunction<List<IRSchemaSource>, EffectiveModelContext> {
    private static final Logger LOG = LoggerFactory.getLogger(AssembleSources.class);
    private final @NonNull Function<IRSchemaSource, SourceIdentifier> getIdentifier;
    private final @NonNull SchemaContextFactoryConfiguration config;
    private final @NonNull YangParserFactory parserFactory;

    AssembleSources(@NonNull YangParserFactory parserFactory, @NonNull SchemaContextFactoryConfiguration config) {
        this.parserFactory = parserFactory;
        this.config = config;
        switch (config.getStatementParserMode()) {
            case SEMVER_MODE: {
                this.getIdentifier = AssembleSources::getSemVerIdentifier;
                break;
            }
            default: {
                this.getIdentifier = AbstractIdentifiable::getIdentifier;
            }
        }
    }

    public FluentFuture<EffectiveModelContext> apply(List<IRSchemaSource> sources) throws SchemaResolutionException, ReactorException {
        EffectiveModelContext schemaContext;
        DependencyResolver res;
        ImmutableMap srcs = Maps.uniqueIndex(sources, this.getIdentifier);
        Map deps = Maps.transformValues((Map)srcs, YangModelDependencyInfo::forIR);
        LOG.debug("Resolving dependency reactor {}", (Object)deps);
        StatementParserMode statementParserMode = this.config.getStatementParserMode();
        DependencyResolver dependencyResolver = res = statementParserMode == StatementParserMode.SEMVER_MODE ? SemVerDependencyResolver.create(deps) : RevisionDependencyResolver.create(deps);
        if (!res.getUnresolvedSources().isEmpty()) {
            LOG.debug("Omitting models {} due to unsatisfied imports {}", res.getUnresolvedSources(), res.getUnsatisfiedImports());
            throw new SchemaResolutionException("Failed to resolve required models", res.getResolvedSources(), res.getUnsatisfiedImports());
        }
        YangParser parser = this.parserFactory.createParser(res.parserConfig());
        this.config.getSupportedFeatures().ifPresent(arg_0 -> ((YangParser)parser).setSupportedFeatures(arg_0));
        this.config.getModulesDeviatedByModules().ifPresent(arg_0 -> ((YangParser)parser).setModulesWithSupportedDeviations(arg_0));
        for (Map.Entry entry : srcs.entrySet()) {
            try {
                parser.addSource((SchemaSourceRepresentation)entry.getValue());
            }
            catch (IOException | YangSyntaxErrorException e) {
                throw new SchemaResolutionException("Failed to add source " + entry.getKey(), e);
            }
        }
        try {
            schemaContext = parser.buildEffectiveModel();
        }
        catch (YangParserException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ReactorException) {
                throw new SchemaResolutionException("Failed to resolve required models", ((ReactorException)cause).getSourceIdentifier(), (Throwable)e);
            }
            throw new SchemaResolutionException("Failed to resolve required models", (Throwable)e);
        }
        return FluentFutures.immediateFluentFuture((Object)schemaContext);
    }

    private static SemVerSourceIdentifier getSemVerIdentifier(IRSchemaSource source) {
        SourceIdentifier identifier = (SourceIdentifier)source.getIdentifier();
        SemVer semver = YangModelDependencyInfo.findSemanticVersion((IRStatement)source.getRootStatement(), (SourceIdentifier)identifier);
        if (identifier instanceof SemVerSourceIdentifier && semver == null) {
            return (SemVerSourceIdentifier)identifier;
        }
        return SemVerSourceIdentifier.create((String)identifier.getName(), (Optional)identifier.getRevision(), (SemVer)semver);
    }
}

