/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRSchemaSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressModernizer
final class SourceIdMismatchDetector
implements Function<List<IRSchemaSource>, List<IRSchemaSource>> {
    private static final Logger LOG = LoggerFactory.getLogger(SourceIdMismatchDetector.class);
    private final Set<SourceIdentifier> sourceIdentifiers;

    SourceIdMismatchDetector(Set<SourceIdentifier> sourceIdentifiers) {
        this.sourceIdentifiers = Objects.requireNonNull(sourceIdentifiers);
    }

    public List<IRSchemaSource> apply(List<IRSchemaSource> input) {
        Iterator<SourceIdentifier> srcIt = this.sourceIdentifiers.iterator();
        Iterator<IRSchemaSource> it = input.iterator();
        LinkedHashMap<SourceIdentifier, IRSchemaSource> filtered = new LinkedHashMap<SourceIdentifier, IRSchemaSource>();
        while (it.hasNext()) {
            IRSchemaSource prev;
            SourceIdentifier expectedSId;
            IRSchemaSource irSchemaSource = it.next();
            SourceIdentifier realSId = (SourceIdentifier)irSchemaSource.getIdentifier();
            if (srcIt.hasNext() && !(expectedSId = srcIt.next()).equals(realSId)) {
                LOG.warn("Source identifier mismatch for module \"{}\", requested as {} but actually is {}. Using actual id", new Object[]{expectedSId.getName(), expectedSId, realSId});
            }
            if ((prev = filtered.put(realSId, irSchemaSource)) == null) continue;
            LOG.warn("Duplicate source for module {} detected in reactor", (Object)realSId);
        }
        return ImmutableList.copyOf(filtered.values());
    }
}

