/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.codec;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.TypeAwareCodec;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnknownTypeDefinition;
import org.opendaylight.yangtools.yang.model.spi.AbstractEffectiveModelContextProvider;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCodecFactory<T extends TypeAwareCodec<?, ?, ?>>
extends AbstractEffectiveModelContextProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCodecFactory.class);
    private final @NonNull CodecCache<T> cache;

    protected AbstractCodecFactory(@NonNull EffectiveModelContext schemaContext, @NonNull CodecCache<T> cache) {
        super(schemaContext);
        this.cache = Objects.requireNonNull(cache);
    }

    public final <S extends TypeAware & SchemaNode> @NonNull T codecFor(S schema, LeafrefResolver resolver) {
        TypeDefinition type = schema.getType();
        TypeAwareCodec ret = (TypeAwareCodec)this.cache.lookupSimple(type);
        if (ret != null) {
            LOG.trace("Type {} hit simple {}", (Object)type, (Object)ret);
            return (T)ret;
        }
        ret = (TypeAwareCodec)this.cache.lookupComplex(schema);
        if (ret != null) {
            LOG.trace("Type {} hit complex {}", (Object)type, (Object)ret);
            return (T)ret;
        }
        ret = this.getSimpleCodecFor(type);
        if (ret != null) {
            LOG.trace("Type {} miss simple {}", (Object)type, (Object)ret);
            return (T)ret;
        }
        ret = this.createComplexCodecFor(schema, type, resolver);
        LOG.trace("Type {} miss complex {}", (Object)type, (Object)ret);
        return (T)this.cache.getComplex(schema, ret);
    }

    protected abstract T binaryCodec(BinaryTypeDefinition var1);

    protected abstract T booleanCodec(BooleanTypeDefinition var1);

    protected abstract T bitsCodec(BitsTypeDefinition var1);

    protected abstract T emptyCodec(EmptyTypeDefinition var1);

    protected abstract T enumCodec(EnumTypeDefinition var1);

    protected abstract T identityRefCodec(IdentityrefTypeDefinition var1, QNameModule var2);

    protected abstract T instanceIdentifierCodec(InstanceIdentifierTypeDefinition var1);

    protected abstract T int8Codec(Int8TypeDefinition var1);

    protected abstract T int16Codec(Int16TypeDefinition var1);

    protected abstract T int32Codec(Int32TypeDefinition var1);

    protected abstract T int64Codec(Int64TypeDefinition var1);

    protected abstract T decimalCodec(DecimalTypeDefinition var1);

    protected abstract T stringCodec(StringTypeDefinition var1);

    protected abstract T uint8Codec(Uint8TypeDefinition var1);

    protected abstract T uint16Codec(Uint16TypeDefinition var1);

    protected abstract T uint32Codec(Uint32TypeDefinition var1);

    protected abstract T uint64Codec(Uint64TypeDefinition var1);

    protected abstract T unionCodec(UnionTypeDefinition var1, List<T> var2);

    protected abstract T unknownCodec(UnknownTypeDefinition var1);

    private T getSimpleCodecFor(TypeDefinition<?> type) {
        T ret;
        if (type instanceof EmptyTypeDefinition) {
            return this.emptyCodec((EmptyTypeDefinition)type);
        }
        if (type instanceof UnknownTypeDefinition) {
            return this.unknownCodec((UnknownTypeDefinition)type);
        }
        if (type instanceof StringTypeDefinition) {
            ret = this.stringCodec((StringTypeDefinition)type);
        } else if (type instanceof Int8TypeDefinition) {
            ret = this.int8Codec((Int8TypeDefinition)type);
        } else if (type instanceof Int16TypeDefinition) {
            ret = this.int16Codec((Int16TypeDefinition)type);
        } else if (type instanceof Int32TypeDefinition) {
            ret = this.int32Codec((Int32TypeDefinition)type);
        } else if (type instanceof Int64TypeDefinition) {
            ret = this.int64Codec((Int64TypeDefinition)type);
        } else if (type instanceof Uint8TypeDefinition) {
            ret = this.uint8Codec((Uint8TypeDefinition)type);
        } else if (type instanceof Uint16TypeDefinition) {
            ret = this.uint16Codec((Uint16TypeDefinition)type);
        } else if (type instanceof Uint32TypeDefinition) {
            ret = this.uint32Codec((Uint32TypeDefinition)type);
        } else if (type instanceof Uint64TypeDefinition) {
            ret = this.uint64Codec((Uint64TypeDefinition)type);
        } else if (type instanceof BooleanTypeDefinition) {
            ret = this.booleanCodec((BooleanTypeDefinition)type);
        } else if (type instanceof DecimalTypeDefinition) {
            ret = this.decimalCodec((DecimalTypeDefinition)type);
        } else if (type instanceof EnumTypeDefinition) {
            ret = this.enumCodec((EnumTypeDefinition)type);
        } else if (type instanceof BitsTypeDefinition) {
            ret = this.bitsCodec((BitsTypeDefinition)type);
        } else if (type instanceof UnionTypeDefinition) {
            UnionTypeDefinition union = (UnionTypeDefinition)type;
            if (!AbstractCodecFactory.isSimpleUnion(union)) {
                return null;
            }
            ret = this.createSimpleUnion(union);
        } else if (type instanceof BinaryTypeDefinition) {
            ret = this.binaryCodec((BinaryTypeDefinition)type);
        } else {
            if (type instanceof InstanceIdentifierTypeDefinition) {
                return this.instanceIdentifierCodec((InstanceIdentifierTypeDefinition)type);
            }
            return null;
        }
        return (T)this.cache.getSimple(type, (TypeAwareCodec)Verify.verifyNotNull(ret));
    }

    private static boolean isSimpleUnion(UnionTypeDefinition union) {
        for (TypeDefinition t : union.getTypes()) {
            if (!(t instanceof IdentityrefTypeDefinition) && !(t instanceof LeafrefTypeDefinition) && (!(t instanceof UnionTypeDefinition) || AbstractCodecFactory.isSimpleUnion((UnionTypeDefinition)t))) continue;
            LOG.debug("Type {} has non-simple subtype", (Object)t);
            return false;
        }
        LOG.debug("Type {} is simple", (Object)union);
        return true;
    }

    private T createComplexCodecFor(SchemaNode schema, TypeDefinition<?> type, LeafrefResolver resolver) {
        if (type instanceof UnionTypeDefinition) {
            return this.createComplexUnion(schema, (UnionTypeDefinition)type, resolver);
        }
        if (type instanceof LeafrefTypeDefinition) {
            TypeDefinition target = resolver.resolveLeafref((LeafrefTypeDefinition)type);
            T ret = this.getSimpleCodecFor(target);
            return ret != null ? ret : this.createComplexCodecFor(schema, target, resolver);
        }
        if (type instanceof IdentityrefTypeDefinition) {
            return this.identityRefCodec((IdentityrefTypeDefinition)type, schema.getQName().getModule());
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    private T createSimpleUnion(UnionTypeDefinition union) {
        List types = union.getTypes();
        ArrayList<TypeAwareCodec> codecs = new ArrayList<TypeAwareCodec>(types.size());
        for (TypeDefinition type : types) {
            TypeAwareCodec codec = (TypeAwareCodec)this.cache.lookupSimple(type);
            if (codec == null) {
                codec = (TypeAwareCodec)Verify.verifyNotNull(this.getSimpleCodecFor(type), (String)"Type %s did not resolve to a simple codec", (Object[])new Object[]{type});
            }
            codecs.add(codec);
        }
        return (T)this.unionCodec(union, codecs);
    }

    private T createComplexUnion(SchemaNode schema, UnionTypeDefinition union, LeafrefResolver resolver) {
        List types = union.getTypes();
        ArrayList<TypeAwareCodec> codecs = new ArrayList<TypeAwareCodec>(types.size());
        for (TypeDefinition type : types) {
            TypeAwareCodec codec = (TypeAwareCodec)this.cache.lookupSimple(type);
            if (codec == null && (codec = this.getSimpleCodecFor(type)) == null) {
                codec = this.createComplexCodecFor(schema, type, resolver);
            }
            codecs.add((TypeAwareCodec)Verify.verifyNotNull((Object)codec, (String)"Type %s has no codec", (Object[])new Object[]{schema, type}));
        }
        return (T)this.unionCodec(union, codecs);
    }
}

