/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceProvider;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceRegistration;
import org.opendaylight.mdsal.singleton.common.api.ServiceGroupIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlappingSingletonService
implements ClusterSingletonService {
    private static final Logger LOG = LoggerFactory.getLogger(FlappingSingletonService.class);
    private static final ServiceGroupIdentifier SERVICE_GROUP_IDENTIFIER = ServiceGroupIdentifier.create((String)"flapping-singleton-service");
    private final ClusterSingletonServiceProvider singletonServiceProvider;
    private final AtomicBoolean active = new AtomicBoolean(true);
    private final AtomicLong flapCount = new AtomicLong();
    private volatile ClusterSingletonServiceRegistration registration;

    public FlappingSingletonService(ClusterSingletonServiceProvider singletonServiceProvider) {
        LOG.debug("Registering flapping-singleton-service.");
        this.singletonServiceProvider = singletonServiceProvider;
        this.registration = singletonServiceProvider.registerClusterSingletonService((ClusterSingletonService)this);
    }

    public void instantiateServiceInstance() {
        LOG.debug("Instantiating flapping-singleton-service.");
        try {
            this.registration.close();
            this.registration = null;
        }
        catch (Exception e) {
            LOG.warn("There was a problem closing flapping singleton service.", (Throwable)e);
            this.setInactive();
            long count = this.flapCount.get();
            this.flapCount.compareAndSet(count, -count);
        }
    }

    public ListenableFuture<Void> closeServiceInstance() {
        LOG.debug("Closing flapping-singleton-service, flapCount: {}", (Object)this.flapCount);
        this.flapCount.incrementAndGet();
        if (this.active.get()) {
            LOG.debug("Running re-registration");
            try {
                this.registration = this.singletonServiceProvider.registerClusterSingletonService((ClusterSingletonService)this);
            }
            catch (RuntimeException e) {
                LOG.warn("There was a problem re-registering flapping singleton service.", (Throwable)e);
                this.setInactive();
                long count = this.flapCount.get();
                this.flapCount.compareAndSet(count, -count - 1L);
            }
        }
        return Futures.immediateFuture(null);
    }

    public ServiceGroupIdentifier getIdentifier() {
        return SERVICE_GROUP_IDENTIFIER;
    }

    public long setInactive() {
        LOG.debug("Setting flapping-singleton-service to inactive, flap-count: {}", (Object)this.flapCount);
        this.active.set(false);
        return this.flapCount.get();
    }
}

