/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.AbstractBuffer;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.BufferAllocator;
import io.atomix.utils.concurrent.ReferencePool;

public abstract class PooledAllocator
implements BufferAllocator {
    private final ReferencePool<AbstractBuffer> pool;

    protected PooledAllocator(ReferencePool<AbstractBuffer> pool) {
        this.pool = pool;
    }

    protected abstract int maxCapacity();

    @Override
    public Buffer allocate() {
        return this.allocate(4096, this.maxCapacity());
    }

    @Override
    public Buffer allocate(int capacity) {
        return this.allocate(capacity, this.maxCapacity());
    }

    @Override
    public Buffer allocate(int initialCapacity, int maxCapacity) {
        return this.pool.acquire().reset(0, initialCapacity, maxCapacity).clear();
    }
}

