/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.serializer.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class ImmutableMapSerializer
extends Serializer<ImmutableMap<?, ?>> {
    public ImmutableMapSerializer() {
        super(false, true);
    }

    @Override
    public void write(Kryo kryo, Output output, ImmutableMap<?, ?> object) {
        output.writeInt(object.size());
        for (Map.Entry e : object.entrySet()) {
            kryo.writeClassAndObject(output, e.getKey());
            kryo.writeClassAndObject(output, e.getValue());
        }
    }

    @Override
    public ImmutableMap<?, ?> read(Kryo kryo, Input input, Class<ImmutableMap<?, ?>> type) {
        int size = input.readInt();
        switch (size) {
            case 0: {
                return ImmutableMap.of();
            }
            case 1: {
                return ImmutableMap.of((Object)kryo.readClassAndObject(input), (Object)kryo.readClassAndObject(input));
            }
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < size; ++i) {
            builder.put(kryo.readClassAndObject(input), kryo.readClassAndObject(input));
        }
        return builder.build();
    }
}

