/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCursorAware {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCursorAware.class);
    private static final AtomicReferenceFieldUpdater<AbstractCursorAware, AbstractCursor> CURSOR_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractCursorAware.class, AbstractCursor.class, "cursor");
    private volatile AbstractCursor<?> cursor = null;

    AbstractCursorAware() {
    }

    protected <T extends AbstractCursor<?>> T openCursor(T cursorToOpen) {
        boolean success = CURSOR_UPDATER.compareAndSet(this, null, cursorToOpen);
        Preconditions.checkState((boolean)success, (String)"Modification %s has cursor attached at path %s", (Object)this, (Object)this.cursor.getRootPath());
        return cursorToOpen;
    }

    final void closeCursor(AbstractCursor<?> cursorToClose) {
        boolean success = CURSOR_UPDATER.compareAndSet(this, cursorToClose, null);
        if (!success) {
            LOG.warn("Attempted to close cursor {} while {} is open", cursorToClose, this.cursor);
        }
    }
}

