/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.tree.impl.UniqueValues;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class UniqueValidator<T>
implements Immutable {
    private static final Logger LOG = LoggerFactory.getLogger(UniqueValidator.class);
    final @NonNull T descendants;

    UniqueValidator(T descendants) {
        this.descendants = Objects.requireNonNull(descendants);
    }

    static UniqueValidator<?> of(List<List<YangInstanceIdentifier.NodeIdentifier>> descendants) {
        return descendants.size() == 1 ? new One(descendants.get(0)) : new Many(descendants);
    }

    abstract @Nullable Object extractValues(Map<List<YangInstanceIdentifier.NodeIdentifier>, Object> var1, DataContainerNode var2);

    abstract Map<// Could not load outer class - annotation placement on inner may be incorrect
    SchemaNodeIdentifier.Descendant, @Nullable Object> indexValues(Object var1);

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("paths", this.descendants).toString();
    }

    private static Object encodePath(List<YangInstanceIdentifier.NodeIdentifier> path) {
        return path.size() == 1 ? path.get(0) : ImmutableList.copyOf(path);
    }

    private static @NonNull ImmutableList<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifier> decodePath(Object obj) {
        return obj instanceof YangInstanceIdentifier.NodeIdentifier ? ImmutableList.of((Object)((YangInstanceIdentifier.NodeIdentifier)obj)) : (ImmutableList)obj;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SchemaNodeIdentifier.Descendant decodeDescendant(Object obj) {
        return SchemaNodeIdentifier.Descendant.of((Collection)Collections2.transform(UniqueValidator.decodePath(obj), rec$ -> ((YangInstanceIdentifier.NodeIdentifier)rec$).getNodeType()));
    }

    private static @Nullable Object extractValue(Map<List<YangInstanceIdentifier.NodeIdentifier>, Object> valueCache, DataContainerNode data, List<YangInstanceIdentifier.NodeIdentifier> path) {
        return valueCache.computeIfAbsent(path, key -> UniqueValidator.extractValue(data, key));
    }

    private static @Nullable Object extractValue(DataContainerNode data, List<YangInstanceIdentifier.NodeIdentifier> path) {
        DataContainerNode current = data;
        Iterator<YangInstanceIdentifier.NodeIdentifier> it = path.iterator();
        YangInstanceIdentifier.NodeIdentifier step;
        DataContainerChild next;
        while ((next = (DataContainerChild)current.childByArg((YangInstanceIdentifier.PathArgument)(step = it.next()))) != null) {
            if (!it.hasNext()) {
                Preconditions.checkState((boolean)(next instanceof LeafNode), (String)"Unexpected node %s at %s", (Object)next, path);
                Object value = next.body();
                LOG.trace("Resolved {} to value {}", path, value);
                return value;
            }
            Preconditions.checkState((boolean)(next instanceof DataContainerNode), (String)"Unexpected node %s in %s", (Object)next, path);
            current = (DataContainerNode)next;
        }
        return null;
    }

    private static final class Many
    extends UniqueValidator<Set<Object>> {
        Many(List<List<YangInstanceIdentifier.NodeIdentifier>> descendantPaths) {
            super((Set)descendantPaths.stream().map(x$0 -> UniqueValidator.encodePath(x$0)).collect(ImmutableSet.toImmutableSet()));
        }

        @Override
        UniqueValues extractValues(Map<List<YangInstanceIdentifier.NodeIdentifier>, Object> valueCache, DataContainerNode data) {
            return ((Set)this.descendants).stream().map(obj -> UniqueValidator.extractValue(valueCache, data, UniqueValidator.decodePath(obj))).collect(UniqueValues.COLLECTOR);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        Map<// Could not load outer class - annotation placement on inner may be incorrect
        SchemaNodeIdentifier.Descendant, @Nullable Object> indexValues(Object values) {
            @Nullable HashMap index = Maps.newHashMapWithExpectedSize((int)((Set)this.descendants).size());
            Iterator<Object> it = ((UniqueValues)values).iterator();
            for (Object obj : (Set)this.descendants) {
                Verify.verify((index.put(UniqueValidator.decodeDescendant(obj), it.next()) == null ? 1 : 0) != 0);
            }
            return index;
        }
    }

    private static final class One
    extends UniqueValidator<Object> {
        One(List<YangInstanceIdentifier.NodeIdentifier> path) {
            super(UniqueValidator.encodePath(path));
        }

        @Override
        Object extractValues(Map<List<YangInstanceIdentifier.NodeIdentifier>, Object> valueCache, DataContainerNode data) {
            return UniqueValidator.extractValue(valueCache, data, UniqueValidator.decodePath(this.descendants));
        }

        @Override
        Map<// Could not load outer class - annotation placement on inner may be incorrect
        SchemaNodeIdentifier.Descendant, @Nullable Object> indexValues(Object values) {
            return Collections.singletonMap(UniqueValidator.decodeDescendant(this.descendants), values);
        }
    }
}

