/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.leafref;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefContext;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefContextBuilder;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefPathParserImpl;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefUtils;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefYangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class LeafRefContextTreeBuilder {
    private final List<LeafRefContext> leafRefs = new LinkedList<LeafRefContext>();
    private final EffectiveModelContext schemaContext;

    LeafRefContextTreeBuilder(EffectiveModelContext schemaContext) {
        this.schemaContext = schemaContext;
    }

    LeafRefContext buildLeafRefContextTree() throws LeafRefYangSyntaxErrorException {
        LeafRefContext childLeafRefContext;
        SchemaInferenceStack stack = SchemaInferenceStack.of((EffectiveModelContext)this.schemaContext);
        LeafRefContextBuilder rootBuilder = new LeafRefContextBuilder(SchemaContext.NAME, SchemaPath.ROOT, this.schemaContext);
        Collection modules = this.schemaContext.getModules();
        for (Module module : modules) {
            for (DataSchemaNode childNode : module.getChildNodes()) {
                stack.enterSchemaTree(childNode.getQName());
                childLeafRefContext = this.buildLeafRefContextReferencingTree(childNode, stack);
                stack.exit();
                if (!childLeafRefContext.hasReferencingChild() && !childLeafRefContext.isReferencing()) continue;
                rootBuilder.addReferencingChild(childLeafRefContext, childLeafRefContext.getNodeName());
            }
        }
        for (Module module : modules) {
            for (DataSchemaNode childNode : module.getChildNodes()) {
                stack.enterSchemaTree(childNode.getQName());
                childLeafRefContext = this.buildLeafRefContextReferencedByTree(childNode, module, stack);
                stack.exit();
                if (!childLeafRefContext.hasReferencedChild() && !childLeafRefContext.isReferenced()) continue;
                rootBuilder.addReferencedByChild(childLeafRefContext, childLeafRefContext.getNodeName());
            }
        }
        return rootBuilder.build();
    }

    private LeafRefContext buildLeafRefContextReferencingTree(DataSchemaNode node, SchemaInferenceStack stack) {
        TypedDataSchemaNode typedNode;
        TypeDefinition type;
        LeafRefContextBuilder currentLeafRefContextBuilder = new LeafRefContextBuilder(node.getQName(), stack.toSchemaPath(), this.schemaContext);
        if (node instanceof DataNodeContainer) {
            for (DataSchemaNode childNode : ((DataNodeContainer)node).getChildNodes()) {
                stack.enterSchemaTree(childNode.getQName());
                LeafRefContext childLeafRefContext = this.buildLeafRefContextReferencingTree(childNode, stack);
                stack.exit();
                if (!childLeafRefContext.hasReferencingChild() && !childLeafRefContext.isReferencing()) continue;
                currentLeafRefContextBuilder.addReferencingChild(childLeafRefContext, childLeafRefContext.getNodeName());
            }
        } else if (node instanceof ChoiceSchemaNode) {
            for (CaseSchemaNode caseNode : ((ChoiceSchemaNode)node).getCases()) {
                stack.enterSchemaTree(caseNode.getQName());
                LeafRefContext childLeafRefContext = this.buildLeafRefContextReferencingTree((DataSchemaNode)caseNode, stack);
                stack.exit();
                if (!childLeafRefContext.hasReferencingChild() && !childLeafRefContext.isReferencing()) continue;
                currentLeafRefContextBuilder.addReferencingChild(childLeafRefContext, childLeafRefContext.getNodeName());
            }
        } else if (node instanceof TypedDataSchemaNode && (type = (typedNode = (TypedDataSchemaNode)node).getType()) instanceof LeafrefTypeDefinition) {
            LeafrefTypeDefinition leafrefType = (LeafrefTypeDefinition)type;
            PathExpression path = leafrefType.getPathStatement();
            LeafRefPathParserImpl leafRefPathParser = new LeafRefPathParserImpl(leafrefType, typedNode);
            LeafRefPath leafRefPath = leafRefPathParser.parseLeafRefPath(path);
            currentLeafRefContextBuilder.setLeafRefTargetPathString(path.getOriginalString());
            currentLeafRefContextBuilder.setReferencing(true);
            currentLeafRefContextBuilder.setLeafRefTargetPath(leafRefPath);
            LeafRefContext currentLeafRefContext = currentLeafRefContextBuilder.build();
            this.leafRefs.add(currentLeafRefContext);
            return currentLeafRefContext;
        }
        return currentLeafRefContextBuilder.build();
    }

    private LeafRefContext buildLeafRefContextReferencedByTree(DataSchemaNode node, Module currentModule, SchemaInferenceStack stack) {
        LeafRefContextBuilder currentLeafRefContextBuilder;
        block4: {
            List<LeafRefContext> foundLeafRefs;
            block5: {
                block3: {
                    currentLeafRefContextBuilder = new LeafRefContextBuilder(node.getQName(), stack.toSchemaPath(), this.schemaContext);
                    if (!(node instanceof DataNodeContainer)) break block3;
                    for (DataSchemaNode childNode : ((DataNodeContainer)node).getChildNodes()) {
                        stack.enterSchemaTree(childNode.getQName());
                        LeafRefContext childLeafRefContext = this.buildLeafRefContextReferencedByTree(childNode, currentModule, stack);
                        stack.exit();
                        if (!childLeafRefContext.hasReferencedChild() && !childLeafRefContext.isReferenced()) continue;
                        currentLeafRefContextBuilder.addReferencedByChild(childLeafRefContext, childLeafRefContext.getNodeName());
                    }
                    break block4;
                }
                if (!(node instanceof ChoiceSchemaNode)) break block5;
                for (CaseSchemaNode caseNode : ((ChoiceSchemaNode)node).getCases()) {
                    stack.enterSchemaTree(caseNode.getQName());
                    LeafRefContext childLeafRefContext = this.buildLeafRefContextReferencedByTree((DataSchemaNode)caseNode, currentModule, stack);
                    stack.exit();
                    if (!childLeafRefContext.hasReferencedChild() && !childLeafRefContext.isReferenced()) continue;
                    currentLeafRefContextBuilder.addReferencedByChild(childLeafRefContext, childLeafRefContext.getNodeName());
                }
                break block4;
            }
            if (!(node instanceof LeafSchemaNode) && !(node instanceof LeafListSchemaNode) || (foundLeafRefs = this.getLeafRefsFor(currentModule, stack)).isEmpty()) break block4;
            currentLeafRefContextBuilder.setReferencedBy(true);
            for (LeafRefContext leafRef : foundLeafRefs) {
                currentLeafRefContextBuilder.addReferencedByLeafRefCtx(leafRef.getNodeName(), leafRef);
            }
        }
        return currentLeafRefContextBuilder.build();
    }

    private List<LeafRefContext> getLeafRefsFor(Module module, SchemaInferenceStack stack) {
        LeafRefPath nodeXPath = LeafRefUtils.schemaPathToLeafRefPath(stack.toSchemaPath(), module);
        LinkedList<LeafRefContext> foundLeafRefs = new LinkedList<LeafRefContext>();
        for (LeafRefContext leafref : this.leafRefs) {
            LeafRefPath leafRefTargetPath = leafref.getAbsoluteLeafRefTargetPath();
            if (!leafRefTargetPath.equals(nodeXPath)) continue;
            foundLeafRefs.add(leafref);
        }
        return foundLeafRefs;
    }
}

