/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.odlext.parser;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.IdentityNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

abstract class AbstractIdentityAwareStatementSupport<D extends DeclaredStatement<QName>, E extends EffectiveStatement<QName, D>>
extends AbstractStatementSupport<QName, D, E> {
    AbstractIdentityAwareStatementSupport(StatementDefinition publicDefinition, YangParserConfiguration config, SubstatementValidator validator) {
        super(publicDefinition, StatementSupport.StatementPolicy.exactReplica(), config, validator);
    }

    public final QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseNodeIdentifier(ctx, (String)value);
    }

    public void onStatementDefinitionDeclared(final StmtContext.Mutable<QName, D, E> stmt) {
        ModelActionBuilder action = stmt.newInferenceAction(ModelProcessingPhase.EFFECTIVE_MODEL);
        action.requiresCtx(stmt, IdentityNamespace.class, (Object)((QName)stmt.getArgument()), ModelProcessingPhase.EFFECTIVE_MODEL);
        action.apply(new ModelActionBuilder.InferenceAction(){

            public void apply(ModelActionBuilder.InferenceContext ctx) {
            }

            public void prerequisiteFailed(Collection<? extends ModelActionBuilder.Prerequisite<?>> failed) {
                throw new InferenceException((CommonStmtCtx)stmt, "Unable to resolve identity %s", new Object[]{stmt.argument()});
            }
        });
    }

    protected final E createEffective(EffectiveStmtCtx.Current<QName, D> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        QName qname = (QName)stmt.getArgument();
        StmtContext identityCtx = (StmtContext)Verify.verifyNotNull((Object)((StmtContext)stmt.getFromNamespace(IdentityNamespace.class, (Object)qname)), (String)"Failed to find identity %s", (Object[])new Object[]{qname});
        return this.createEffective(stmt.declared(), (IdentityEffectiveStatement)identityCtx.buildEffective(), substatements);
    }

    abstract @NonNull E createEffective(@NonNull D var1, @NonNull IdentityEffectiveStatement var2, ImmutableList<? extends EffectiveStatement<?, ?>> var3);
}

