/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.AbstractDeclaredEffectiveStatement;

abstract class AbstractKeyEffectiveStatement
extends AbstractDeclaredEffectiveStatement.Default<Set<QName>, KeyStatement>
implements KeyEffectiveStatement {
    AbstractKeyEffectiveStatement(KeyStatement declared) {
        super((DeclaredStatement)declared);
    }

    static abstract class Local
    extends AbstractKeyEffectiveStatement {
        Local(KeyStatement declared) {
            super(declared);
        }

        public final Set<QName> argument() {
            return (Set)((KeyStatement)this.getDeclared()).argument();
        }
    }

    static abstract class Foreign
    extends AbstractKeyEffectiveStatement {
        private final Object argument;

        Foreign(KeyStatement declared, Set<QName> argument) {
            super(declared);
            this.argument = Foreign.maskSet(argument);
        }

        public final Set<QName> argument() {
            return Foreign.unmaskSet(this.argument);
        }

        private static @NonNull Object maskSet(@NonNull Set<QName> set) {
            return set.size() == 1 ? set.iterator().next() : set;
        }

        private static @NonNull Set<QName> unmaskSet(@NonNull Object masked) {
            if (masked instanceof Set) {
                return (Set)masked;
            }
            Verify.verify((boolean)(masked instanceof QName), (String)"Unexpected argument %s", (Object)masked);
            return ImmutableSet.of((Object)((QName)masked));
        }
    }
}

