/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.ri.type.AbstractRangeRestrictedBaseType;
import org.opendaylight.yangtools.yang.model.ri.type.ResolvedRangeConstraint;

final class BaseDecimalType
extends AbstractRangeRestrictedBaseType<DecimalTypeDefinition, Decimal64>
implements DecimalTypeDefinition {
    private static final ConstraintMetaDefinition BUILTIN_CONSTRAINT = new ConstraintMetaDefinition(){

        public Optional<String> getReference() {
            return Optional.of("https://tools.ietf.org/html/rfc6020#section-9.3.4");
        }

        public Optional<String> getDescription() {
            return Optional.empty();
        }

        public Optional<String> getErrorMessage() {
            return Optional.empty();
        }

        public Optional<String> getErrorAppTag() {
            return Optional.empty();
        }
    };
    private static final ImmutableList<RangeConstraint<Decimal64>> IMPLICIT_RANGE_STATEMENTS;
    private final int fractionDigits;

    static RangeConstraint<Decimal64> constraintsForDigits(int fractionDigits) {
        return (RangeConstraint)Verify.verifyNotNull((Object)((RangeConstraint)IMPLICIT_RANGE_STATEMENTS.get(fractionDigits - 1)));
    }

    BaseDecimalType(QName qname, Collection<? extends UnknownSchemaNode> unknownSchemaNodes, int fractionDigits, RangeConstraint<Decimal64> rangeConstraint) {
        super(qname, unknownSchemaNodes, rangeConstraint);
        this.fractionDigits = fractionDigits;
    }

    public int getFractionDigits() {
        return this.fractionDigits;
    }

    @Override
    public int hashCode() {
        return DecimalTypeDefinition.hashCode((DecimalTypeDefinition)this);
    }

    @Override
    public boolean equals(Object obj) {
        return DecimalTypeDefinition.equals((DecimalTypeDefinition)this, (Object)obj);
    }

    @Override
    public String toString() {
        return DecimalTypeDefinition.toString((DecimalTypeDefinition)this);
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)18);
        for (int scale = 1; scale <= 18; ++scale) {
            builder.add(new ResolvedRangeConstraint(BUILTIN_CONSTRAINT, ImmutableRangeSet.of((Range)Range.closed((Comparable)Decimal64.minValueIn((int)scale), (Comparable)Decimal64.maxValueIn((int)scale)))));
        }
        IMPLICIT_RANGE_STATEMENTS = builder.build();
    }
}

