/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.base.Preconditions;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.type.BaseDecimalType;
import org.opendaylight.yangtools.yang.model.ri.type.RangeRestrictedTypeBuilder;

public final class DecimalTypeBuilder
extends RangeRestrictedTypeBuilder<DecimalTypeDefinition, Decimal64> {
    private Integer fractionDigits;

    DecimalTypeBuilder(QName qname) {
        super(null, qname);
    }

    public DecimalTypeBuilder setFractionDigits(int fractionDigits) {
        Preconditions.checkState((this.fractionDigits == null ? 1 : 0) != 0, (String)"Fraction digits already defined to %s", (Object)this.fractionDigits);
        this.fractionDigits = fractionDigits;
        return this;
    }

    @Override
    DecimalTypeDefinition buildType() {
        Preconditions.checkState((this.fractionDigits != null ? 1 : 0) != 0, (Object)"Fraction digits not defined");
        return new BaseDecimalType(this.getQName(), this.getUnknownSchemaNodes(), this.fractionDigits, this.calculateRangeConstraint(BaseDecimalType.constraintsForDigits(this.fractionDigits)));
    }
}

