/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementFactory;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ImplicitStmtCtx;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.InferredStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.OriginalStmtCtx;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ReactorStmtCtx;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementMap;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SubstatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.UndeclaredStmtCtx;

abstract class AbstractResumedStatement<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends OriginalStmtCtx<A, D, E>
implements StatementWriter.ResumedStatement {
    private final String rawArgument;
    private StatementMap substatements = StatementMap.empty();
    private @Nullable D declaredInstance;

    AbstractResumedStatement(AbstractResumedStatement<A, D, E> original) {
        super(original);
        this.rawArgument = original.rawArgument;
        this.substatements = original.substatements;
        this.declaredInstance = original.declaredInstance;
    }

    AbstractResumedStatement(StatementDefinitionContext<A, D, E> def, StatementSourceReference ref, String rawArgument) {
        super(def, ref);
        this.rawArgument = def.support().internArgument(rawArgument);
    }

    public final String rawArgument() {
        return this.rawArgument;
    }

    @Override
    public Collection<? extends StatementContextBase<?, ?, ?>> mutableDeclaredSubstatements() {
        return (Collection)Verify.verifyNotNull((Object)this.substatements);
    }

    public final D declared() {
        D existing = this.declaredInstance;
        return existing != null ? existing : this.loadDeclared();
    }

    private @NonNull D loadDeclared() {
        ModelProcessingPhase phase = this.getCompletedPhase();
        Preconditions.checkState((phase == ModelProcessingPhase.FULL_DECLARATION || phase == ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0, (String)"Cannot build declared instance after phase %s", (Object)phase);
        this.declaredInstance = this.definition().getFactory().createDeclared((BoundStmtCtx)this, this.substatementsAsDeclared());
        return this.declaredInstance;
    }

    private @NonNull Stream<DeclaredStatement<?>> substatementsAsDeclared() {
        Stream<Object> stream = this.getImplicitDeclaredFlag() ? this.substatements.stream().map(AbstractResumedStatement::unmaskUndeclared) : this.substatements.stream();
        return stream.map(AbstractResumedStatement::declared);
    }

    public final StatementDefinition getDefinition() {
        return this.publicDefinition();
    }

    public final StatementSourceReference getSourceReference() {
        return this.sourceReference();
    }

    public final boolean isFullyDefined() {
        return this.fullyDefined();
    }

    @Override
    final E createEffective(StatementFactory<A, D, E> factory) {
        return this.createEffective(factory, this, this.streamDeclared(), this.streamEffective());
    }

    private @NonNull E createEffective(StatementFactory<A, D, E> factory, StatementContextBase<A, D, E> ctx, Stream<? extends StmtContext<?, ?, ?>> declared, Stream<? extends ReactorStmtCtx<?, ?, ?>> effective) {
        ctx.declared();
        return (E)factory.createEffective(ctx, declared, effective);
    }

    @Override
    final E createInferredEffective(StatementFactory<A, D, E> factory, InferredStatementContext<A, D, E> ctx, Stream<? extends ReactorStmtCtx<?, ?, ?>> declared, Stream<? extends ReactorStmtCtx<?, ?, ?>> effective) {
        return this.createEffective(factory, ctx, declared, effective);
    }

    final <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> AbstractResumedStatement<X, Y, Z> createSubstatement(int offset, StatementDefinitionContext<X, Y, Z> def, StatementSourceReference ref, String argument) {
        SubstatementContext<X, Y, Z> ret;
        ModelProcessingPhase inProgressPhase = this.getRoot().getSourceContext().getInProgressPhase();
        Preconditions.checkState((inProgressPhase != ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0, (String)"Declared statement cannot be added in effective phase at: %s", (Object)this.sourceReference());
        Optional<StatementSupport<?, ?, ?>> implicitParent = this.definition().getImplicitParentFor((NamespaceStmtCtx)this, def.getPublicView());
        if (implicitParent.isPresent()) {
            this.setImplicitDeclaredFlag();
            UndeclaredStmtCtx<X, X, X> parent = this.createUndeclared(offset, implicitParent.orElseThrow(), ref, argument);
            ret = new SubstatementContext<X, Y, Z>(parent, def, ref, argument);
            parent.addEffectiveSubstatement(ret);
        } else {
            ret = new SubstatementContext<X, Y, Z>(this, def, ref, argument);
            this.substatements = this.substatements.put(offset, ret);
        }
        def.onStatementAdded(ret);
        return ret;
    }

    private <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> UndeclaredStmtCtx<X, Y, Z> createUndeclared(int offset, StatementSupport<X, Y, Z> support, StatementSourceReference ref, String argument) {
        ImplicitStmtCtx<X, Y, Z> ret;
        Optional<StatementSupport<?, ?, ?>> implicitParent = this.definition().getImplicitParentFor((NamespaceStmtCtx)this, support.getPublicView());
        if (implicitParent.isPresent()) {
            UndeclaredStmtCtx<X, X, X> parent = this.createUndeclared(offset, implicitParent.orElseThrow(), ref, argument);
            ret = new ImplicitStmtCtx<X, Y, Z>((StatementContextBase<?, ?, ?>)parent, support, argument);
            parent.addEffectiveSubstatement(ret);
        } else {
            ret = new ImplicitStmtCtx<X, Y, Z>((StatementContextBase<?, ?, ?>)this, support, argument);
            this.substatements = this.substatements.put(offset, ret);
        }
        support.onStatementAdded(ret);
        return ret;
    }

    @Override
    final Stream<? extends @NonNull ReactorStmtCtx<?, ?, ?>> streamDeclared() {
        return this.substatements.stream().filter(StmtContext::isSupportedToBuildEffective);
    }

    @Override
    final void dropDeclaredSubstatements() {
        this.substatements = null;
    }

    final @Nullable AbstractResumedStatement<?, ?, ?> enterSubstatement(int offset) {
        OriginalStmtCtx<?, ?, ?> stmt = this.substatements.get(offset);
        return stmt == null ? null : AbstractResumedStatement.unmaskUndeclared(stmt);
    }

    private static @NonNull AbstractResumedStatement<?, ?, ?> unmaskUndeclared(ReactorStmtCtx<?, ?, ?> stmt) {
        ReactorStmtCtx<?, ?, ?> ret = stmt;
        while (!(ret instanceof AbstractResumedStatement)) {
            Verify.verify((boolean)(ret instanceof UndeclaredStmtCtx), (String)"Unexpectred statement %s", ret);
            ret = ((UndeclaredStmtCtx)ret).getResumedSubstatement();
        }
        return (AbstractResumedStatement)ret;
    }

    final @Nullable AbstractResumedStatement<?, ?, ?> exitStatement(ModelProcessingPhase phase) {
        this.finishDeclaration(phase);
        StmtContext.Mutable parent = this.getParentContext();
        if (parent == null) {
            return null;
        }
        OriginalStmtCtx<?, ?, ?> ret = AbstractResumedStatement.verifyParent(parent);
        while (!(ret instanceof AbstractResumedStatement)) {
            ret.finishDeclaration(phase);
            ret = AbstractResumedStatement.verifyParent(ret.getParentContext());
        }
        return (AbstractResumedStatement)ret;
    }

    private static OriginalStmtCtx<?, ?, ?> verifyParent(StatementContextBase<?, ?, ?> parent) {
        Verify.verify((boolean)(parent instanceof OriginalStmtCtx), (String)"Unexpected parent context %s", parent);
        return (OriginalStmtCtx)parent;
    }

    final void resizeSubstatements(int expectedSize) {
        this.substatements = this.substatements.ensureCapacity(expectedSize);
    }

    @Override
    final void declarationFinished(ModelProcessingPhase phase) {
        this.finishChildrenDeclaration(phase);
        this.finishDeclaration(phase);
    }

    private void finishChildrenDeclaration(ModelProcessingPhase phase) {
        Preconditions.checkState((boolean)this.isFullyDefined());
        this.substatements.forEach(stmt -> stmt.declarationFinished(phase));
    }
}

