/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SweptNamespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NamespaceStorageSupport
implements NamespaceBehaviour.NamespaceStorageNode {
    private static final Logger LOG = LoggerFactory.getLogger(NamespaceStorageSupport.class);
    private Map<Class<?>, Map<?, ?>> namespaces = ImmutableMap.of();

    NamespaceStorageSupport() {
    }

    public abstract NamespaceBehaviour.NamespaceStorageNode getParentNamespaceStorage();

    public abstract // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull NamespaceBehaviour.Registry getBehaviourRegistry();

    final void checkLocalNamespaceAllowed(Class<? extends ParserNamespace<?, ?>> type) {
    }

    protected <K, V, N extends ParserNamespace<K, V>> void onNamespaceElementAdded(Class<N> type, K key, V value) {
    }

    public final <K, V, N extends ParserNamespace<K, V>> Optional<Map.Entry<K, V>> getFromNamespace(Class<N> type, NamespaceKeyCriterion<K> criterion) {
        return this.getBehaviourRegistry().getNamespaceBehaviour(type).getFrom((NamespaceBehaviour.NamespaceStorageNode)this, criterion);
    }

    public final <K, V, N extends ParserNamespace<K, V>> Map<K, V> getNamespace(Class<N> type) {
        return this.getBehaviourRegistry().getNamespaceBehaviour(type).getAllFrom((NamespaceBehaviour.NamespaceStorageNode)this);
    }

    final <K, V, N extends ParserNamespace<K, V>> Map<K, V> getLocalNamespace(Class<N> type) {
        return this.accessNamespaces().get(type);
    }

    final <K, V, T extends K, U extends V, N extends ParserNamespace<K, V>> void addToNamespace(Class<N> type, T key, U value) {
        this.getBehaviourRegistry().getNamespaceBehaviour(type).addTo((NamespaceBehaviour.NamespaceStorageNode)this, key, value);
    }

    final <K, V, T extends K, U extends V, N extends ParserNamespace<K, V>> void addToNamespace(Class<N> type, Map<T, U> map) {
        NamespaceBehaviour behavior = this.getBehaviourRegistry().getNamespaceBehaviour(type);
        for (Map.Entry<T, U> validationBundle : map.entrySet()) {
            behavior.addTo((NamespaceBehaviour.NamespaceStorageNode)this, validationBundle.getKey(), validationBundle.getValue());
        }
    }

    public final <K, N extends StatementNamespace<K, ?, ?>> void addContextToNamespace(Class<N> type, K key, StmtContext<?, ?, ?> value) {
        this.getBehaviourRegistry().getNamespaceBehaviour(type).addTo((NamespaceBehaviour.NamespaceStorageNode)this, key, value);
    }

    public <K, V, N extends ParserNamespace<K, V>> V getFromLocalStorage(Class<N> type, K key) {
        Map<?, ?> localNamespace = this.accessNamespaces().get(type);
        return localNamespace == null ? null : (V)localNamespace.get(key);
    }

    public <K, V, N extends ParserNamespace<K, V>> Map<K, V> getAllFromLocalStorage(Class<N> type) {
        Map<?, ?> localNamespace = this.accessNamespaces().get(type);
        return localNamespace;
    }

    public <K, V, N extends ParserNamespace<K, V>> V putToLocalStorage(Class<N> type, K key, V value) {
        V ret = this.ensureLocalNamespace(type).put(key, value);
        this.onNamespaceElementAdded(type, key, value);
        return ret;
    }

    public <K, V, N extends ParserNamespace<K, V>> V putToLocalStorageIfAbsent(Class<N> type, K key, V value) {
        V ret = this.ensureLocalNamespace(type).putIfAbsent(key, value);
        if (ret == null) {
            this.onNamespaceElementAdded(type, key, value);
        }
        return ret;
    }

    void sweepNamespaces() {
        this.namespaces = null;
        LOG.trace("Swept namespace storages of {}", (Object)this);
    }

    void sweepNamespaces(Map<Class<?>, SweptNamespace> toWipe) {
        switch (this.namespaces.size()) {
            case 0: {
                this.namespaces = ImmutableMap.copyOf(toWipe);
                return;
            }
            case 1: {
                this.namespaces = new HashMap(this.namespaces);
                break;
            }
        }
        this.namespaces.putAll(toWipe);
        LOG.trace("Trimmed namespace storages of {} to {}", (Object)this, this.namespaces.keySet());
    }

    private Map<Class<?>, Map<?, ?>> accessNamespaces() {
        return (Map)Verify.verifyNotNull(this.namespaces, (String)"Attempted to access swept namespaces of %s", (Object[])new Object[]{this});
    }

    private <K, V, N extends ParserNamespace<K, V>> Map<K, V> ensureLocalNamespace(Class<N> type) {
        Map<?, ?> ret = this.accessNamespaces().get(type);
        if (ret == null) {
            this.checkLocalNamespaceAllowed(type);
            ret = new HashMap(1);
            switch (this.namespaces.size()) {
                case 0: {
                    this.namespaces = ImmutableMap.of(type, ret);
                    break;
                }
                case 1: {
                    HashMap newNamespaces = new HashMap(4);
                    Map.Entry<Class<?>, Map<?, ?>> entry = this.namespaces.entrySet().iterator().next();
                    newNamespaces.put(entry.getKey(), entry.getValue());
                    this.namespaces = newNamespaces;
                }
                default: {
                    this.namespaces.put(type, ret);
                }
            }
        }
        return ret;
    }
}

