/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementDefinitionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupportBundle;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupportNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.BelongsToModuleContext;
import org.opendaylight.yangtools.yang.parser.spi.source.BelongsToPrefixToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.ImpPrefixToNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportPrefixToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportedModuleContext;
import org.opendaylight.yangtools.yang.parser.spi.source.ModuleCtxToModuleQName;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModule;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModuleMap;
import org.opendaylight.yangtools.yang.parser.spi.source.QNameToStatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.source.QNameToStatementDefinitionMap;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.AbstractResumedStatement;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.BuildGlobalContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.ModifierImpl;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.RootStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextWriter;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SourceSpecificContext
implements NamespaceBehaviour.NamespaceStorageNode,
NamespaceBehaviour.Registry,
Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(SourceSpecificContext.class);
    private final Multimap<ModelProcessingPhase, ModifierImpl> modifiers = HashMultimap.create();
    private final QNameToStatementDefinitionMap qnameToStmtDefMap = new QNameToStatementDefinitionMap();
    private final SupportedStatements statementSupports = new SupportedStatements(this.qnameToStmtDefMap);
    private final PrefixToModuleMap prefixToModuleMap = new PrefixToModuleMap();
    private final @NonNull BuildGlobalContext globalContext;
    private StatementStreamSource source;
    private Collection<RootStatementContext<?, ?, ?>> importedNamespaces = ImmutableList.of();
    private RootStatementContext<?, ?, ?> root;
    private ModelProcessingPhase finishedPhase = ModelProcessingPhase.INIT;
    private ModelProcessingPhase inProgressPhase;
    private List<Map.Entry<ModelProcessingPhase, ModifierImpl>> delayedModifiers;

    SourceSpecificContext(BuildGlobalContext globalContext, StatementStreamSource source) {
        this.globalContext = Objects.requireNonNull(globalContext);
        this.source = Objects.requireNonNull(source);
    }

    @NonNull BuildGlobalContext globalContext() {
        return this.globalContext;
    }

    ModelProcessingPhase getInProgressPhase() {
        return this.inProgressPhase;
    }

    AbstractResumedStatement<?, ?, ?> createDeclaredChild(AbstractResumedStatement<?, ?, ?> current, int childId, QName name, String argument, StatementSourceReference ref) {
        StatementDefinitionContext<Object, Object, Object> def = this.globalContext.getStatementDefinition(this.getRootVersion(), name);
        if (def == null) {
            StatementSupport extension;
            def = this.globalContext.getModelDefinedStatementDefinition(name);
            if (def == null && (extension = this.qnameToStmtDefMap.get(name)) != null) {
                def = new StatementDefinitionContext(extension);
                this.globalContext.putModelDefinedStatementDefinition(name, def);
            }
        } else if (current != null) {
            def = current.definition().overrideDefinition(def);
        }
        if (((StatementDefinitionContext)InferenceException.throwIfNull(def, (StatementSourceReference)ref, (String)"Statement %s does not have type mapping defined.", (Object[])new Object[]{name})).getArgumentDefinition().isPresent()) {
            SourceException.throwIfNull((Object)argument, (StatementSourceReference)ref, (String)"Statement %s requires an argument", (Object[])new Object[]{name});
        } else {
            SourceException.throwIf((argument != null ? 1 : 0) != 0, (StatementSourceReference)ref, (String)"Statement %s does not take argument", (Object[])new Object[]{name});
        }
        if (def.hasArgumentSpecificSubDefinitions()) {
            def = def.getSubDefinitionSpecificForArgument(argument);
        }
        if (current != null) {
            return current.createSubstatement(childId, def, ref, argument);
        }
        if (this.root == null) {
            this.root = new RootStatementContext(this, def, ref, argument);
        } else if (!RootStatementContext.DEFAULT_VERSION.equals((Object)this.root.yangVersion()) && this.inProgressPhase == ModelProcessingPhase.SOURCE_LINKAGE) {
            this.root = new RootStatementContext<Object, Object, Object>(this, def, ref, argument, this.root.yangVersion(), this.root.getRootIdentifier());
        } else {
            QName rootStatement = this.root.definition().getStatementName();
            String rootArgument = this.root.rawArgument();
            Preconditions.checkState((Objects.equals(def.getStatementName(), rootStatement) && Objects.equals(argument, rootArgument) ? 1 : 0) != 0, (String)"Root statement was already defined as '%s %s'.", (Object)rootStatement, (Object)rootArgument);
        }
        return this.root;
    }

    RootStatementContext<?, ?, ?> getRoot() {
        return this.root;
    }

    YangVersion getRootVersion() {
        return this.root != null ? this.root.yangVersion() : RootStatementContext.DEFAULT_VERSION;
    }

    void startPhase(ModelProcessingPhase phase) {
        ModelProcessingPhase previousPhase = phase.getPreviousPhase();
        Verify.verify((boolean)Objects.equals(previousPhase, this.finishedPhase), (String)"Phase sequencing violation: previous phase should be %s, source %s has %s", (Object)previousPhase, (Object)this.source, (Object)this.finishedPhase);
        Collection previousModifiers = this.modifiers.get((Object)previousPhase);
        Preconditions.checkState((boolean)previousModifiers.isEmpty(), (String)"Previous phase %s has unresolved modifiers %s in source %s", (Object)previousPhase, (Object)previousModifiers, (Object)this.source);
        this.inProgressPhase = phase;
        LOG.debug("Source {} started phase {}", (Object)this.source, (Object)phase);
    }

    private void updateImportedNamespaces(Class<?> type, Object value) {
        if (BelongsToModuleContext.class.isAssignableFrom(type) || ImportedModuleContext.class.isAssignableFrom(type)) {
            if (this.importedNamespaces.isEmpty()) {
                this.importedNamespaces = new ArrayList(1);
            }
            Verify.verify((boolean)(value instanceof RootStatementContext));
            this.importedNamespaces.add((RootStatementContext)value);
        }
    }

    public <K, V, N extends ParserNamespace<K, V>> V putToLocalStorage(Class<N> type, K key, V value) {
        V ret = this.getRoot().putToLocalStorage(type, key, value);
        this.updateImportedNamespaces(type, value);
        return ret;
    }

    public <K, V, N extends ParserNamespace<K, V>> V putToLocalStorageIfAbsent(Class<N> type, K key, V value) {
        Object ret = this.getRoot().putToLocalStorageIfAbsent((Class)type, (Object)key, (Object)value);
        if (ret == null) {
            this.updateImportedNamespaces(type, value);
        }
        return (V)ret;
    }

    public NamespaceBehaviour.StorageNodeType getStorageNodeType() {
        return NamespaceBehaviour.StorageNodeType.SOURCE_LOCAL_SPECIAL;
    }

    public <K, V, N extends ParserNamespace<K, V>> V getFromLocalStorage(Class<N> type, K key) {
        Object potentialLocal = this.getRoot().getFromLocalStorage(type, key);
        if (potentialLocal != null) {
            return potentialLocal;
        }
        for (NamespaceBehaviour.NamespaceStorageNode namespaceStorageNode : this.importedNamespaces) {
            Object potential = namespaceStorageNode.getFromLocalStorage(type, key);
            if (potential == null) continue;
            return (V)potential;
        }
        return null;
    }

    public <K, V, N extends ParserNamespace<K, V>> Map<K, V> getAllFromLocalStorage(Class<N> type) {
        Map potentialLocal = this.getRoot().getAllFromLocalStorage(type);
        if (potentialLocal != null) {
            return potentialLocal;
        }
        for (NamespaceBehaviour.NamespaceStorageNode namespaceStorageNode : this.importedNamespaces) {
            Map potential = namespaceStorageNode.getAllFromLocalStorage(type);
            if (potential == null) continue;
            return potential;
        }
        return null;
    }

    public <K, V, N extends ParserNamespace<K, V>> NamespaceBehaviour<K, V, N> getNamespaceBehaviour(Class<N> type) {
        if (StatementSupportNamespace.class.equals(type)) {
            return this.statementSupports;
        }
        return this.globalContext.getNamespaceBehaviour((Class)type);
    }

    public BuildGlobalContext getParentNamespaceStorage() {
        return this.globalContext;
    }

    PhaseCompletionProgress tryToCompletePhase(byte executionOrder) {
        ModelProcessingPhase phase = (ModelProcessingPhase)Verify.verifyNotNull((Object)ModelProcessingPhase.ofExecutionOrder((byte)executionOrder));
        Collection currentPhaseModifiers = this.modifiers.get((Object)phase);
        boolean hasProgressed = this.tryToProgress(currentPhaseModifiers);
        boolean phaseCompleted = Objects.requireNonNull(this.root, "Malformed source. Valid root element is missing.").tryToCompletePhase(executionOrder);
        hasProgressed |= this.tryToProgress(currentPhaseModifiers);
        if (phaseCompleted && currentPhaseModifiers.isEmpty()) {
            this.finishedPhase = phase;
            LOG.debug("Source {} finished phase {}", (Object)this.source, (Object)phase);
            if (phase == ModelProcessingPhase.EFFECTIVE_MODEL) {
                LOG.trace("Releasing source {}", (Object)this.source);
                this.source = null;
            }
            return PhaseCompletionProgress.FINISHED;
        }
        return hasProgressed ? PhaseCompletionProgress.PROGRESS : PhaseCompletionProgress.NO_PROGRESS;
    }

    private boolean tryToProgress(Collection<ModifierImpl> currentPhaseModifiers) {
        boolean hasProgressed = false;
        this.delayedModifiers = List.of();
        Iterator<ModifierImpl> modifier = currentPhaseModifiers.iterator();
        while (modifier.hasNext()) {
            if (!modifier.next().tryApply()) continue;
            modifier.remove();
            hasProgressed = true;
        }
        if (!this.delayedModifiers.isEmpty()) {
            Verify.verify((boolean)hasProgressed, (String)"Delayed modifiers encountered without making progress in %s", (Object)this);
            for (Map.Entry<ModelProcessingPhase, ModifierImpl> entry : this.delayedModifiers) {
                this.modifiers.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        this.delayedModifiers = null;
        return hasProgressed;
    }

    @NonNull ModelActionBuilder newInferenceAction(@NonNull ModelProcessingPhase phase) {
        ModifierImpl action = new ModifierImpl();
        if (this.delayedModifiers != null) {
            if (this.delayedModifiers.isEmpty()) {
                this.delayedModifiers = new ArrayList<Map.Entry<ModelProcessingPhase, ModifierImpl>>(2);
            }
            this.delayedModifiers.add(Map.entry(phase, action));
        } else {
            this.modifiers.put((Object)phase, (Object)action);
        }
        return action;
    }

    public String toString() {
        return "SourceSpecificContext [source=" + this.source + ", current=" + this.inProgressPhase + ", finished=" + this.finishedPhase + "]";
    }

    Optional<SourceException> failModifiers(ModelProcessingPhase identifier) {
        ArrayList<SourceException> exceptions = new ArrayList<SourceException>();
        for (ModifierImpl mod : this.modifiers.get((Object)identifier)) {
            try {
                mod.failModifier();
            }
            catch (SourceException e) {
                exceptions.add(e);
            }
        }
        switch (exceptions.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of((SourceException)((Object)exceptions.get(0)));
            }
        }
        String message = String.format("Yang model processing phase %s failed", identifier);
        InferenceException ex = new InferenceException(message, this.root, (Throwable)exceptions.get(0));
        exceptions.listIterator(1).forEachRemaining(arg_0 -> ex.addSuppressed(arg_0));
        return Optional.of(ex);
    }

    void loadStatements() {
        LOG.trace("Source {} loading statements for phase {}", (Object)this.source, (Object)this.inProgressPhase);
        switch (this.inProgressPhase) {
            case SOURCE_PRE_LINKAGE: {
                this.source.writePreLinkage((StatementWriter)new StatementContextWriter(this, this.inProgressPhase), this.stmtDef());
                break;
            }
            case SOURCE_LINKAGE: {
                this.source.writeLinkage((StatementWriter)new StatementContextWriter(this, this.inProgressPhase), this.stmtDef(), this.preLinkagePrefixes(), this.getRootVersion());
                break;
            }
            case STATEMENT_DEFINITION: {
                this.source.writeLinkageAndStatementDefinitions((StatementWriter)new StatementContextWriter(this, this.inProgressPhase), this.stmtDef(), this.prefixes(), this.getRootVersion());
                break;
            }
            case FULL_DECLARATION: {
                this.source.writeFull((StatementWriter)new StatementContextWriter(this, this.inProgressPhase), this.stmtDef(), this.prefixes(), this.getRootVersion());
                break;
            }
        }
    }

    private PrefixToModule preLinkagePrefixes() {
        PrefixToModuleMap preLinkagePrefixes = new PrefixToModuleMap();
        Map<String, XMLNamespace> prefixToNamespaceMap = this.getAllFromLocalStorage(ImpPrefixToNamespace.class);
        if (prefixToNamespaceMap == null) {
            return null;
        }
        prefixToNamespaceMap.forEach((key, value) -> preLinkagePrefixes.put(key, QNameModule.create((XMLNamespace)value)));
        return preLinkagePrefixes;
    }

    private PrefixToModule prefixes() {
        Map allBelongsTo;
        Map allImports = this.getRoot().getAllFromNamespace(ImportPrefixToModuleCtx.class);
        if (allImports != null) {
            allImports.forEach((key, value) -> this.prefixToModuleMap.put(key, (QNameModule)this.getRoot().getFromNamespace(ModuleCtxToModuleQName.class, value)));
        }
        if ((allBelongsTo = this.getRoot().getAllFromNamespace(BelongsToPrefixToModuleCtx.class)) != null) {
            allBelongsTo.forEach((key, value) -> this.prefixToModuleMap.put(key, (QNameModule)this.getRoot().getFromNamespace(ModuleCtxToModuleQName.class, value)));
        }
        return this.prefixToModuleMap;
    }

    private QNameToStatementDefinition stmtDef() {
        StatementSupportBundle supportsForPhase = this.globalContext.getSupportsForPhase(this.inProgressPhase);
        this.qnameToStmtDefMap.putAll((Map)supportsForPhase.getCommonDefinitions());
        this.qnameToStmtDefMap.putAll((Map)supportsForPhase.getDefinitionsSpecificForVersion(this.getRootVersion()));
        if (this.inProgressPhase != ModelProcessingPhase.FULL_DECLARATION) {
            return this.qnameToStmtDefMap;
        }
        Map<QName, StatementSupport> extensions = this.globalContext.getNamespace(StatementDefinitionNamespace.class);
        if (extensions != null) {
            extensions.forEach((qname, support) -> {
                StatementSupport existing = this.qnameToStmtDefMap.putIfAbsent(qname, support);
                if (existing != null) {
                    LOG.debug("Source {} already defines statement {} as {}", new Object[]{this.source, qname, existing});
                } else {
                    LOG.debug("Source {} defined statement {} as {}", new Object[]{this.source, qname, support});
                }
            });
        }
        return this.qnameToStmtDefMap;
    }

    Collection<SourceIdentifier> getRequiredSources() {
        return this.root.getRequiredSources();
    }

    SourceIdentifier getRootIdentifier() {
        return this.root.getRootIdentifier();
    }

    private static final class SupportedStatements
    extends NamespaceBehaviour<QName, StatementSupport<?, ?, ?>, StatementSupportNamespace> {
        private final QNameToStatementDefinitionMap statementDefinitions;

        SupportedStatements(QNameToStatementDefinitionMap statementDefinitions) {
            super(StatementSupportNamespace.class);
            this.statementDefinitions = Objects.requireNonNull(statementDefinitions);
        }

        public StatementSupport<?, ?, ?> getFrom(NamespaceBehaviour.NamespaceStorageNode storage, QName key) {
            return this.statementDefinitions.get(key);
        }

        public Map<QName, StatementSupport<?, ?, ?>> getAllFrom(NamespaceBehaviour.NamespaceStorageNode storage) {
            throw new UnsupportedOperationException("StatementSupportNamespace is immutable");
        }

        public void addTo(NamespaceBehaviour.NamespaceStorageNode storage, QName key, StatementSupport<?, ?, ?> value) {
            throw new UnsupportedOperationException("StatementSupportNamespace is immutable");
        }
    }

    static enum PhaseCompletionProgress {
        NO_PROGRESS,
        PROGRESS,
        FINISHED;

    }
}

