/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.AbstractResumedStatement;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.OriginalStmtCtx;

abstract class StatementMap
extends AbstractCollection<OriginalStmtCtx<?, ?, ?>> {
    private static final @NonNull StatementMap EMPTY = new Empty();

    StatementMap() {
    }

    static @NonNull StatementMap empty() {
        return EMPTY;
    }

    abstract @Nullable OriginalStmtCtx<?, ?, ?> get(int var1);

    abstract @NonNull StatementMap put(int var1, @NonNull OriginalStmtCtx<?, ?, ?> var2);

    abstract @NonNull StatementMap ensureCapacity(int var1);

    private static final class Singleton
    extends StatementMap {
        private final OriginalStmtCtx<?, ?, ?> object;

        Singleton(OriginalStmtCtx<?, ?, ?> object) {
            this.object = Objects.requireNonNull(object);
        }

        @Override
        OriginalStmtCtx<?, ?, ?> get(int index) {
            return index == 0 ? this.object : null;
        }

        @Override
        StatementMap put(int index, OriginalStmtCtx<?, ?, ?> obj) {
            Preconditions.checkArgument((index != 0 ? 1 : 0) != 0);
            return new Regular(this.object, index, obj);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        StatementMap ensureCapacity(int expectedLimit) {
            return expectedLimit < 2 ? this : new Regular(expectedLimit, 0, this.object);
        }

        @Override
        public Iterator<OriginalStmtCtx<?, ?, ?>> iterator() {
            return Iterators.singletonIterator(this.object);
        }
    }

    private static final class Regular
    extends StatementMap {
        private OriginalStmtCtx<?, ?, ?>[] elements;
        private int size;

        Regular(int expectedLimit) {
            this.elements = new OriginalStmtCtx[expectedLimit];
        }

        Regular(int index, OriginalStmtCtx<?, ?, ?> object) {
            this(index + 1, index, object);
        }

        Regular(OriginalStmtCtx<?, ?, ?> object0, int index, OriginalStmtCtx<?, ?, ?> object) {
            this(index + 1, 0, object0);
            this.elements[index] = Objects.requireNonNull(object);
            this.size = 2;
        }

        Regular(int expectedLimit, int index, OriginalStmtCtx<?, ?, ?> object) {
            this(expectedLimit);
            this.elements[index] = Objects.requireNonNull(object);
            this.size = 1;
        }

        @Override
        OriginalStmtCtx<?, ?, ?> get(int index) {
            return index >= this.elements.length ? null : this.elements[index];
        }

        @Override
        StatementMap put(int index, OriginalStmtCtx<?, ?, ?> obj) {
            if (index < this.elements.length) {
                Preconditions.checkArgument((this.elements[index] == null ? 1 : 0) != 0);
            } else {
                this.elements = Arrays.copyOf(this.elements, index + 1);
            }
            this.elements[index] = Objects.requireNonNull(obj);
            ++this.size;
            return this;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        StatementMap ensureCapacity(int expectedLimit) {
            if (this.elements.length < expectedLimit) {
                this.elements = Arrays.copyOf(this.elements, expectedLimit);
            }
            return this;
        }

        @Override
        public Iterator<OriginalStmtCtx<?, ?, ?>> iterator() {
            return new Iter(this);
        }

        private static final class Iter
        extends AbstractIterator<OriginalStmtCtx<?, ?, ?>> {
            private int nextOffset = 0;
            private Regular map;

            Iter(Regular map) {
                this.map = Objects.requireNonNull(map);
            }

            protected OriginalStmtCtx<?, ?, ?> computeNext() {
                while (this.nextOffset < this.map.elements.length) {
                    OriginalStmtCtx<?, ?, ?> ret;
                    if ((ret = this.map.elements[this.nextOffset++]) == null) continue;
                    return ret;
                }
                this.map = null;
                return (OriginalStmtCtx)this.endOfData();
            }
        }
    }

    private static final class Empty
    extends StatementMap {
        private static final Iterator<OriginalStmtCtx<?, ?, ?>> EMPTY_ITERATOR;

        private Empty() {
        }

        AbstractResumedStatement<?, ?, ?> get(int index) {
            return null;
        }

        @Override
        StatementMap put(int index, OriginalStmtCtx<?, ?, ?> obj) {
            return index == 0 ? new Singleton(obj) : new Regular(index, obj);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        StatementMap ensureCapacity(int expectedLimit) {
            return expectedLimit < 2 ? this : new Regular(expectedLimit);
        }

        @Override
        public void forEach(Consumer<? super OriginalStmtCtx<?, ?, ?>> action) {
        }

        @Override
        public Iterator<OriginalStmtCtx<?, ?, ?>> iterator() {
            return EMPTY_ITERATOR;
        }

        static {
            Iterator<OriginalStmtCtx<?, ?, ?>> it = new Regular(0).iterator();
            Verify.verify((!it.hasNext() ? 1 : 0) != 0);
            EMPTY_ITERATOR = it;
        }
    }
}

