/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@Beta
@NonNullByDefault
public final class DefaultDOMRpcResult
implements DOMRpcResult,
Immutable,
Serializable {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Interfaces do not specify Serializable")
    private final @Nullable NormalizedNode result;
    private final Collection<? extends RpcError> errors;

    public DefaultDOMRpcResult(NormalizedNode result, RpcError ... errors) {
        this(result, DefaultDOMRpcResult.asCollection(errors));
    }

    public DefaultDOMRpcResult(RpcError ... errors) {
        this(null, DefaultDOMRpcResult.asCollection(errors));
    }

    public DefaultDOMRpcResult(@Nullable NormalizedNode result) {
        this(result, Collections.emptyList());
    }

    public DefaultDOMRpcResult(@Nullable NormalizedNode result, Collection<? extends RpcError> errors) {
        this.result = result;
        this.errors = Objects.requireNonNull(errors);
    }

    public DefaultDOMRpcResult(Collection<RpcError> errors) {
        this(null, errors);
    }

    private static Collection<RpcError> asCollection(RpcError ... errors) {
        return errors.length == 0 ? Collections.emptyList() : Arrays.asList(errors);
    }

    public Collection<? extends RpcError> getErrors() {
        return this.errors;
    }

    public @Nullable NormalizedNode getResult() {
        return this.result;
    }

    public int hashCode() {
        int ret = this.errors.hashCode();
        if (this.result != null) {
            ret = 31 * ret + this.result.hashCode();
        }
        return ret;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultDOMRpcResult)) {
            return false;
        }
        DefaultDOMRpcResult other = (DefaultDOMRpcResult)obj;
        return this.errors.equals(other.errors) && Objects.equals(this.result, other.result);
    }
}

